/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.exp.parser;

import java.util.Collection;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.parser.ASTAggregateFunctionCall;

public class ASTAvg
extends ASTAggregateFunctionCall {
    ASTAvg(int id) {
        super(id, "AVG");
    }

    public ASTAvg(Expression expression) {
        super(50, "AVG", expression);
    }

    @Override
    public Expression shallowCopy() {
        return new ASTAvg(this.id);
    }

    @Override
    protected Object evaluateCollection(Collection<?> values) {
        if (values.isEmpty()) {
            return 0.0;
        }
        double sum = 0.0;
        for (Object value : values) {
            if (value instanceof Number) {
                sum += ((Number)value).doubleValue();
                continue;
            }
            throw new UnsupportedOperationException("Can't calculate average for non-numeric type.");
        }
        return sum / (double)values.size();
    }
}

