/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access.flush;

import java.util.Objects;
import java.util.function.Supplier;
import org.apache.cayenne.ObjectId;
import org.apache.cayenne.access.types.InternalUnsupportedTypeFactory;

class ObjectIdValueSupplier
implements Supplier<Object>,
InternalUnsupportedTypeFactory.Marker {
    private final ObjectId id;
    private final String attribute;

    static Object getFor(ObjectId id, String attribute) {
        Object value = id.getIdSnapshot().get(attribute);
        if (value != null) {
            return value;
        }
        return new ObjectIdValueSupplier(id, attribute);
    }

    private ObjectIdValueSupplier(ObjectId id, String attribute) {
        this.id = Objects.requireNonNull(id);
        this.attribute = Objects.requireNonNull(attribute);
    }

    @Override
    public Object get() {
        return this.id.getIdSnapshot().get(this.attribute);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ObjectIdValueSupplier that = (ObjectIdValueSupplier)o;
        if (!this.id.equals(that.id)) {
            return false;
        }
        return this.attribute.equals(that.attribute);
    }

    public int hashCode() {
        return 31 * this.id.hashCode() + this.attribute.hashCode();
    }

    public String toString() {
        return "{id=" + String.valueOf(this.id) + ", attr=" + this.attribute + "}";
    }

    @Override
    public String errorMessage() {
        return "Value supplier is not resolved before usage.";
    }
}

