/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access.flush.operation;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.cayenne.access.flush.operation.DbRowOp;

class DbRowOpGraph {
    private final Map<DbRowOp, List<DbRowOp>> neighbors = new LinkedHashMap<DbRowOp, List<DbRowOp>>();

    DbRowOpGraph() {
    }

    void add(DbRowOp vertex) {
        this.neighbors.putIfAbsent(vertex, new ArrayList(0));
    }

    void add(DbRowOp from, DbRowOp to) {
        this.neighbors.computeIfAbsent(from, k -> new ArrayList(4)).add(to);
        this.add(to);
    }

    private Map<DbRowOp, Integer> inDegree() {
        LinkedHashMap<DbRowOp, Integer> result = new LinkedHashMap<DbRowOp, Integer>(this.neighbors.size());
        this.neighbors.forEach((from, neighbors) -> {
            neighbors.forEach(to -> result.compute((DbRowOp)to, (k, old) -> {
                if (old == null) {
                    return 1;
                }
                return old + 1;
            }));
            result.putIfAbsent((DbRowOp)from, 0);
        });
        return result;
    }

    List<DbRowOp> topSort() {
        Map<DbRowOp, Integer> degree = this.inDegree();
        ArrayDeque zeroDegree = new ArrayDeque(this.neighbors.size() / 2);
        ArrayList<DbRowOp> result = new ArrayList<DbRowOp>(this.neighbors.size());
        degree.forEach((k, v) -> {
            if (v == 0) {
                zeroDegree.push(k);
            }
        });
        while (!zeroDegree.isEmpty()) {
            DbRowOp v2 = (DbRowOp)zeroDegree.removeFirst();
            result.add(v2);
            this.neighbors.get(v2).forEach(neighbor -> degree.computeIfPresent((DbRowOp)neighbor, (k, oldValue) -> {
                int newValue = oldValue = Integer.valueOf(oldValue - 1);
                if (newValue == 0) {
                    zeroDegree.addLast(neighbor);
                }
                return newValue;
            }));
        }
        if (result.size() != this.neighbors.size()) {
            HashSet<DbRowOp> remainingKeys = new HashSet<DbRowOp>(this.neighbors.keySet());
            remainingKeys.removeIf(result::contains);
            throw new IllegalStateException("Cycle detected in list for keys: " + String.valueOf(remainingKeys));
        }
        Collections.reverse(result);
        return result;
    }
}

