/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.configuration.xml;

import org.apache.cayenne.configuration.xml.EmbeddableAttributeHandler;
import org.apache.cayenne.configuration.xml.NamespaceAwareNestedTagHandler;
import org.apache.cayenne.exp.ExpressionException;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.cayenne.map.CallbackDescriptor;
import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.map.ObjAttribute;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.util.Util;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class ObjEntityHandler
extends NamespaceAwareNestedTagHandler {
    private static final Logger logger = LoggerFactory.getLogger(ObjEntityHandler.class);
    private static final String OBJ_ENTITY_TAG = "obj-entity";
    private static final String OBJ_ATTRIBUTE_TAG = "obj-attribute";
    private static final String OBJ_ATTRIBUTE_OVERRIDE_TAG = "attribute-override";
    private static final String EMBEDDED_ATTRIBUTE_TAG = "embedded-attribute";
    private static final String QUALIFIER_TAG = "qualifier";
    private static final String POST_ADD_TAG = "post-add";
    private static final String PRE_PERSIST_TAG = "pre-persist";
    private static final String POST_PERSIST_TAG = "post-persist";
    private static final String PRE_UPDATE_TAG = "pre-update";
    private static final String POST_UPDATE_TAG = "post-update";
    private static final String PRE_REMOVE_TAG = "pre-remove";
    private static final String POST_REMOVE_TAG = "post-remove";
    private static final String POST_LOAD_TAG = "post-load";
    private DataMap map;
    private ObjEntity entity;
    private ObjAttribute lastAttribute;

    public ObjEntityHandler(NamespaceAwareNestedTagHandler parentHandler, DataMap map) {
        super(parentHandler);
        this.map = map;
    }

    @Override
    protected boolean processElement(String namespaceURI, String localName, Attributes attributes) throws SAXException {
        switch (localName) {
            case "obj-entity": {
                this.createObjEntity(attributes);
                return true;
            }
            case "obj-attribute": {
                this.createObjAttribute(attributes);
                return true;
            }
            case "attribute-override": {
                this.processStartAttributeOverride(attributes);
                return true;
            }
            case "qualifier": {
                return true;
            }
            case "post-add": 
            case "pre-persist": 
            case "post-persist": 
            case "pre-update": 
            case "post-update": 
            case "pre-remove": 
            case "post-remove": 
            case "post-load": {
                this.createCallback(localName, attributes);
                return true;
            }
        }
        return false;
    }

    @Override
    protected ContentHandler createChildTagHandler(String namespaceURI, String localName, String qName, Attributes attributes) {
        if (namespaceURI.equals(this.targetNamespace)) {
            switch (localName) {
                case "embedded-attribute": {
                    return new EmbeddableAttributeHandler(this, this.entity);
                }
            }
        }
        return super.createChildTagHandler(namespaceURI, localName, qName, attributes);
    }

    @Override
    protected boolean processCharData(String localName, String data) {
        switch (localName) {
            case "qualifier": {
                this.createQualifier(data);
            }
        }
        return true;
    }

    private void createObjEntity(Attributes attributes) {
        String superEntityName;
        this.entity = new ObjEntity(attributes.getValue("name"));
        this.entity.setClassName(attributes.getValue("className"));
        this.entity.setAbstract("true".equalsIgnoreCase(attributes.getValue("abstract")));
        this.entity.setReadOnly("true".equalsIgnoreCase(attributes.getValue("readOnly")));
        if ("optimistic".equals(attributes.getValue("", "lock-type"))) {
            this.entity.setDeclaredLockType(1);
        }
        if ((superEntityName = attributes.getValue("superEntityName")) != null) {
            this.entity.setSuperEntityName(superEntityName);
        } else {
            this.entity.setSuperClassName(attributes.getValue("superClassName"));
        }
        this.entity.setDbEntityName(attributes.getValue("dbEntityName"));
        this.map.addObjEntity(this.entity);
    }

    private void createObjAttribute(Attributes attributes) {
        String dbPath = attributes.getValue("db-attribute-path");
        if (dbPath == null) {
            dbPath = attributes.getValue("db-attribute-name");
        }
        this.lastAttribute = new ObjAttribute(attributes.getValue("name"));
        this.lastAttribute.setType(attributes.getValue("type"));
        this.lastAttribute.setUsedForLocking("true".equalsIgnoreCase(attributes.getValue("lock")));
        this.lastAttribute.setLazy("true".equalsIgnoreCase(attributes.getValue("lazy")));
        this.lastAttribute.setDbAttributePath(dbPath);
        this.entity.addAttribute(this.lastAttribute);
    }

    private void processStartAttributeOverride(Attributes attributes) {
        this.entity.addAttributeOverride(attributes.getValue("name"), attributes.getValue("db-attribute-path"));
    }

    private CallbackDescriptor getCallbackDescriptor(String type) {
        if (this.entity == null) {
            return null;
        }
        switch (type) {
            case "post-add": {
                return this.entity.getCallbackMap().getPostAdd();
            }
            case "pre-persist": {
                return this.entity.getCallbackMap().getPrePersist();
            }
            case "post-persist": {
                return this.entity.getCallbackMap().getPostPersist();
            }
            case "pre-update": {
                return this.entity.getCallbackMap().getPreUpdate();
            }
            case "post-update": {
                return this.entity.getCallbackMap().getPostUpdate();
            }
            case "pre-remove": {
                return this.entity.getCallbackMap().getPreRemove();
            }
            case "post-remove": {
                return this.entity.getCallbackMap().getPostRemove();
            }
            case "post-load": {
                return this.entity.getCallbackMap().getPostLoad();
            }
        }
        return null;
    }

    private void createCallback(String type, Attributes attributes) {
        String methodName = attributes.getValue("method-name");
        CallbackDescriptor descriptor = this.getCallbackDescriptor(type);
        if (descriptor != null) {
            descriptor.addCallbackMethod(methodName);
        }
    }

    private void createQualifier(String qualifier) {
        if (Util.isBlank(qualifier)) {
            return;
        }
        if (this.entity != null) {
            try {
                this.entity.setDeclaredQualifier(ExpressionFactory.exp(qualifier, new Object[0]));
            }
            catch (ExpressionException ex) {
                logger.warn("Unable to parse entity " + this.entity.getName() + " qualifier", (Throwable)ex);
            }
        }
    }

    public ObjEntity getEntity() {
        return this.entity;
    }

    public ObjAttribute getLastAttribute() {
        return this.lastAttribute;
    }
}

