/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.editor.cgen.templateeditor;

import org.apache.cayenne.gen.CgenConfiguration;
import org.apache.cayenne.gen.CgenTemplate;
import org.apache.cayenne.gen.TemplateType;

public class EditorTemplateSaver {
    private final CgenConfiguration configuration;

    public EditorTemplateSaver(CgenConfiguration configuration) {
        this.configuration = configuration;
    }

    public void save(TemplateType type, Boolean isTemplateDefault, String templateText) {
        if (this.configuration.isMakePairs() || !isTemplateDefault.booleanValue()) {
            this.setTemplate(type, isTemplateDefault, templateText);
        } else {
            this.setDefaultSingleTemplate(type);
        }
    }

    private void setTemplate(TemplateType templateType, Boolean isDefault, String templateText) {
        String template = isDefault != false ? templateType.pathFromSourceRoot() : templateText;
        switch (templateType) {
            case ENTITY_SUPERCLASS: {
                this.configuration.setSuperTemplate(new CgenTemplate(template, isDefault, TemplateType.ENTITY_SUPERCLASS));
                break;
            }
            case ENTITY_SUBCLASS: {
                this.configuration.setTemplate(new CgenTemplate(template, isDefault, TemplateType.ENTITY_SUBCLASS));
                break;
            }
            case EMBEDDABLE_SUPERCLASS: {
                this.configuration.setEmbeddableSuperTemplate(new CgenTemplate(template, isDefault, TemplateType.EMBEDDABLE_SUPERCLASS));
                break;
            }
            case EMBEDDABLE_SUBCLASS: {
                this.configuration.setEmbeddableTemplate(new CgenTemplate(template, isDefault, TemplateType.EMBEDDABLE_SUBCLASS));
                break;
            }
            case DATAMAP_SUPERCLASS: {
                this.configuration.setDataMapSuperTemplate(new CgenTemplate(template, isDefault, TemplateType.DATAMAP_SUPERCLASS));
                break;
            }
            case DATAMAP_SUBCLASS: {
                this.configuration.setDataMapTemplate(new CgenTemplate(template, isDefault, TemplateType.DATAMAP_SUBCLASS));
                break;
            }
            default: {
                throw new IllegalStateException("Illegal template type for for nonSingle template " + String.valueOf((Object)templateType));
            }
        }
    }

    private void setDefaultSingleTemplate(TemplateType templateType) {
        switch (templateType) {
            case ENTITY_SUBCLASS: {
                this.configuration.setTemplate(TemplateType.ENTITY_SINGLE_CLASS.defaultTemplate());
                break;
            }
            case EMBEDDABLE_SUBCLASS: {
                this.configuration.setEmbeddableTemplate(TemplateType.EMBEDDABLE_SINGLE_CLASS.defaultTemplate());
                break;
            }
            case DATAMAP_SUBCLASS: {
                this.configuration.setDataMapTemplate(TemplateType.DATAMAP_SINGLE_CLASS.defaultTemplate());
                break;
            }
            default: {
                throw new IllegalStateException("Illegal template type for single template " + String.valueOf((Object)templateType));
            }
        }
    }
}

