/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.util;

import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionException;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.cayenne.exp.parser.ParseException;
import org.apache.cayenne.util.Util;

public class ExpressionConvertor {
    public String valueAsString(Object value) throws IllegalArgumentException {
        if (value == null) {
            return null;
        }
        if (!(value instanceof Expression)) {
            throw new IllegalArgumentException("Unsupported value class: " + value.getClass().getName());
        }
        return value.toString();
    }

    public Object stringAsValue(String string) throws IllegalArgumentException {
        if (string == null || string.trim().length() == 0) {
            return null;
        }
        try {
            return ExpressionFactory.exp(string, new Object[0]);
        }
        catch (ExpressionException eex) {
            Throwable cause = Util.unwindException(eex);
            Object message = cause instanceof ParseException ? cause.getMessage() : "Invalid expression: " + string;
            throw new IllegalArgumentException((String)message);
        }
    }

    public boolean supportsStringAsValue() {
        return true;
    }
}

