/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.action;

import java.awt.Toolkit;
import java.awt.datatransfer.FlavorEvent;
import java.awt.datatransfer.FlavorListener;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.util.HashMap;
import java.util.List;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;
import org.apache.cayenne.access.DataDomain;
import org.apache.cayenne.access.DataNode;
import org.apache.cayenne.map.Attribute;
import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.map.DbAttribute;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.map.DbRelationship;
import org.apache.cayenne.map.Embeddable;
import org.apache.cayenne.map.EmbeddableAttribute;
import org.apache.cayenne.map.ObjAttribute;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.map.ObjRelationship;
import org.apache.cayenne.map.Procedure;
import org.apache.cayenne.map.ProcedureParameter;
import org.apache.cayenne.map.Relationship;
import org.apache.cayenne.modeler.Application;
import org.apache.cayenne.modeler.ProjectController;
import org.apache.cayenne.modeler.action.CreateAttributeAction;
import org.apache.cayenne.modeler.action.CreateDbEntityAction;
import org.apache.cayenne.modeler.action.CreateEmbeddableAction;
import org.apache.cayenne.modeler.action.CreateObjEntityAction;
import org.apache.cayenne.modeler.action.CreateProcedureAction;
import org.apache.cayenne.modeler.action.CreateProcedureParameterAction;
import org.apache.cayenne.modeler.action.CreateRelationshipAction;
import org.apache.cayenne.modeler.dialog.ErrorDebugDialog;
import org.apache.cayenne.modeler.dialog.query.QueryTypeController;
import org.apache.cayenne.modeler.undo.PasteCompoundUndoableEdit;
import org.apache.cayenne.modeler.undo.PasteUndoableEdit;
import org.apache.cayenne.modeler.util.CayenneAction;
import org.apache.cayenne.modeler.util.CayenneTransferable;
import org.apache.cayenne.project.ProjectPath;
import org.apache.cayenne.query.AbstractQuery;
import org.apache.cayenne.query.Query;

public class PasteAction
extends CayenneAction
implements FlavorListener {
    private static final String COPY_PREFIX = "Copy of ";

    public static String getActionName() {
        return "Paste";
    }

    public PasteAction(Application application) {
        super(PasteAction.getActionName(), application);
        Toolkit.getDefaultToolkit().getSystemClipboard().addFlavorListener(this);
    }

    public String getIconName() {
        return "icon-paste.gif";
    }

    public KeyStroke getAcceleratorKey() {
        return KeyStroke.getKeyStroke(86, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask());
    }

    public void performAction(ActionEvent e) {
        try {
            Object content = Toolkit.getDefaultToolkit().getSystemClipboard().getData(CayenneTransferable.CAYENNE_FLAVOR);
            Object currentObject = this.getProjectController().getCurrentObject();
            if (content != null && currentObject != null) {
                PasteCompoundUndoableEdit undoableEdit = new PasteCompoundUndoableEdit();
                DataDomain domain = this.getProjectController().getCurrentDataDomain();
                DataMap map = this.getProjectController().getCurrentDataMap();
                if (content instanceof List) {
                    for (Object o : (List)content) {
                        this.paste(currentObject, o);
                        undoableEdit.addEdit(new PasteUndoableEdit(domain, map, currentObject, o));
                    }
                } else {
                    this.paste(currentObject, content);
                    undoableEdit.addEdit(new PasteUndoableEdit(domain, map, currentObject, content));
                }
                this.application.getUndoManager().addEdit(undoableEdit);
            }
        }
        catch (UnsupportedFlavorException ufe) {
        }
        catch (Exception ex) {
            ErrorDebugDialog.guiException(ex);
        }
    }

    private void paste(Object where, Object content) {
        this.paste(where, content, this.getProjectController().getCurrentDataDomain(), this.getProjectController().getCurrentDataMap());
    }

    public void paste(Object where, Object content, DataDomain domain, DataMap map) {
        ProjectController mediator = this.getProjectController();
        if (this.isTreeLeaf(where) && this.isTreeLeaf(content)) {
            where = mediator.getCurrentDataMap();
        }
        if ((where instanceof DataDomain || where instanceof DataNode) && content instanceof DataMap) {
            String oldName;
            DataMap dataMap = (DataMap)content;
            dataMap.setName(this.getFreeName(new DataMapNameChecker(domain), dataMap.getName()));
            HashMap<String, String> renamedDbEntities = new HashMap<String, String>();
            HashMap<String, String> renamedObjEntities = new HashMap<String, String>();
            HashMap<String, String> renamedEmbeddables = new HashMap<String, String>();
            for (DbEntity dbEntity : dataMap.getDbEntities()) {
                oldName = dbEntity.getName();
                dbEntity.setName(this.getFreeName(new DbEntityNameChecker(domain), dbEntity.getName()));
                if (oldName.equals(dbEntity.getName())) continue;
                renamedDbEntities.put(oldName, dbEntity.getName());
            }
            for (ObjEntity objEntity : dataMap.getObjEntities()) {
                oldName = objEntity.getName();
                objEntity.setName(this.getFreeName(new ObjEntityNameChecker(domain), objEntity.getName()));
                if (oldName.equals(objEntity.getName())) continue;
                renamedObjEntities.put(oldName, objEntity.getName());
            }
            for (Embeddable embeddable : dataMap.getEmbeddables()) {
                oldName = embeddable.getClassName();
                embeddable.setClassName(this.getFreeName(new EmbeddableNameChecker(domain), embeddable.getClassName()));
                if (oldName.equals(embeddable.getClassName())) continue;
                renamedEmbeddables.put(oldName, embeddable.getClassName());
            }
            for (Procedure procedure : dataMap.getProcedures()) {
                procedure.setName(this.getFreeName(new ProcedureNameChecker(domain), procedure.getName()));
            }
            for (Query query : dataMap.getQueries()) {
                ((AbstractQuery)query).setName(this.getFreeName(new QueryNameChecker(domain), query.getName()));
            }
            for (DbEntity dbEntity : dataMap.getDbEntities()) {
                for (DbRelationship rel : dbEntity.getRelationships()) {
                    if (!renamedDbEntities.containsKey(rel.getTargetEntityName())) continue;
                    rel.setTargetEntityName((String)renamedDbEntities.get(rel.getTargetEntityName()));
                }
            }
            for (ObjEntity objEntity : dataMap.getObjEntities()) {
                if (renamedDbEntities.containsKey(objEntity.getDbEntityName())) {
                    objEntity.setDbEntityName((String)renamedDbEntities.get(objEntity.getDbEntityName()));
                }
                if (renamedObjEntities.containsKey(objEntity.getSuperEntityName())) {
                    objEntity.setSuperEntityName((String)renamedDbEntities.get(objEntity.getSuperEntityName()));
                }
                for (DbRelationship rel : objEntity.getRelationships()) {
                    if (!renamedObjEntities.containsKey(rel.getTargetEntityName())) continue;
                    rel.setTargetEntityName((String)renamedObjEntities.get(rel.getTargetEntityName()));
                }
            }
            mediator.addDataMap(this, dataMap);
        } else if (where instanceof DataMap) {
            DataMap dataMap = (DataMap)where;
            if (content instanceof DbEntity) {
                DbEntity dbEntity = (DbEntity)content;
                dbEntity.setName(this.getFreeName(new DbEntityNameChecker(domain), dbEntity.getName()));
                dataMap.addDbEntity(dbEntity);
                CreateDbEntityAction.fireDbEntityEvent(this, mediator, dbEntity);
            } else if (content instanceof ObjEntity) {
                ObjEntity objEntity = (ObjEntity)content;
                objEntity.setName(this.getFreeName(new ObjEntityNameChecker(domain), objEntity.getName()));
                dataMap.addObjEntity(objEntity);
                CreateObjEntityAction.fireObjEntityEvent(this, mediator, dataMap, objEntity);
            } else if (content instanceof Embeddable) {
                Embeddable embeddable = (Embeddable)content;
                embeddable.setClassName(this.getFreeName(new EmbeddableNameChecker(domain), embeddable.getClassName()));
                dataMap.addEmbeddable(embeddable);
                CreateEmbeddableAction.fireEmbeddableEvent(this, mediator, dataMap, embeddable);
            } else if (content instanceof Query) {
                Object root;
                AbstractQuery query = (AbstractQuery)content;
                Object newRoot = root = query.getRoot();
                if (root instanceof ObjEntity) {
                    newRoot = dataMap.getObjEntity(((ObjEntity)root).getName());
                } else if (root instanceof DbEntity) {
                    newRoot = dataMap.getDbEntity(((DbEntity)root).getName());
                } else if (root instanceof Procedure) {
                    newRoot = dataMap.getProcedure(((Procedure)root).getName());
                }
                if (newRoot == null) {
                    JOptionPane.showMessageDialog(Application.getFrame(), "Query root cannot be resolved. Pasting has not been performed.", "Warning", 2);
                    return;
                }
                query.setName(this.getFreeName(new QueryNameChecker(domain), query.getName()));
                dataMap.addQuery((Query)query);
                QueryTypeController.fireQueryEvent(this, mediator, mediator.getCurrentDataDomain(), dataMap, (Query)query);
            } else if (content instanceof Procedure) {
                Procedure procedure = (Procedure)content;
                procedure.setName(this.getFreeName(new ProcedureNameChecker(domain), procedure.getName()));
                dataMap.addProcedure(procedure);
                CreateProcedureAction.fireProcedureEvent(this, mediator, dataMap, procedure);
            }
        } else if (where instanceof DbEntity) {
            final DbEntity dbEntity = (DbEntity)where;
            FreeNameChecker checker = new FreeNameChecker(){

                public boolean isNameFree(String name) {
                    return dbEntity.getAttribute(name) == null && dbEntity.getRelationship(name) == null;
                }
            };
            if (content instanceof DbAttribute) {
                DbAttribute attr = (DbAttribute)content;
                attr.setName(this.getFreeName(checker, attr.getName()));
                dbEntity.addAttribute(attr);
                CreateAttributeAction.fireDbAttributeEvent(this, mediator, domain, mediator.getCurrentDataMap(), dbEntity, attr);
            } else if (content instanceof DbRelationship) {
                DbRelationship rel = (DbRelationship)content;
                rel.setName(this.getFreeName(checker, rel.getName()));
                dbEntity.addRelationship((Relationship)rel);
                CreateRelationshipAction.fireDbRelationshipEvent(this, mediator, dbEntity, rel);
            }
        } else if (where instanceof ObjEntity) {
            final ObjEntity objEntity = (ObjEntity)where;
            FreeNameChecker checker = new FreeNameChecker(){

                public boolean isNameFree(String name) {
                    return objEntity.getAttribute(name) == null && objEntity.getRelationship(name) == null;
                }
            };
            if (content instanceof ObjAttribute) {
                ObjAttribute attr = (ObjAttribute)content;
                attr.setName(this.getFreeName(checker, attr.getName()));
                objEntity.addAttribute((Attribute)attr);
                CreateAttributeAction.fireObjAttributeEvent(this, mediator, domain, mediator.getCurrentDataMap(), objEntity, attr);
            } else if (content instanceof ObjRelationship) {
                ObjRelationship rel = (ObjRelationship)content;
                rel.setName(this.getFreeName(checker, rel.getName()));
                objEntity.addRelationship((Relationship)rel);
                CreateRelationshipAction.fireObjRelationshipEvent(this, mediator, objEntity, rel);
            }
        } else if (where instanceof Embeddable) {
            final Embeddable embeddable = (Embeddable)where;
            FreeNameChecker checker = new FreeNameChecker(){

                public boolean isNameFree(String name) {
                    return embeddable.getAttribute(name) == null;
                }
            };
            if (content instanceof EmbeddableAttribute) {
                EmbeddableAttribute attr = (EmbeddableAttribute)content;
                attr.setName(this.getFreeName(checker, attr.getName()));
                embeddable.addAttribute(attr);
                CreateAttributeAction.fireEmbeddableAttributeEvent(this, mediator, embeddable, attr);
            }
        } else if (where instanceof Procedure) {
            final Procedure procedure = (Procedure)where;
            if (content instanceof ProcedureParameter) {
                ProcedureParameter param = (ProcedureParameter)content;
                param.setName(this.getFreeName(new FreeNameChecker(){

                    public boolean isNameFree(String name) {
                        for (ProcedureParameter existingParam : procedure.getCallParameters()) {
                            if (!name.equals(existingParam.getName())) continue;
                            return false;
                        }
                        return true;
                    }
                }, param.getName()));
                procedure.addCallParameter(param);
                CreateProcedureParameterAction.fireProcedureParameterEvent(this, mediator, procedure, param);
            }
        }
    }

    private String getFreeName(FreeNameChecker checker, String defName) {
        String name = defName;
        int i = 0;
        while (!checker.isNameFree(name)) {
            name = COPY_PREFIX + defName + (i == 0 ? "" : " (" + i + ")");
            ++i;
        }
        return name;
    }

    public boolean enableForPath(ProjectPath path) {
        if (path == null) {
            return false;
        }
        return this.getState();
    }

    public void updateState() {
        this.setEnabled(this.getState());
    }

    private boolean getState() {
        try {
            Object currentObject;
            Object content = Toolkit.getDefaultToolkit().getSystemClipboard().getData(CayenneTransferable.CAYENNE_FLAVOR);
            if (content instanceof List) {
                content = ((List)content).get(0);
            }
            if ((currentObject = this.getProjectController().getCurrentObject()) == null) {
                return false;
            }
            return (currentObject instanceof DataDomain || currentObject instanceof DataNode) && content instanceof DataMap || currentObject instanceof DataMap && this.isTreeLeaf(content) || currentObject instanceof DbEntity && (content instanceof DbAttribute || content instanceof DbRelationship || this.isTreeLeaf(content)) || currentObject instanceof ObjEntity && (content instanceof ObjAttribute || content instanceof ObjRelationship || this.isTreeLeaf(content)) || currentObject instanceof Embeddable && (content instanceof EmbeddableAttribute || this.isTreeLeaf(content)) || currentObject instanceof Procedure && (content instanceof ProcedureParameter || this.isTreeLeaf(content)) || currentObject instanceof Query && this.isTreeLeaf(content);
        }
        catch (Exception ex) {
            return false;
        }
    }

    private boolean isTreeLeaf(Object content) {
        return content instanceof DbEntity || content instanceof ObjEntity || content instanceof Embeddable || content instanceof Procedure || content instanceof Query;
    }

    public void flavorsChanged(FlavorEvent e) {
        this.updateState();
    }

    class QueryNameChecker
    implements FreeNameChecker {
        DataDomain domain;

        public QueryNameChecker(DataDomain domain) {
            this.domain = domain;
        }

        public boolean isNameFree(String name) {
            for (DataMap map : this.domain.getDataMaps()) {
                if (map.getNamespace().getQuery(name) == null) continue;
                return false;
            }
            return true;
        }
    }

    class ProcedureNameChecker
    implements FreeNameChecker {
        DataDomain domain;

        public ProcedureNameChecker(DataDomain domain) {
            this.domain = domain;
        }

        public boolean isNameFree(String name) {
            for (DataMap map : this.domain.getDataMaps()) {
                if (map.getNamespace().getProcedure(name) == null) continue;
                return false;
            }
            return true;
        }
    }

    class EmbeddableNameChecker
    implements FreeNameChecker {
        DataDomain domain;

        public EmbeddableNameChecker(DataDomain domain) {
            this.domain = domain;
        }

        public boolean isNameFree(String name) {
            for (DataMap map : this.domain.getDataMaps()) {
                if (map.getEmbeddable(name) == null) continue;
                return false;
            }
            return true;
        }
    }

    class ObjEntityNameChecker
    implements FreeNameChecker {
        DataDomain domain;

        public ObjEntityNameChecker(DataDomain domain) {
            this.domain = domain;
        }

        public boolean isNameFree(String name) {
            for (DataMap map : this.domain.getDataMaps()) {
                if (map.getObjEntity(name) == null) continue;
                return false;
            }
            return true;
        }
    }

    class DbEntityNameChecker
    implements FreeNameChecker {
        DataDomain domain;

        public DbEntityNameChecker(DataDomain domain) {
            this.domain = domain;
        }

        public boolean isNameFree(String name) {
            for (DataMap map : this.domain.getDataMaps()) {
                if (map.getDbEntity(name) == null) continue;
                return false;
            }
            return true;
        }
    }

    class DataMapNameChecker
    implements FreeNameChecker {
        DataDomain domain;

        public DataMapNameChecker(DataDomain domain) {
            this.domain = domain;
        }

        public boolean isNameFree(String name) {
            return this.domain.getMap(name) == null;
        }
    }

    static interface FreeNameChecker {
        public boolean isNameFree(String var1);
    }
}

