/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.dba.oracle;

import org.apache.cayenne.dba.JdbcActionBuilder;
import org.apache.cayenne.dba.JdbcAdapter;
import org.apache.cayenne.dba.oracle.OracleAdapter;
import org.apache.cayenne.dba.oracle.OracleBatchAction;
import org.apache.cayenne.dba.oracle.OracleLOBBatchAction;
import org.apache.cayenne.dba.oracle.OracleProcedureAction;
import org.apache.cayenne.dba.oracle.OracleSQLTemplateAction;
import org.apache.cayenne.dba.oracle.OracleSelectAction;
import org.apache.cayenne.map.EntityResolver;
import org.apache.cayenne.query.BatchQuery;
import org.apache.cayenne.query.ProcedureQuery;
import org.apache.cayenne.query.SQLAction;
import org.apache.cayenne.query.SQLTemplate;
import org.apache.cayenne.query.SelectQuery;

class OracleActionBuilder
extends JdbcActionBuilder {
    OracleActionBuilder(JdbcAdapter adapter, EntityResolver resolver) {
        super(adapter, resolver);
    }

    public SQLAction sqlAction(SQLTemplate query) {
        return new OracleSQLTemplateAction(query, this.adapter, this.getEntityResolver());
    }

    public SQLAction batchAction(BatchQuery query) {
        if (OracleAdapter.isSupportsOracleLOB() && OracleAdapter.updatesLOBColumns(query)) {
            return new OracleLOBBatchAction(query, this.getAdapter());
        }
        boolean useOptimisticLock = query.isUsingOptimisticLocking();
        boolean runningAsBatch = !useOptimisticLock && this.adapter.supportsBatchUpdates();
        OracleBatchAction action = new OracleBatchAction(query, this.getAdapter(), this.getEntityResolver());
        action.setBatch(runningAsBatch);
        return action;
    }

    public SQLAction procedureAction(ProcedureQuery query) {
        return new OracleProcedureAction(query, this.getAdapter(), this.getEntityResolver());
    }

    public SQLAction objectSelectAction(SelectQuery query) {
        return new OracleSelectAction(query, this.getAdapter(), this.getEntityResolver());
    }
}

