/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.ashwood.dbutil;

import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import org.objectstyle.ashwood.dbutil.ForeignKey;
import org.objectstyle.ashwood.dbutil.Table;
import org.objectstyle.ashwood.graph.Digraph;

public class DbUtils {
    private DbUtils() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void getAllTables(String catalog, String schema, Collection tables, DatabaseMetaData metaData) throws SQLException {
        String[] tableTypes = new String[]{"TABLE"};
        ResultSet rs = null;
        try {
            rs = metaData.getTables(catalog, schema, null, tableTypes);
            while (rs.next()) {
                Table table = new Table(catalog, schema, rs.getString("TABLE_NAME"));
                tables.add(table);
            }
        }
        finally {
            try {
                rs.close();
            }
            catch (Exception e) {}
        }
    }

    public static void refreshTables(Collection tables, DatabaseMetaData metaData) throws SQLException {
        DbUtils.refreshTables(tables, metaData, true, true, true);
    }

    public static void refreshTables(Collection tables, DatabaseMetaData metaData, boolean columns, boolean primaryKeys, boolean foreignKeys) throws SQLException {
        for (Table table : tables) {
            if (columns) {
                table.refreshColumns(metaData);
            }
            if (primaryKeys) {
                table.refreshPrimaryKeys(metaData);
            }
            if (!foreignKeys) continue;
            table.refreshForeignKeys(metaData);
        }
    }

    public static Digraph buildReferentialDigraph(Digraph digraph, Collection tables) {
        HashMap<String, Table> tableMap = new HashMap<String, Table>();
        for (Table table : tables) {
            tableMap.put(table.getFullName(), table);
            digraph.addVertex(table);
        }
        for (Table dst : tables) {
            for (ForeignKey fk : dst.getForeignKeys()) {
                String pkTableFullName = Table.composeFullName(fk.getPkTableCatalog(), fk.getPkTableSchema(), fk.getPkTableName());
                Table origin = (Table)tableMap.get(pkTableFullName);
                if (origin == null) continue;
                ArrayList<ForeignKey> fks = (ArrayList<ForeignKey>)digraph.getArc(origin, dst);
                if (fks == null) {
                    fks = new ArrayList<ForeignKey>();
                    digraph.putArc(origin, dst, fks);
                }
                fks.add(fk);
            }
        }
        return digraph;
    }
}

