/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler;

import java.awt.Component;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetAdapter;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.apache.cayenne.modeler.Application;
import org.apache.cayenne.modeler.CayenneModelerFrame;
import org.apache.cayenne.modeler.ModelerPreferences;
import org.apache.cayenne.modeler.ProjectController;
import org.apache.cayenne.modeler.action.ExitAction;
import org.apache.cayenne.modeler.action.OpenProjectAction;
import org.apache.cayenne.modeler.dialog.validator.ValidatorDialog;
import org.apache.cayenne.modeler.editor.EditorView;
import org.apache.cayenne.modeler.pref.ComponentGeometry;
import org.apache.cayenne.modeler.pref.FSPath;
import org.apache.cayenne.modeler.util.CayenneController;
import org.apache.cayenne.pref.Domain;
import org.apache.cayenne.project.Project;
import org.apache.cayenne.project.validator.Validator;

public class CayenneModelerController
extends CayenneController {
    protected ProjectController projectController;
    protected CayenneModelerFrame frame;
    protected File initialProject;

    public CayenneModelerController(Application application, File initialProject) {
        super(application);
        this.initialProject = initialProject;
        this.frame = new CayenneModelerFrame(application.getActionManager());
        this.projectController = new ProjectController(this);
    }

    public Component getView() {
        return this.frame;
    }

    public ProjectController getProjectController() {
        return this.projectController;
    }

    public FSPath getLastEOModelDirectory() {
        FSPath path = (FSPath)this.getViewDomain().getDetail("lastEOMDir", FSPath.class, true);
        if (path.getPath() == null) {
            path.setPath(this.getLastDirectory().getPath());
        }
        return path;
    }

    protected void initBindings() {
        this.frame.setDefaultCloseOperation(0);
        this.frame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                ((ExitAction)CayenneModelerController.this.getApplication().getAction(ExitAction.getActionName())).exit();
            }
        });
        new DropTarget(this.frame, new DropTargetAdapter(){

            public void drop(DropTargetDropEvent dtde) {
                dtde.acceptDrop(dtde.getDropAction());
                Transferable transferable = dtde.getTransferable();
                dtde.dropComplete(CayenneModelerController.this.processDropAction(transferable));
            }
        });
        Domain prefDomain = this.application.getPreferenceDomain().getSubdomain(this.frame.getClass());
        ComponentGeometry geometry = ComponentGeometry.getPreference(prefDomain);
        geometry.bind(this.frame, 650, 550, 30);
    }

    private boolean processDropAction(Transferable transferable) {
        List fileList;
        try {
            fileList = (List)transferable.getTransferData(DataFlavor.javaFileListFlavor);
        }
        catch (Exception e) {
            return false;
        }
        File transferFile = (File)fileList.get(0);
        if (transferFile.isFile() && "cayenne.xml".equals(transferFile.getName())) {
            ActionEvent e = new ActionEvent(transferFile, 1001, "OpenProject");
            Application.getInstance().getAction(OpenProjectAction.getActionName()).actionPerformed(e);
            return true;
        }
        return false;
    }

    public void startupAction() {
        this.initBindings();
        this.frame.setVisible(true);
        if (this.initialProject != null) {
            OpenProjectAction openAction = (OpenProjectAction)this.getApplication().getAction(OpenProjectAction.getActionName());
            openAction.openProject(this.initialProject);
        }
    }

    public void projectModifiedAction() {
        String title = this.projectController.getProject().isLocationUndefined() ? "[New]" : this.projectController.getProject().getMainFile().getAbsolutePath();
        this.frame.setTitle("* - CayenneModeler - " + title);
    }

    public void projectSavedAction() {
        this.projectController.setDirty(false);
        this.updateStatus("Project saved...");
        this.frame.setTitle("CayenneModeler - " + this.projectController.getProject().getMainFile().getAbsolutePath());
    }

    public void projectClosedAction() {
        this.frame.setView(null);
        this.frame.repaint();
        this.frame.setTitle("CayenneModeler");
        this.projectController.setProject(null);
        this.projectController.reset();
        this.application.getActionManager().projectClosed();
        this.updateStatus("Project Closed...");
    }

    public void projectOpenedAction(Project project) {
        this.projectController.setProject(project);
        this.frame.setView(new EditorView(this.projectController));
        this.projectController.projectOpened();
        this.application.getActionManager().projectOpened();
        if (project.isLocationUndefined()) {
            this.updateStatus("New project created...");
            this.frame.setTitle("CayenneModeler- [New]");
        } else {
            this.updateStatus("Project opened...");
            this.frame.setTitle("CayenneModeler - " + project.getMainFile().getAbsolutePath());
        }
        if (!project.isLocationUndefined()) {
            this.getLastDirectory().setDirectory(project.getProjectDirectory());
            this.frame.fireRecentFileListChanged();
        }
        if (project.getLoadStatus().hasFailures()) {
            project.setModified(true);
            this.projectController.setDirty(true);
            ValidatorDialog.showDialog(this.frame, new Validator(project, project.getLoadStatus()));
        }
    }

    public void addToLastProjListAction(String path) {
        ModelerPreferences pref = ModelerPreferences.getPreferences();
        Vector arr = pref.getVector("Editor.lastSeveralProjectFiles");
        if (arr.contains(path)) {
            arr.remove(path);
        }
        arr.insertElementAt(path, 0);
        while (arr.size() > 12) {
            arr.remove(arr.size() - 1);
        }
        pref.remove("Editor.lastSeveralProjectFiles");
        Iterator iter = arr.iterator();
        while (iter.hasNext()) {
            pref.addProperty("Editor.lastSeveralProjectFiles", iter.next());
        }
    }

    public void updateStatus(String message) {
        this.frame.getStatus().setText(message);
        if (message != null && message.trim().length() > 0) {
            ExpireThread cleanup = new ExpireThread(message, 6);
            cleanup.start();
        }
    }

    class ExpireThread
    extends Thread {
        protected int seconds;
        protected String message;

        public ExpireThread(String message, int seconds) {
            this.seconds = seconds;
            this.message = message;
        }

        public void run() {
            try {
                ExpireThread.sleep(this.seconds * 1000);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (this.message.equals(CayenneModelerController.this.frame.getStatus().getText())) {
                CayenneModelerController.this.updateStatus(null);
            }
        }
    }
}

