/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.editor;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.JPanel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.apache.cayenne.map.event.QueryEvent;
import org.apache.cayenne.modeler.ProjectController;
import org.apache.cayenne.modeler.util.CayenneWidgetFactory;
import org.apache.cayenne.project.validator.EJBQLQueryValidator;
import org.apache.cayenne.query.EJBQLQuery;
import org.apache.cayenne.query.Query;
import org.apache.cayenne.swing.components.textpane.JCayenneTextPane;
import org.apache.cayenne.util.Util;

public class EjbqlQueryScriptsTab
extends JPanel
implements DocumentListener {
    protected ProjectController mediator;
    protected JCayenneTextPane scriptArea;
    private boolean updateDisabled;
    protected EJBQLQueryValidator ejbqlQueryValidator = new EJBQLQueryValidator();

    public EjbqlQueryScriptsTab(ProjectController mediator) {
        this.mediator = mediator;
        this.initView();
    }

    void displayScript() {
        EJBQLQuery query = this.getQuery();
        this.scriptArea.setText(query.getEjbqlStatement());
        this.updateDisabled = false;
    }

    private void initView() {
        this.scriptArea = CayenneWidgetFactory.createJEJBQLTextPane();
        this.scriptArea.getDocument().addDocumentListener(this);
        this.scriptArea.getDocument().addDocumentListener(new DocumentListener(){

            public void changedUpdate(DocumentEvent e) {
            }

            public void insertUpdate(DocumentEvent e) {
                try {
                    String text = EjbqlQueryScriptsTab.this.scriptArea.getDocument().getText(e.getOffset(), 1).toString();
                    if (text.equals(" ") || text.equals("\n") || text.equals("\t")) {
                        EjbqlQueryScriptsTab.this.getQuery().setEjbqlStatement(EjbqlQueryScriptsTab.this.scriptArea.getText());
                        EjbqlQueryScriptsTab.this.validateEJBQL();
                    }
                }
                catch (BadLocationException e1) {
                    e1.printStackTrace();
                }
            }

            public void removeUpdate(DocumentEvent e) {
                EjbqlQueryScriptsTab.this.getQuery().setEjbqlStatement(EjbqlQueryScriptsTab.this.scriptArea.getText());
                EjbqlQueryScriptsTab.this.validateEJBQL();
            }
        });
        this.scriptArea.getPane().addFocusListener(new FocusListener(){
            EJBQLValidationThread thread;

            public void focusGained(FocusEvent e) {
                this.thread = new EJBQLValidationThread();
                this.thread.start();
            }

            public void focusLost(FocusEvent e) {
                this.thread.terminate();
            }
        });
        this.scriptArea.getPane().addKeyListener(new KeyListener(){
            boolean pasteOrCut;

            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 35 || e.getKeyCode() == 36 || e.getKeyCode() == 37 || e.getKeyCode() == 39 || e.getKeyCode() == 38 || e.getKeyCode() == 65483) {
                    EjbqlQueryScriptsTab.this.getQuery().setEjbqlStatement(EjbqlQueryScriptsTab.this.scriptArea.getText());
                    EjbqlQueryScriptsTab.this.validateEJBQL();
                }
                if ((e.getKeyCode() == 86 || e.getKeyCode() == 88) && e.isControlDown()) {
                    this.pasteOrCut = true;
                }
            }

            public void keyReleased(KeyEvent e) {
                if (this.pasteOrCut && e.getKeyCode() == 17 || e.getKeyCode() == 127) {
                    EjbqlQueryScriptsTab.this.scriptArea.removeHighlightText();
                    EjbqlQueryScriptsTab.this.getQuery().setEjbqlStatement(EjbqlQueryScriptsTab.this.scriptArea.getText());
                    EjbqlQueryScriptsTab.this.validateEJBQL();
                    this.pasteOrCut = false;
                }
            }

            public void keyTyped(KeyEvent e) {
            }
        });
        this.setLayout(new BorderLayout());
        this.add((Component)this.scriptArea, "West");
        this.add((Component)this.scriptArea.getScrollPane(), "Center");
        this.setVisible(true);
    }

    public void initFromModel() {
        Query query = this.mediator.getCurrentQuery();
        if (!(query instanceof EJBQLQuery)) {
            this.setVisible(false);
            return;
        }
        this.scriptArea.setEnabled(true);
        this.displayScript();
        this.validateEJBQL();
        this.setVisible(true);
    }

    EJBQLQuery getQuery() {
        Query query = this.mediator.getCurrentQuery();
        return query instanceof EJBQLQuery ? (EJBQLQuery)query : null;
    }

    void setEJBQL(DocumentEvent e) {
        Document doc = e.getDocument();
        try {
            this.setEJBQL(doc.getText(0, doc.getLength()));
        }
        catch (BadLocationException e1) {
            e1.printStackTrace();
        }
    }

    void setEJBQL(String text) {
        EJBQLQuery query = this.getQuery();
        if (query == null) {
            return;
        }
        String testTemp = null;
        if (text != null && (testTemp = text.trim()).length() == 0) {
            text = null;
        }
        if (!Util.nullSafeEquals(text, query.getEjbqlStatement())) {
            query.setEjbqlStatement(text);
            this.mediator.fireQueryEvent(new QueryEvent((Object)this, query));
        }
    }

    public void insertUpdate(DocumentEvent e) {
        this.changedUpdate(e);
    }

    public void removeUpdate(DocumentEvent e) {
        this.changedUpdate(e);
    }

    public void changedUpdate(DocumentEvent e) {
        if (!this.updateDisabled) {
            this.setEJBQL(e);
        }
    }

    void validateEJBQL() {
        EJBQLQueryValidator.PositionException positionException = this.ejbqlQueryValidator.validateEJBQL(this.getQuery(), this.mediator.getCurrentDataDomain());
        if (positionException != null) {
            if (positionException.getBeginLine() != null || positionException.getBeginColumn() != null || positionException.getLength() != null) {
                this.scriptArea.setHighlightText(positionException.getBeginLine(), positionException.getBeginColumn(), positionException.getLength(), positionException.getMessage());
            } else {
                this.scriptArea.removeHighlightText();
            }
        }
    }

    class EJBQLValidationThread
    extends Thread {
        boolean running;
        Object timer;
        int previousCaretPosition;
        int validateCaretPosition;
        static final int DELAY = 500;

        EJBQLValidationThread() {
            super("ejbql-validation-thread");
            this.timer = new Object();
            this.setDaemon(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            this.running = true;
            while (this.running) {
                int caretPosition = EjbqlQueryScriptsTab.this.scriptArea.getCaretPosition();
                if (this.previousCaretPosition != 0 && this.previousCaretPosition == caretPosition && this.validateCaretPosition != this.previousCaretPosition) {
                    EjbqlQueryScriptsTab.this.validateEJBQL();
                    this.validateCaretPosition = caretPosition;
                }
                this.previousCaretPosition = caretPosition;
                Object object = this.timer;
                synchronized (object) {
                    try {
                        this.timer.wait(500L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void terminate() {
            Object object = this.timer;
            synchronized (object) {
                this.running = false;
                this.timer.notify();
            }
        }
    }
}

