/*
 * Decompiled with CFR 0.152.
 */
package org.scopemvc.model.collection;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.scopemvc.core.ModelChangeEventSource;
import org.scopemvc.core.Selector;
import org.scopemvc.model.basic.BasicModel;

public class ListModel
extends BasicModel
implements List {
    public static final Selector LIST = Selector.fromString("list");
    private static final String TO_STRING_SEPARATOR = ", ";
    private static final Log LOG = LogFactory.getLog(class$org$scopemvc$model$collection$ListModel == null ? (class$org$scopemvc$model$collection$ListModel = ListModel.class$("org.scopemvc.model.collection.ListModel")) : class$org$scopemvc$model$collection$ListModel);
    private List contents;
    private boolean propagateModelChanges;
    static /* synthetic */ Class class$org$scopemvc$model$collection$ListModel;

    public ListModel() {
        this(true, new ArrayList(10));
    }

    public ListModel(List list) {
        this(true, list);
    }

    public ListModel(boolean bl) {
        this.propagateModelChanges = bl;
    }

    public ListModel(boolean bl, List list) {
        this(bl);
        this.setList(list);
    }

    public List getList() {
        if (this.contents == null) {
            return null;
        }
        return Collections.unmodifiableList(this.contents);
    }

    public int getSize() {
        if (this.contents == null) {
            return 0;
        }
        return this.contents.size();
    }

    public int getIndexOf(Object object) {
        if (object == null || this.contents == null) {
            return -1;
        }
        return this.contents.indexOf(object);
    }

    public boolean isEmpty() {
        if (this.contents == null) {
            return true;
        }
        return this.contents.isEmpty();
    }

    public Object get(int n) {
        if (this.contents == null) {
            return null;
        }
        return this.contents.get(n);
    }

    public void setList(List list) {
        Object e;
        Iterator iterator;
        if (this.propagateModelChanges && this.contents != null) {
            iterator = this.contents.iterator();
            while (iterator.hasNext()) {
                e = iterator.next();
                if (!(e instanceof ModelChangeEventSource)) continue;
                ((ModelChangeEventSource)e).removeModelChangeListener(this);
            }
        }
        this.contents = list;
        if (this.propagateModelChanges && this.contents != null) {
            iterator = this.contents.iterator();
            while (iterator.hasNext()) {
                e = iterator.next();
                if (!(e instanceof ModelChangeEventSource)) continue;
                ((ModelChangeEventSource)e).addModelChangeListener(this);
            }
        }
        this.fireModelChange(0, LIST);
    }

    public Object set(int n, Object object) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("set: " + n + TO_STRING_SEPARATOR + object);
        }
        if (this.contents == null) {
            throw new IllegalStateException("Cannot set an item to the list model when the wrapped list is null");
        }
        Object object2 = this.contents.set(n, object);
        this.fireModelChange(0, Selector.fromInt(n));
        if (this.propagateModelChanges) {
            if (object2 instanceof ModelChangeEventSource) {
                ((ModelChangeEventSource)object2).removeModelChangeListener(this);
            }
            if (object instanceof ModelChangeEventSource) {
                ((ModelChangeEventSource)object).addModelChangeListener(this);
            }
        }
        return object2;
    }

    public Iterator iterator() {
        if (this.contents == null) {
            return new ArrayList().iterator();
        }
        return this.contents.iterator();
    }

    public int size() {
        return this.getSize();
    }

    public boolean contains(Object object) {
        if (this.contents == null) {
            return false;
        }
        return this.contents.contains(object);
    }

    public boolean remove(Object object) {
        int n = this.indexOf(object);
        if (n < 0) {
            return false;
        }
        this.remove(n);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addAll(Collection collection) {
        boolean bl = false;
        this.makeActive(false);
        try {
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                bl |= this.add(iterator.next());
            }
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.makeActive(true);
            throw throwable;
        }
        this.makeActive(true);
        if (bl) {
            this.fireModelChange(0, null);
        }
        return bl;
    }

    public boolean add(Object object) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("add: " + object);
        }
        if (this.contents == null) {
            throw new IllegalStateException("Cannot add an item to the list model when the wrapped list is null");
        }
        if (!this.contents.add(object)) {
            return false;
        }
        if (this.propagateModelChanges && object instanceof ModelChangeEventSource) {
            ((ModelChangeEventSource)object).addModelChangeListener(this);
        }
        this.fireModelChange(1, Selector.fromInt(this.contents.size() - 1));
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeAll(Collection collection) {
        boolean bl = false;
        this.makeActive(false);
        try {
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                bl |= this.remove(iterator.next());
            }
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.makeActive(true);
            throw throwable;
        }
        this.makeActive(true);
        this.fireModelChange(0, null);
        return bl;
    }

    public boolean containsAll(Collection collection) {
        if (this.contents == null) {
            return false;
        }
        return this.getList().containsAll(collection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        if (this.contents == null || this.contents.size() == 0) {
            return;
        }
        this.makeActive(false);
        try {
            if (this.propagateModelChanges) {
                Iterator iterator = this.contents.iterator();
                while (iterator.hasNext()) {
                    Object e = iterator.next();
                    if (!(e instanceof ModelChangeEventSource)) continue;
                    ((ModelChangeEventSource)e).removeModelChangeListener(this);
                }
            }
            this.contents.clear();
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.makeActive(true);
            throw throwable;
        }
        this.makeActive(true);
        this.fireModelChange(0, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addAll(int n, Collection collection) {
        boolean bl = false;
        this.makeActive(false);
        try {
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                bl |= this.add(iterator.next());
            }
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            this.makeActive(true);
            throw throwable;
        }
        this.makeActive(true);
        if (bl) {
            this.fireModelChange(0, null);
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean retainAll(Collection collection) {
        boolean bl = false;
        this.makeActive(false);
        try {
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                Object e = iterator.next();
                if (collection.contains(e)) continue;
                iterator.remove();
                bl = true;
            }
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            this.makeActive(true);
            throw throwable;
        }
        this.makeActive(true);
        if (bl) {
            this.fireModelChange(0, null);
        }
        return bl;
    }

    public Object remove(int n) {
        if (this.contents == null) {
            return null;
        }
        Object e = this.contents.remove(n);
        if (this.propagateModelChanges && e instanceof ModelChangeEventSource) {
            ((ModelChangeEventSource)e).removeModelChangeListener(this);
        }
        if (e != null) {
            this.fireModelChange(2, Selector.fromInt(n));
        }
        return e;
    }

    public int lastIndexOf(Object object) {
        if (this.contents == null) {
            return -1;
        }
        return this.contents.lastIndexOf(object);
    }

    public void add(int n, Object object) {
        if (this.contents == null) {
            throw new IllegalStateException("Cannot add an item to the list model when the wrapped list is null");
        }
        this.contents.add(n, object);
        if (this.propagateModelChanges && object instanceof ModelChangeEventSource) {
            ((ModelChangeEventSource)object).addModelChangeListener(this);
        }
        this.fireModelChange(1, Selector.fromInt(n));
    }

    public ListIterator listIterator(int n) {
        if (this.contents == null) {
            return new ArrayList().listIterator();
        }
        return this.contents.listIterator(n);
    }

    public int indexOf(Object object) {
        return this.getIndexOf(object);
    }

    public ListIterator listIterator() {
        if (this.contents == null) {
            return new ArrayList().listIterator();
        }
        return this.contents.listIterator();
    }

    public List subList(int n, int n2) {
        if (this.contents == null) {
            return null;
        }
        return this.contents.subList(n, n2);
    }

    public int hashCode() {
        if (this.contents == null) {
            return 0;
        }
        return this.contents.hashCode();
    }

    public boolean equals(Object object) {
        if (this.contents == null) {
            return object == null;
        }
        return this.contents.equals(object);
    }

    public Object[] toArray(Object[] objectArray) {
        if (this.contents == null) {
            return null;
        }
        return this.contents.toArray(objectArray);
    }

    public Object[] toArray() {
        if (this.contents == null) {
            return null;
        }
        return this.getList().toArray();
    }

    public String toString() {
        if (this.contents == null) {
            return "ListModel: <null>";
        }
        StringBuffer stringBuffer = new StringBuffer("ListModel (");
        Iterator iterator = this.contents.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            stringBuffer.append(e == null ? "<null>" : e.toString());
            if (!iterator.hasNext()) continue;
            stringBuffer.append(TO_STRING_SEPARATOR);
        }
        stringBuffer.append(')');
        return stringBuffer.toString();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

