/*
 * Decompiled with CFR 0.152.
 */
package org.scopemvc.util.convertor;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.scopemvc.util.ScopeConfig;
import org.scopemvc.util.convertor.NullStringConvertor;

public class DateStringConvertor
extends NullStringConvertor {
    private static final Log LOG = LogFactory.getLog(class$org$scopemvc$util$convertor$DateStringConvertor == null ? (class$org$scopemvc$util$convertor$DateStringConvertor = DateStringConvertor.class$("org.scopemvc.util.convertor.DateStringConvertor")) : class$org$scopemvc$util$convertor$DateStringConvertor);
    private static final DateFormat[] DEFAULT_PARSERS = new DateFormat[4];
    private DateFormat formatter;
    private DateFormat[] parsers;
    static /* synthetic */ Class class$org$scopemvc$util$convertor$DateStringConvertor;

    public DateStringConvertor() {
        this.initDefaults();
    }

    public DateStringConvertor(DateFormat dateFormat, DateFormat[] dateFormatArray) {
        this.setFormatter(dateFormat);
        this.setParsers(dateFormatArray);
    }

    public final void setFormatter(Object object) throws IllegalArgumentException {
        if (object instanceof DateFormat) {
            this.formatter = (DateFormat)object;
        } else if (object instanceof String) {
            this.formatter = new SimpleDateFormat((String)object);
        } else {
            throw new IllegalArgumentException("Can't set formatter to: " + object);
        }
    }

    public final void setParsers(Object[] objectArray) throws IllegalArgumentException {
        if (objectArray == null) {
            throw new IllegalArgumentException("Passed array of formats cannot be null");
        }
        this.parsers = new DateFormat[objectArray.length];
        int n = 0;
        while (n < objectArray.length) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("setParsers: " + objectArray[n]);
            }
            if (objectArray[n] instanceof String) {
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat((String)objectArray[n]);
                this.parsers[n] = simpleDateFormat;
            } else if (objectArray[n] instanceof DateFormat) {
                this.parsers[n] = (DateFormat)objectArray[n];
            } else {
                throw new IllegalArgumentException("Cannot set a parser to be: " + objectArray[n]);
            }
            this.parsers[n].setLenient(false);
            ++n;
        }
    }

    public Object stringAsValue(String string) throws IllegalArgumentException {
        if (this.isNull(string)) {
            return null;
        }
        int n = this.parsers.length - 1;
        while (n >= 0) {
            block6: {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Parser: " + string + ", " + this.parsers[n].format(new Date(0L)));
                }
                try {
                    Date date = this.parsers[n].parse(string);
                    if (date != null) {
                        return date;
                    }
                }
                catch (ParseException parseException) {
                    if (!LOG.isDebugEnabled()) break block6;
                    LOG.debug("stringAsValue", parseException);
                }
            }
            --n;
        }
        throw new IllegalArgumentException("Cannot convert to Date/Time: " + string);
    }

    public String valueAsString(Object object) throws IllegalArgumentException {
        if (object == null) {
            return this.getNullAsString();
        }
        if (!(object instanceof Date)) {
            throw new IllegalArgumentException("Passed object is not subclass of java.util.Date. Its class is " + object.getClass());
        }
        return this.formatter.format(object);
    }

    protected DateFormat[] getDefaultParsers() {
        return DEFAULT_PARSERS;
    }

    protected void initDefaults() {
        Object object = ScopeConfig.getObject(this.getClass().getName() + ".formatter");
        this.setFormatter(object);
        ArrayList<Object> arrayList = new ArrayList<Object>();
        Iterator iterator = ScopeConfig.getKeysMatching(this.getClass().getName() + ".parser");
        while (iterator.hasNext()) {
            arrayList.add(ScopeConfig.getObject((String)iterator.next()));
        }
        if (arrayList.size() < 1) {
            this.setParsers(this.getDefaultParsers());
        } else {
            this.setParsers(arrayList.toArray());
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        DateStringConvertor.DEFAULT_PARSERS[3] = DateFormat.getDateInstance(3);
        DateStringConvertor.DEFAULT_PARSERS[2] = DateFormat.getDateInstance(2);
        DateStringConvertor.DEFAULT_PARSERS[1] = DateFormat.getDateInstance(1);
        DateStringConvertor.DEFAULT_PARSERS[0] = DateFormat.getDateInstance(0);
    }
}

