/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.dba;

import org.apache.cayenne.access.jdbc.BatchAction;
import org.apache.cayenne.access.jdbc.EJBQLAction;
import org.apache.cayenne.access.jdbc.ProcedureAction;
import org.apache.cayenne.access.jdbc.SQLTemplateAction;
import org.apache.cayenne.access.jdbc.SelectAction;
import org.apache.cayenne.access.jdbc.UpdateAction;
import org.apache.cayenne.dba.DbAdapter;
import org.apache.cayenne.dba.JdbcAdapter;
import org.apache.cayenne.map.EntityResolver;
import org.apache.cayenne.query.BatchQuery;
import org.apache.cayenne.query.EJBQLQuery;
import org.apache.cayenne.query.ProcedureQuery;
import org.apache.cayenne.query.Query;
import org.apache.cayenne.query.SQLAction;
import org.apache.cayenne.query.SQLActionVisitor;
import org.apache.cayenne.query.SQLTemplate;
import org.apache.cayenne.query.SelectQuery;

public class JdbcActionBuilder
implements SQLActionVisitor {
    protected JdbcAdapter adapter;
    protected EntityResolver entityResolver;

    public JdbcActionBuilder(DbAdapter adapter, EntityResolver resolver) {
        if (!(adapter instanceof JdbcAdapter)) {
            throw new IllegalArgumentException("Expected a non-null JdbcAdapter, got: " + adapter);
        }
        this.adapter = (JdbcAdapter)adapter;
        this.entityResolver = resolver;
    }

    public JdbcActionBuilder(JdbcAdapter adapter, EntityResolver resolver) {
        this.adapter = adapter;
        this.entityResolver = resolver;
    }

    public SQLAction batchAction(BatchQuery query) {
        boolean useOptimisticLock = query.isUsingOptimisticLocking();
        boolean runningAsBatch = !useOptimisticLock && this.adapter.supportsBatchUpdates();
        BatchAction action = new BatchAction(query, this.adapter, this.entityResolver);
        action.setBatch(runningAsBatch);
        return action;
    }

    public SQLAction procedureAction(ProcedureQuery query) {
        return new ProcedureAction(query, this.adapter, this.entityResolver);
    }

    public SQLAction objectSelectAction(SelectQuery query) {
        return new SelectAction(query, this.adapter, this.entityResolver);
    }

    public SQLAction sqlAction(SQLTemplate query) {
        return new SQLTemplateAction(query, this.adapter, this.entityResolver);
    }

    public SQLAction updateAction(Query query) {
        if (query instanceof SQLTemplate) {
            return new SQLTemplateAction((SQLTemplate)query, this.adapter, this.entityResolver);
        }
        return new UpdateAction(query, this.adapter, this.entityResolver);
    }

    public SQLAction ejbqlAction(EJBQLQuery query) {
        return new EJBQLAction(query, this, this.adapter, this.entityResolver);
    }

    public DbAdapter getAdapter() {
        return this.adapter;
    }

    public EntityResolver getEntityResolver() {
        return this.entityResolver;
    }
}

