/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler;

import java.io.File;
import java.util.List;
import javax.swing.JOptionPane;
import org.apache.cayenne.modeler.Application;
import org.apache.cayenne.modeler.CayenneModelerController;
import org.apache.cayenne.modeler.ProjectController;
import org.apache.cayenne.modeler.action.OpenProjectAction;
import org.apache.cayenne.modeler.action.SaveAction;
import org.apache.cayenne.modeler.dialog.FileDeletedDialog;
import org.apache.cayenne.modeler.util.FileWatchdog;
import org.apache.cayenne.project.Project;
import org.apache.cayenne.project.ProjectFile;

public class ProjectWatchdog
extends FileWatchdog {
    protected ProjectController mediator;

    public ProjectWatchdog(ProjectController mediator) {
        this.setName("cayenne-project-watchdog");
        this.mediator = mediator;
        this.setSingleNotification(true);
    }

    public void reconfigure() {
        this.pauseWatching();
        this.removeAllFiles();
        Project project = this.mediator.getProject();
        if (project != null && project.getProjectDirectory() != null) {
            String projectPath = project.getProjectDirectory().getPath() + File.separator;
            List<ProjectFile> files = project.buildFileList();
            for (ProjectFile pr : files) {
                this.addFile(projectPath + pr.getLocation());
            }
        }
        this.resumeWatching();
    }

    protected void doOnChange(FileWatchdog.FileInfo fileInfo) {
        if (this.showConfirmation("One or more project files were changed by external program. Do you want to load the changes?")) {
            if (this.mediator.getProject() != null) {
                ((OpenProjectAction)Application.getInstance().getAction(OpenProjectAction.getActionName())).openProject(this.mediator.getProject().getMainFile());
            }
        } else {
            this.mediator.setDirty(true);
        }
    }

    protected void doOnRemove(FileWatchdog.FileInfo fileInfo) {
        if (this.mediator.getProject() != null) {
            FileDeletedDialog dialog = new FileDeletedDialog(Application.getFrame());
            dialog.show();
            if (dialog.shouldSave()) {
                Application.getInstance().getAction(SaveAction.getActionName()).performAction(null);
            } else if (dialog.shouldClose()) {
                CayenneModelerController controller = Application.getInstance().getFrameController();
                controller.projectClosedAction();
            } else {
                this.mediator.setDirty(true);
            }
        }
    }

    private boolean showConfirmation(String message) {
        return 0 == JOptionPane.showConfirmDialog(Application.getFrame(), message, "File changed", 0, 3);
    }
}

