/*
 * Decompiled with CFR 0.152.
 */
package org.scopemvc.view.servlet.xml;

import java.util.Iterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.scopemvc.core.IntIndexSelector;
import org.scopemvc.core.PropertyManager;
import org.scopemvc.core.Selector;
import org.scopemvc.model.collection.ArrayModel;
import org.scopemvc.model.collection.ListModel;
import org.scopemvc.util.convertor.StringConvertor;
import org.scopemvc.util.convertor.StringConvertors;
import org.scopemvc.view.servlet.xml.IdRefMap;
import org.scopemvc.view.servlet.xml.PropertyIDGenerator;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.helpers.AttributesImpl;

public class ModelToXML {
    protected static final String ID_ATTRIBUTE = "id";
    protected static final String IDREF_ATTRIBUTE = "idref";
    protected static final String CDATA_TYPE = "CDATA";
    protected static final String PATH_ATTRIBUTE = "id";
    protected static final Attributes EMPTY_ATTRIBUTES = new AttributesImpl();
    protected static String COLLECTION_ELEMENT = "element";
    protected static String COLLECTION_INDEX_ATTRIBUTE = "index";
    protected static String MODEL_ELEMENT = "data";
    private static final Log LOG = LogFactory.getLog(class$org$scopemvc$view$servlet$xml$ModelToXML == null ? (class$org$scopemvc$view$servlet$xml$ModelToXML = ModelToXML.class$("org.scopemvc.view.servlet.xml.ModelToXML")) : class$org$scopemvc$view$servlet$xml$ModelToXML);
    protected AttributesImpl idAttributes;
    protected AttributesImpl idrefAttributes;
    protected AttributesImpl pathIndexAttributes;
    protected AttributesImpl indexAttributes;
    protected AttributesImpl pathAttributes;
    static /* synthetic */ Class class$org$scopemvc$view$servlet$xml$ModelToXML;

    public ModelToXML() {
        this.init();
    }

    public void modelToXML(Object object, ContentHandler contentHandler, PropertyIDGenerator propertyIDGenerator) throws Exception {
        contentHandler.startDocument();
        IdRefMap idRefMap = new IdRefMap();
        String string = idRefMap.getNextId();
        this.idAttributes.setValue(0, string);
        idRefMap.storeModel(string, object);
        contentHandler.startElement("", MODEL_ELEMENT, MODEL_ELEMENT, this.idAttributes);
        this.propertiesToXML(object, contentHandler, propertyIDGenerator, idRefMap);
        contentHandler.endElement("", MODEL_ELEMENT, MODEL_ELEMENT);
        contentHandler.endDocument();
    }

    protected void init() {
        this.idAttributes = new AttributesImpl();
        this.idAttributes.addAttribute("", "id", "id", CDATA_TYPE, "");
        this.idrefAttributes = new AttributesImpl();
        this.idrefAttributes.addAttribute("", IDREF_ATTRIBUTE, IDREF_ATTRIBUTE, CDATA_TYPE, "");
        this.pathIndexAttributes = new AttributesImpl();
        this.pathIndexAttributes.addAttribute("", "id", "id", CDATA_TYPE, "");
        this.pathIndexAttributes.addAttribute("", COLLECTION_INDEX_ATTRIBUTE, COLLECTION_INDEX_ATTRIBUTE, CDATA_TYPE, "");
        this.indexAttributes = new AttributesImpl();
        this.indexAttributes.addAttribute("", COLLECTION_INDEX_ATTRIBUTE, COLLECTION_INDEX_ATTRIBUTE, CDATA_TYPE, "");
        this.pathAttributes = new AttributesImpl();
        this.pathAttributes.addAttribute("", "id", "id", CDATA_TYPE, "");
    }

    protected void propertiesToXML(Object object, ContentHandler contentHandler, PropertyIDGenerator propertyIDGenerator, IdRefMap idRefMap) throws Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug("propertiesToXML: idGenerator=" + propertyIDGenerator);
        }
        if (object == null) {
            return;
        }
        PropertyManager propertyManager = PropertyManager.getInstance(object);
        Iterator iterator = propertyManager.getSelectorIterator(object);
        while (iterator.hasNext()) {
            try {
                Object object2;
                String string;
                Object e = iterator.next();
                Selector selector = (Selector)e;
                Object object3 = propertyManager.get(object, selector);
                if (object3 == null || object instanceof ArrayModel && ArrayModel.ARRAY.equals(selector) || object instanceof ListModel && ListModel.LIST.equals(selector)) continue;
                StringConvertor stringConvertor = StringConvertors.forClass(object3.getClass());
                propertyIDGenerator.startProperty(selector);
                String string2 = propertyIDGenerator.getPropertyID();
                if (selector instanceof IntIndexSelector) {
                    if (string2 != null) {
                        this.pathIndexAttributes.setValue(0, string2);
                        this.pathIndexAttributes.setValue(1, selector.getName());
                        contentHandler.startElement("", COLLECTION_ELEMENT, COLLECTION_ELEMENT, this.pathIndexAttributes);
                    } else {
                        this.indexAttributes.setValue(0, selector.getName());
                        contentHandler.startElement("", COLLECTION_ELEMENT, COLLECTION_ELEMENT, this.indexAttributes);
                    }
                } else if (string2 != null) {
                    this.pathAttributes.setValue(0, string2);
                    contentHandler.startElement("", selector.getName(), selector.getName(), this.pathAttributes);
                } else {
                    contentHandler.startElement("", selector.getName(), selector.getName(), EMPTY_ATTRIBUTES);
                }
                if (stringConvertor != null) {
                    string = stringConvertor.valueAsString(object3);
                    object2 = string.toCharArray();
                    contentHandler.characters((char[])object2, 0, ((char[])object2).length);
                } else {
                    string = idRefMap.findIdFor(object3);
                    if (string != null) {
                        this.idrefAttributes.setValue(0, string);
                        contentHandler.startElement("", MODEL_ELEMENT, MODEL_ELEMENT, this.idrefAttributes);
                    } else {
                        object2 = idRefMap.getNextId();
                        this.idAttributes.setValue(0, (String)object2);
                        contentHandler.startElement("", MODEL_ELEMENT, MODEL_ELEMENT, this.idAttributes);
                        idRefMap.storeModel((String)object2, object3);
                        this.propertiesToXML(object3, contentHandler, propertyIDGenerator, idRefMap);
                    }
                    contentHandler.endElement("", MODEL_ELEMENT, MODEL_ELEMENT);
                }
                if (selector instanceof IntIndexSelector) {
                    contentHandler.endElement("", COLLECTION_ELEMENT, COLLECTION_ELEMENT);
                } else {
                    contentHandler.endElement("", selector.getName(), selector.getName());
                }
                propertyIDGenerator.endProperty();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

