/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.beanutils;

import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.util.HashMap;
import junit.framework.TestCase;
import org.apache.commons.beanutils.BeanIntrospectionData;
import org.apache.commons.beanutils.BeanIntrospector;
import org.apache.commons.beanutils.FluentIntrospectionTestBean;
import org.apache.commons.beanutils.FluentPropertyBeanIntrospector;
import org.apache.commons.beanutils.PropertyUtilsBean;
import org.apache.commons.beanutils.SuppressPropertiesBeanIntrospector;

public class BeanIntrospectionDataTestCase
extends TestCase {
    private static final Class<?> BEAN_CLASS = FluentIntrospectionTestBean.class;
    private static final String TEST_PROP = "fluentGetProperty";

    private static PropertyDescriptor[] fetchDescriptors() {
        PropertyUtilsBean pub = new PropertyUtilsBean();
        pub.removeBeanIntrospector((BeanIntrospector)SuppressPropertiesBeanIntrospector.SUPPRESS_CLASS);
        pub.addBeanIntrospector((BeanIntrospector)new FluentPropertyBeanIntrospector());
        return pub.getPropertyDescriptors(BEAN_CLASS);
    }

    private static PropertyDescriptor fetchTestDescriptor(BeanIntrospectionData bid) {
        return bid.getDescriptor(TEST_PROP);
    }

    private static BeanIntrospectionData setUpData() {
        return new BeanIntrospectionData(BeanIntrospectionDataTestCase.fetchDescriptors());
    }

    public void testGetWriteMethodDefined() {
        BeanIntrospectionData data = BeanIntrospectionDataTestCase.setUpData();
        PropertyDescriptor pd = BeanIntrospectionDataTestCase.fetchTestDescriptor(data);
        BeanIntrospectionDataTestCase.assertNotNull((String)"No write method", (Object)pd.getWriteMethod());
        BeanIntrospectionDataTestCase.assertEquals((String)"Wrong write method", (Object)pd.getWriteMethod(), (Object)data.getWriteMethod(BEAN_CLASS, pd));
    }

    public void testGetWriteMethodNonExisting() throws Exception {
        PropertyDescriptor pd = new PropertyDescriptor(TEST_PROP, BEAN_CLASS.getMethod("getFluentGetProperty", new Class[0]), BEAN_CLASS.getMethod("setFluentGetProperty", String.class));
        HashMap<String, String> methods = new HashMap<String, String>();
        methods.put(TEST_PROP, "hashCode");
        BeanIntrospectionData data = new BeanIntrospectionData(new PropertyDescriptor[]{pd}, methods);
        pd.setWriteMethod(null);
        BeanIntrospectionDataTestCase.assertNull((String)"Got a write method", (Object)data.getWriteMethod(BEAN_CLASS, pd));
    }

    public void testGetWriteMethodUndefined() throws Exception {
        BeanIntrospectionData data = BeanIntrospectionDataTestCase.setUpData();
        PropertyDescriptor pd = BeanIntrospectionDataTestCase.fetchTestDescriptor(data);
        Method writeMethod = pd.getWriteMethod();
        pd.setWriteMethod(null);
        BeanIntrospectionDataTestCase.assertEquals((String)"Wrong write method", (Object)writeMethod, (Object)data.getWriteMethod(BEAN_CLASS, pd));
        BeanIntrospectionDataTestCase.assertEquals((String)"Method not set in descriptor", (Object)writeMethod, (Object)pd.getWriteMethod());
    }

    public void testGetWriteMethodUnknown() {
        BeanIntrospectionData data = BeanIntrospectionDataTestCase.setUpData();
        PropertyDescriptor pd = data.getDescriptor("class");
        BeanIntrospectionDataTestCase.assertNull((String)"Got a write method", (Object)data.getWriteMethod(BEAN_CLASS, pd));
    }
}

