/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.beanutils.converters;

import java.math.BigDecimal;
import junit.framework.TestSuite;
import org.apache.commons.beanutils.Converter;
import org.apache.commons.beanutils.converters.BigDecimalConverter;
import org.apache.commons.beanutils.converters.NumberConverter;
import org.apache.commons.beanutils.converters.NumberConverterTestBase;

public class BigDecimalConverterTestCase
extends NumberConverterTestBase {
    private Converter converter;

    public static TestSuite suite() {
        return new TestSuite(BigDecimalConverterTestCase.class);
    }

    public BigDecimalConverterTestCase(String name) {
        super(name);
    }

    @Override
    protected Class<?> getExpectedType() {
        return BigDecimal.class;
    }

    @Override
    protected NumberConverter makeConverter() {
        return new BigDecimalConverter();
    }

    @Override
    protected NumberConverter makeConverter(Object defaultValue) {
        return new BigDecimalConverter(defaultValue);
    }

    public void setUp() throws Exception {
        this.converter = this.makeConverter();
        this.numbers[0] = new BigDecimal("-12");
        this.numbers[1] = new BigDecimal("13");
        this.numbers[2] = new BigDecimal("-22");
        this.numbers[3] = new BigDecimal("23");
    }

    public void tearDown() throws Exception {
        this.converter = null;
    }

    public void testSimpleConversion() throws Exception {
        String[] message = new String[]{"from String", "from String", "from String", "from String", "from String", "from Byte", "from Short", "from Integer", "from Long", "from Float", "from Double", "from BigDecimal", "from BigDecimal extension"};
        Object[] input = new Object[]{"-17.2", "-1.1", "0.0", "1.1", "17.2", (byte)7, (short)8, 9, 10L, Float.valueOf("11.1"), Double.valueOf("12.2"), new BigDecimal("3200.11"), new ExtendingBigDecimal("3200.11")};
        BigDecimal[] expected = new BigDecimal[]{new BigDecimal("-17.2"), new BigDecimal("-1.1"), new BigDecimal("0.0"), new BigDecimal("1.1"), new BigDecimal("17.2"), new BigDecimal("7"), new BigDecimal("8"), new BigDecimal("9"), new BigDecimal("10"), new BigDecimal("11.1"), new BigDecimal("12.2"), new BigDecimal("3200.11"), new BigDecimal("3200.11")};
        for (int i = 0; i < expected.length; ++i) {
            BigDecimalConverterTestCase.assertEquals((String)(message[i] + " to BigDecimal"), (Object)expected[i], (Object)this.converter.convert(BigDecimal.class, input[i]));
            BigDecimalConverterTestCase.assertEquals((String)(message[i] + " to null type"), (Object)expected[i], (Object)this.converter.convert(null, input[i]));
        }
    }

    private static class ExtendingBigDecimal
    extends BigDecimal {
        private static final long serialVersionUID = 1L;

        private ExtendingBigDecimal(String val) {
            super(val);
        }
    }
}

