/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.beanutils.locale.converters;

import java.math.BigInteger;
import org.apache.commons.beanutils.ConversionException;
import org.apache.commons.beanutils.locale.converters.BaseLocaleConverterTestCase;
import org.apache.commons.beanutils.locale.converters.BigIntegerLocaleConverter;

public class BigIntegerLocaleConverterTestCase
extends BaseLocaleConverterTestCase {
    public BigIntegerLocaleConverterTestCase(String name) {
        super(name);
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.defaultValue = new BigInteger("999");
        this.expectedValue = new BigInteger(this.expectedIntegerValue);
    }

    @Override
    public void tearDown() {
        super.tearDown();
    }

    public void testConstructor_2() {
        this.converter = new BigIntegerLocaleConverter();
        this.convertValueNoPattern(this.converter, this.defaultIntegerValue, this.expectedValue);
        this.convertValueWithPattern(this.converter, this.defaultIntegerValue, this.defaultIntegerPattern, this.expectedValue);
        this.convertInvalid(this.converter, null);
        this.convertNull(this.converter, null);
    }

    public void testConstructor_3() {
        this.converter = new BigIntegerLocaleConverter(true);
        this.convertValueNoPattern(this.converter, this.defaultIntegerValue, this.expectedValue);
        this.convertValueWithPattern(this.converter, this.defaultIntegerValue, this.defaultIntegerPattern, this.expectedValue);
        this.convertInvalid(this.converter, null);
        this.convertNull(this.converter, null);
    }

    public void testConstructor_4() {
        this.converter = new BigIntegerLocaleConverter(this.localizedLocale);
        this.convertValueNoPattern(this.converter, this.localizedIntegerValue, this.expectedValue);
        this.convertValueWithPattern(this.converter, this.localizedIntegerValue, this.defaultIntegerPattern, this.expectedValue);
        this.convertInvalid(this.converter, null);
        this.convertNull(this.converter, null);
    }

    public void testConstructor_5() {
        this.converter = new BigIntegerLocaleConverter(this.localizedLocale, true);
        this.convertValueNoPattern(this.converter, this.localizedIntegerValue, this.expectedValue);
        this.convertValueWithPattern(this.converter, this.localizedIntegerValue, this.localizedIntegerPattern, this.expectedValue);
        this.convertInvalid(this.converter, null);
        this.convertNull(this.converter, null);
    }

    public void testConstructor_6() {
        this.converter = new BigIntegerLocaleConverter(this.localizedLocale, this.defaultIntegerPattern);
        this.convertValueNoPattern(this.converter, this.localizedIntegerValue, this.expectedValue);
        this.convertValueWithPattern(this.converter, this.localizedIntegerValue, this.defaultIntegerPattern, this.expectedValue);
        this.convertInvalid(this.converter, null);
        this.convertNull(this.converter, null);
    }

    public void testConstructor_7() {
        this.converter = new BigIntegerLocaleConverter(this.localizedLocale, this.localizedIntegerPattern, true);
        this.convertValueNoPattern(this.converter, this.localizedIntegerValue, this.expectedValue);
        this.convertValueWithPattern(this.converter, this.localizedIntegerValue, this.localizedIntegerPattern, this.expectedValue);
        this.convertInvalid(this.converter, null);
        this.convertNull(this.converter, null);
    }

    public void testConstructor_8() {
        this.converter = new BigIntegerLocaleConverter(this.defaultValue);
        this.convertValueNoPattern(this.converter, this.defaultIntegerValue, this.expectedValue);
        this.convertValueWithPattern(this.converter, this.defaultIntegerValue, this.defaultIntegerPattern, this.expectedValue);
        this.convertInvalid(this.converter, this.defaultValue);
        this.convertNull(this.converter, this.defaultValue);
    }

    public void testConstructor_9() {
        this.converter = new BigIntegerLocaleConverter(this.defaultValue, true);
        this.convertValueNoPattern(this.converter, this.defaultIntegerValue, this.expectedValue);
        this.convertValueWithPattern(this.converter, this.defaultIntegerValue, this.defaultIntegerPattern, this.expectedValue);
        this.convertInvalid(this.converter, this.defaultValue);
        this.convertNull(this.converter, this.defaultValue);
    }

    public void testConstructorMain() {
        this.converter = new BigIntegerLocaleConverter(this.defaultValue, this.localizedLocale, this.localizedIntegerPattern, true);
        this.convertValueNoPattern(this.converter, "(A)", this.localizedIntegerValue, this.expectedValue);
        this.convertValueWithPattern(this.converter, "(A)", this.localizedIntegerValue, this.localizedIntegerPattern, this.expectedValue);
        this.convertInvalid(this.converter, "(A)", this.defaultValue);
        this.convertNull(this.converter, "(A)", this.defaultValue);
        this.convertValueNoPattern(this.converter, "(B)", this.defaultIntegerValue, new BigInteger("1"));
        this.convertValueWithPattern(this.converter, "(B)", this.localizedIntegerValue, this.defaultIntegerPattern, new BigInteger("1"));
        this.converter = new BigIntegerLocaleConverter(this.defaultValue, this.localizedLocale, this.defaultIntegerPattern, false);
        this.convertValueNoPattern(this.converter, "(C)", this.localizedIntegerValue, this.expectedValue);
        this.convertValueWithPattern(this.converter, "(C)", this.localizedIntegerValue, this.defaultIntegerPattern, this.expectedValue);
        this.convertInvalid(this.converter, "(C)", this.defaultValue);
        this.convertNull(this.converter, "(C)", this.defaultValue);
    }

    public void testUnsupportedType() {
        this.converter = new BigIntegerLocaleConverter();
        try {
            this.converter.convert(((Object)((Object)this)).getClass(), (Object)"test", null);
            BigIntegerLocaleConverterTestCase.fail((String)"Unsupported type not detected!");
        }
        catch (ConversionException conversionException) {
            // empty catch block
        }
    }
}

