/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.beanutils2.converters;

import org.apache.commons.beanutils2.ConversionException;
import org.apache.commons.beanutils2.converters.AbstractConverter;
import org.apache.commons.beanutils2.converters.BooleanConverter;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class BooleanConverterTest {
    public static final String[] STANDARD_TRUES = new String[]{"yes", "y", "true", "on", "1"};
    public static final String[] STANDARD_FALSES = new String[]{"no", "n", "false", "off", "0"};

    @Test
    public void testAdditionalStrings() {
        String[] trueStrings = new String[]{"sure"};
        String[] falseStrings = new String[]{"nope"};
        BooleanConverter converter = new BooleanConverter(trueStrings, falseStrings);
        this.testConversionValues((AbstractConverter<Boolean>)converter, new String[]{"sure", "Sure"}, new String[]{"nope", "nOpE"});
        Assertions.assertThrows(ConversionException.class, () -> BooleanConverterTest.lambda$testAdditionalStrings$0((AbstractConverter)converter));
        Assertions.assertThrows(ConversionException.class, () -> BooleanConverterTest.lambda$testAdditionalStrings$1((AbstractConverter)converter));
    }

    @Test
    public void testCaseInsensitivity() {
        BooleanConverter converter = new BooleanConverter();
        this.testConversionValues((AbstractConverter<Boolean>)converter, new String[]{"Yes", "TRUE"}, new String[]{"NO", "fAlSe"});
    }

    @Test
    public void testConversionToOtherType() {
        BooleanConverter converter = new BooleanConverter();
        Assertions.assertThrows(ConversionException.class, () -> BooleanConverterTest.lambda$testConversionToOtherType$2((AbstractConverter)converter));
    }

    protected void testConversionValues(AbstractConverter<Boolean> converter, String[] trueValues, String[] falseValues) {
        for (String trueValue : trueValues) {
            Assertions.assertEquals((Object)Boolean.TRUE, (Object)converter.convert(Boolean.class, (Object)trueValue));
        }
        for (String falseValue : falseValues) {
            Assertions.assertEquals((Object)Boolean.FALSE, (Object)converter.convert(Boolean.class, (Object)falseValue));
        }
    }

    @Test
    public void testDefaultValue() {
        Boolean defaultValue = Boolean.TRUE;
        BooleanConverter converter = new BooleanConverter(defaultValue);
        Assertions.assertSame((Object)defaultValue, (Object)converter.convert(Boolean.class, (Object)"bogus"));
        this.testConversionValues((AbstractConverter<Boolean>)converter, STANDARD_TRUES, STANDARD_FALSES);
    }

    @Test
    public void testInvalidString() {
        BooleanConverter converter = new BooleanConverter();
        Assertions.assertThrows(ConversionException.class, () -> BooleanConverterTest.lambda$testInvalidString$3((AbstractConverter)converter));
    }

    @Test
    public void testPrimitiveTargetClass() {
        BooleanConverter converter = new BooleanConverter();
        Assertions.assertTrue((boolean)((Boolean)converter.convert(Boolean.TYPE, (Object)STANDARD_TRUES[0])), (String)"Wrong result");
    }

    @Test
    public void testStandardValues() {
        BooleanConverter converter = new BooleanConverter();
        this.testConversionValues((AbstractConverter<Boolean>)converter, STANDARD_TRUES, STANDARD_FALSES);
    }

    private static /* synthetic */ void lambda$testInvalidString$3(AbstractConverter converter) throws Throwable {
        converter.convert(Boolean.class, (Object)"bogus");
    }

    private static /* synthetic */ void lambda$testConversionToOtherType$2(AbstractConverter converter) throws Throwable {
        converter.convert(Integer.class, (Object)STANDARD_TRUES[0]);
    }

    private static /* synthetic */ void lambda$testAdditionalStrings$1(AbstractConverter converter) throws Throwable {
        converter.convert(Boolean.class, (Object)"bogus");
    }

    private static /* synthetic */ void lambda$testAdditionalStrings$0(AbstractConverter converter) throws Throwable {
        converter.convert(Boolean.class, (Object)"true");
    }
}

