/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.beanutils2.converters;

import java.io.File;
import org.apache.commons.beanutils2.ConversionException;
import org.apache.commons.beanutils2.Converter;
import org.apache.commons.beanutils2.converters.FileConverter;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class FileConverterTest {
    private Converter<File> converter;

    protected Class<?> getExpectedType() {
        return File.class;
    }

    protected Converter<File> makeConverter() {
        return new FileConverter();
    }

    @BeforeEach
    public void setUp() throws Exception {
        this.converter = this.makeConverter();
    }

    @AfterEach
    public void tearDown() throws Exception {
        this.converter = null;
    }

    @Test
    public void testSimpleConversion() throws Exception {
        String[] message = new String[]{"from String", "from String", "from String"};
        Object[] input = new Object[]{"/tmp", "/tmp/foo.txt", "/tmp/does/not/exist.foo"};
        File[] expected = new File[]{new File("/tmp"), new File("/tmp/foo.txt"), new File("/tmp/does/not/exist.foo")};
        for (int i = 0; i < expected.length; ++i) {
            Assertions.assertEquals((Object)expected[i], (Object)this.converter.convert(File.class, input[i]), (String)(message[i] + " to File"));
            Assertions.assertEquals((Object)expected[i], (Object)this.converter.convert(null, input[i]), (String)(message[i] + " to null type"));
        }
    }

    @Test
    public void testUnsupportedTargetType() {
        Assertions.assertThrows(ConversionException.class, () -> this.converter.convert(Integer.class, (Object)"/tmp"));
    }
}

