/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.archivers.zip;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.util.Enumeration;
import org.apache.commons.compress.AbstractTest;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipFile;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;

class ZipFileIgnoringLocalFileHeaderTest {
    @TempDir
    private File dir;

    ZipFileIgnoringLocalFileHeaderTest() {
    }

    private static ZipFile openZipWithoutLocalFileHeader(String fileName) throws IOException {
        return ((ZipFile.Builder)((ZipFile.Builder)ZipFile.builder().setFile(AbstractTest.getFile(fileName))).setCharset(StandardCharsets.UTF_8.name())).setUseUnicodeExtraFields(true).setIgnoreLocalFileHeader(true).get();
    }

    private static ZipFile openZipWithoutLocalFileHeaderDeprecated(String fileName) throws IOException {
        return new ZipFile(AbstractTest.getFile(fileName), StandardCharsets.UTF_8.name(), true, true);
    }

    @Test
    void testDuplicateEntry() throws Exception {
        try (ZipFile zf = ZipFileIgnoringLocalFileHeaderTest.openZipWithoutLocalFileHeader("COMPRESS-227.zip");){
            int numberOfEntries = 0;
            for (ZipArchiveEntry entry : zf.getEntries("test1.txt")) {
                ++numberOfEntries;
                InputStream inputStream = zf.getInputStream(entry);
                try {
                    Assertions.assertNotNull((Object)inputStream);
                }
                finally {
                    if (inputStream == null) continue;
                    inputStream.close();
                }
            }
            Assertions.assertEquals((int)2, (int)numberOfEntries);
        }
    }

    @Test
    void testGetEntryWorks() throws IOException {
        try (ZipFile zf = ZipFileIgnoringLocalFileHeaderTest.openZipWithoutLocalFileHeader("bla.zip");){
            ZipArchiveEntry ze = zf.getEntry("test1.xml");
            Assertions.assertEquals((long)610L, (long)ze.getSize());
        }
    }

    @Test
    void testGetRawInputStreamReturnsNotNull() throws IOException {
        try (ZipFile zf = ZipFileIgnoringLocalFileHeaderTest.openZipWithoutLocalFileHeader("bla.zip");){
            ZipArchiveEntry ze = zf.getEntry("test1.xml");
            try (InputStream rawInputStream = zf.getRawInputStream(ze);){
                Assertions.assertNotNull((Object)rawInputStream);
            }
        }
    }

    @Test
    void testPhysicalOrder() throws IOException {
        try (ZipFile zf = ZipFileIgnoringLocalFileHeaderTest.openZipWithoutLocalFileHeader("ordertest.zip");){
            ZipArchiveEntry ze;
            Enumeration e = zf.getEntriesInPhysicalOrder();
            do {
                ze = (ZipArchiveEntry)e.nextElement();
            } while (e.hasMoreElements());
            Assertions.assertEquals((Object)"src/main/java/org/apache/commons/compress/archivers/zip/ZipUtil.java", (Object)ze.getName());
        }
    }

    @Test
    void testZipUnarchive() throws Exception {
        try (ZipFile zipFile = ZipFileIgnoringLocalFileHeaderTest.openZipWithoutLocalFileHeaderDeprecated("bla.zip");){
            zipFile.stream().forEach(entry -> {
                try (InputStream inputStream = zipFile.getInputStream(entry);){
                    Files.copy(inputStream, new File(this.dir, entry.getName()).toPath(), new CopyOption[0]);
                }
            });
        }
    }
}

