/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration2;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Properties;
import org.apache.commons.configuration2.BaseConfiguration;
import org.apache.commons.configuration2.Configuration;
import org.apache.commons.configuration2.convert.DefaultListDelimiterHandler;
import org.apache.commons.configuration2.convert.ListDelimiterHandler;
import org.apache.commons.configuration2.ex.ConversionException;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class TestBaseNullConfiguration {
    protected BaseConfiguration config;

    @BeforeEach
    public void setUp() throws Exception {
        this.config = new BaseConfiguration();
        this.config.setListDelimiterHandler((ListDelimiterHandler)new DefaultListDelimiterHandler(','));
        this.config.setThrowExceptionOnMissing(false);
    }

    @Test
    public void testCommaSeparatedString() {
        String prop = "hey, that's a test";
        this.config.setProperty("prop.string", (Object)"hey, that's a test");
        List list = this.config.getList("prop.string");
        Assertions.assertEquals(Arrays.asList("hey", "that's a test"), (Object)list);
    }

    @Test
    public void testCommaSeparatedStringEscaped() {
        String prop2 = "hey\\, that's a test";
        this.config.clearProperty("prop.string");
        this.config.setProperty("prop.string", (Object)"hey\\, that's a test");
        Assertions.assertEquals((Object)"hey, that's a test", (Object)this.config.getString("prop.string"));
    }

    @Test
    public void testGetBigDecimal() {
        this.config.setProperty("numberBigD", (Object)"123.456");
        BigDecimal number = new BigDecimal("123.456");
        BigDecimal defaultValue = new BigDecimal("654.321");
        Assertions.assertEquals((Object)number, (Object)this.config.getBigDecimal("numberBigD"));
        Assertions.assertEquals((Object)number, (Object)this.config.getBigDecimal("numberBigD", defaultValue));
        Assertions.assertEquals((Object)defaultValue, (Object)this.config.getBigDecimal("numberNotInConfig", defaultValue));
    }

    @Test
    public void testGetBigDecimalIncompatibleType() {
        this.config.setProperty("test.empty", (Object)"");
        Assertions.assertThrows(ConversionException.class, () -> this.config.getBigDecimal("test.empty"));
    }

    @Test
    public void testGetBigDecimalUnknown() {
        Assertions.assertNull((Object)this.config.getBigDecimal("numberNotInConfig"));
    }

    @Test
    public void testGetBigInteger() {
        this.config.setProperty("numberBigI", (Object)"1234567890");
        BigInteger number = new BigInteger("1234567890");
        BigInteger defaultValue = new BigInteger("654321");
        Assertions.assertEquals((Object)number, (Object)this.config.getBigInteger("numberBigI"));
        Assertions.assertEquals((Object)number, (Object)this.config.getBigInteger("numberBigI", defaultValue));
        Assertions.assertEquals((Object)defaultValue, (Object)this.config.getBigInteger("numberNotInConfig", defaultValue));
    }

    @Test
    public void testGetBigIntegerIncompatibleType() {
        this.config.setProperty("test.empty", (Object)"");
        Assertions.assertThrows(ConversionException.class, () -> this.config.getBigInteger("test.empty"));
    }

    @Test
    public void testGetBigIntegerUnknown() {
        Assertions.assertNull((Object)this.config.getBigInteger("numberNotInConfig"));
    }

    @Test
    public void testGetBoolean() {
        this.config.setProperty("boolA", (Object)Boolean.TRUE);
        boolean boolT = true;
        boolean boolF = false;
        Assertions.assertEquals((Object)true, (Object)this.config.getBoolean("boolA"));
        Assertions.assertEquals((Object)true, (Object)this.config.getBoolean("boolA", false));
        Assertions.assertEquals((Object)false, (Object)this.config.getBoolean("boolNotInConfig", false));
        Assertions.assertEquals((Object)true, (Object)this.config.getBoolean("boolA", Boolean.valueOf(false)));
    }

    @Test
    public void testGetBooleanIncompatibleType() {
        this.config.setProperty("test.empty", (Object)"");
        Assertions.assertThrows(ConversionException.class, () -> this.config.getBoolean("test.empty"));
    }

    @Test
    public void testGetBooleanUnknown() {
        Assertions.assertThrows(NoSuchElementException.class, () -> this.config.getBoolean("numberNotInConfig"));
    }

    @Test
    public void testGetByte() {
        this.config.setProperty("number", (Object)"1");
        boolean oneB = true;
        int twoB = 2;
        Assertions.assertEquals((byte)1, (byte)this.config.getByte("number"));
        Assertions.assertEquals((byte)1, (byte)this.config.getByte("number", (byte)2));
        Assertions.assertEquals((byte)2, (byte)this.config.getByte("numberNotInConfig", (byte)2));
        Assertions.assertEquals((Byte)1, (Byte)this.config.getByte("number", Byte.valueOf("2")));
    }

    @Test
    public void testGetByteIncompatibleType() {
        this.config.setProperty("test.empty", (Object)"");
        Assertions.assertThrows(ConversionException.class, () -> this.config.getByte("test.empty"));
    }

    @Test
    public void testGetByteUnknown() {
        Assertions.assertThrows(NoSuchElementException.class, () -> this.config.getByte("numberNotInConfig"));
    }

    @Test
    public void testGetDouble() {
        this.config.setProperty("numberD", (Object)"1.0");
        double oneD = 1.0;
        double twoD = 2.0;
        Assertions.assertEquals((double)1.0, (double)this.config.getDouble("numberD"), (double)0.0);
        Assertions.assertEquals((double)1.0, (double)this.config.getDouble("numberD", 2.0), (double)0.0);
        Assertions.assertEquals((double)2.0, (double)this.config.getDouble("numberNotInConfig", 2.0), (double)0.0);
        Assertions.assertEquals((Double)1.0, (Double)this.config.getDouble("numberD", Double.valueOf("2")));
    }

    @Test
    public void testGetDoubleIncompatibleType() {
        this.config.setProperty("test.empty", (Object)"");
        Assertions.assertThrows(ConversionException.class, () -> this.config.getDouble("test.empty"));
    }

    @Test
    public void testGetDoubleUnknown() {
        Assertions.assertThrows(NoSuchElementException.class, () -> this.config.getDouble("numberNotInConfig"));
    }

    @Test
    public void testGetFloat() {
        this.config.setProperty("numberF", (Object)"1.0");
        float oneF = 1.0f;
        float twoF = 2.0f;
        Assertions.assertEquals((float)1.0f, (float)this.config.getFloat("numberF"), (float)0.0f);
        Assertions.assertEquals((float)1.0f, (float)this.config.getFloat("numberF", 2.0f), (float)0.0f);
        Assertions.assertEquals((float)2.0f, (float)this.config.getFloat("numberNotInConfig", 2.0f), (float)0.0f);
        Assertions.assertEquals((Float)Float.valueOf(1.0f), (Float)this.config.getFloat("numberF", Float.valueOf("2")));
    }

    @Test
    public void testGetFloatIncompatibleType() {
        this.config.setProperty("test.empty", (Object)"");
        Assertions.assertThrows(ConversionException.class, () -> this.config.getFloat("test.empty"));
    }

    @Test
    public void testGetFloatUnknown() {
        Assertions.assertThrows(NoSuchElementException.class, () -> this.config.getFloat("numberNotInConfig"));
    }

    @Test
    public void testGetList() {
        this.config.addProperty("number", (Object)"1");
        this.config.addProperty("number", (Object)"2");
        List list = this.config.getList("number");
        Assertions.assertEquals(Arrays.asList("1", "2"), (Object)list);
    }

    @Test
    public void testGetListAsScalar() {
        this.config.addProperty("number", (Object)"1");
        this.config.addProperty("number", (Object)"2");
        Assertions.assertEquals((Object)"1", (Object)this.config.getString("number"));
    }

    @Test
    public void testGetLong() {
        this.config.setProperty("numberL", (Object)"1");
        long oneL = 1L;
        long twoL = 2L;
        Assertions.assertEquals((long)1L, (long)this.config.getLong("numberL"));
        Assertions.assertEquals((long)1L, (long)this.config.getLong("numberL", 2L));
        Assertions.assertEquals((long)2L, (long)this.config.getLong("numberNotInConfig", 2L));
        Assertions.assertEquals((Long)1L, (Long)this.config.getLong("numberL", Long.valueOf("2")));
    }

    @Test
    public void testGetLongIncompatibleTypes() {
        this.config.setProperty("test.empty", (Object)"");
        Assertions.assertThrows(ConversionException.class, () -> this.config.getLong("test.empty"));
    }

    @Test
    public void testGetLongUnknown() {
        Assertions.assertThrows(NoSuchElementException.class, () -> this.config.getLong("numberNotInConfig"));
    }

    @Test
    public void testGetProperty() {
        Assertions.assertNull((Object)this.config.getProperty("foo"));
        this.config.setProperty("number", (Object)"1");
        Assertions.assertEquals((Object)"1", (Object)this.config.getProperty("number"));
        Assertions.assertEquals((Object)"1", (Object)this.config.getString("number"));
    }

    @Test
    public void testGetShort() {
        this.config.setProperty("numberS", (Object)"1");
        boolean oneS = true;
        int twoS = 2;
        Assertions.assertEquals((short)1, (short)this.config.getShort("numberS"));
        Assertions.assertEquals((short)1, (short)this.config.getShort("numberS", (short)2));
        Assertions.assertEquals((short)2, (short)this.config.getShort("numberNotInConfig", (short)2));
        Assertions.assertEquals((Short)1, (Short)this.config.getShort("numberS", Short.valueOf("2")));
    }

    @Test
    public void testGetShortIncompatibleType() {
        this.config.setProperty("test.empty", (Object)"");
        Assertions.assertThrows(ConversionException.class, () -> this.config.getShort("test.empty"));
    }

    @Test
    public void testGetShortUnknown() {
        Assertions.assertThrows(NoSuchElementException.class, () -> this.config.getShort("numberNotInConfig"));
    }

    @Test
    public void testGetString() {
        this.config.setProperty("testString", (Object)"The quick brown fox");
        String string = "The quick brown fox";
        String defaultValue = "jumps over the lazy dog";
        Assertions.assertEquals((Object)"The quick brown fox", (Object)this.config.getString("testString"));
        Assertions.assertEquals((Object)"The quick brown fox", (Object)this.config.getString("testString", "jumps over the lazy dog"));
        Assertions.assertEquals((Object)"jumps over the lazy dog", (Object)this.config.getString("stringNotInConfig", "jumps over the lazy dog"));
    }

    @Test
    public void testGetStringUnknown() {
        Assertions.assertNull((Object)this.config.getString("stringNotInConfig"));
    }

    @Test
    public void testInterpolation() throws Exception {
        this.config.setProperty("applicationRoot", (Object)"/home/applicationRoot");
        this.config.setProperty("db", (Object)"${applicationRoot}/db/hypersonic");
        String unInterpolatedValue = "${applicationRoot2}/db/hypersonic";
        this.config.setProperty("dbFailedInterpolate", (Object)"${applicationRoot2}/db/hypersonic");
        String dbProp = "/home/applicationRoot/db/hypersonic";
        BaseConfiguration superProp = this.config;
        Assertions.assertEquals((Object)"/home/applicationRoot/db/hypersonic", (Object)superProp.getString("db"));
        Assertions.assertEquals((Object)"${applicationRoot2}/db/hypersonic", (Object)superProp.getString("dbFailedInterpolate"));
        superProp.setProperty("arrayInt", (Object)"${applicationRoot}/1");
        String[] arrayInt = superProp.getStringArray("arrayInt");
        Assertions.assertEquals((Object)"/home/applicationRoot/1", (Object)arrayInt[0]);
    }

    @Test
    public void testInterpolationLoop() throws Exception {
        this.config.setProperty("test.a", (Object)"${test.b}");
        this.config.setProperty("test.b", (Object)"${test.a}");
        Assertions.assertThrows(IllegalStateException.class, () -> this.config.getString("test.a"));
    }

    @Test
    public void testMultipleInterpolation() throws Exception {
        this.config.setProperty("test.base-level", (Object)"/base-level");
        this.config.setProperty("test.first-level", (Object)"${test.base-level}/first-level");
        this.config.setProperty("test.second-level", (Object)"${test.first-level}/second-level");
        this.config.setProperty("test.third-level", (Object)"${test.second-level}/third-level");
        String expectedValue = "/base-level/first-level/second-level/third-level";
        Assertions.assertEquals((Object)"/base-level/first-level/second-level/third-level", (Object)this.config.getString("test.third-level"));
    }

    @Test
    public void testPropertyAccess() {
        this.config.clearProperty("prop.properties");
        this.config.setProperty("prop.properties", (Object)"");
        Assertions.assertEquals((Object)new Properties(), (Object)this.config.getProperties("prop.properties"));
        this.config.clearProperty("prop.properties");
        this.config.setProperty("prop.properties", (Object)"foo=bar, baz=moo, seal=clubber");
        Properties p = new Properties();
        p.setProperty("foo", "bar");
        p.setProperty("baz", "moo");
        p.setProperty("seal", "clubber");
        Assertions.assertEquals((Object)p, (Object)this.config.getProperties("prop.properties"));
    }

    @Test
    public void testSubset() {
        String prop = "hey, that's a test";
        String prop2 = "hey\\, that's a test";
        this.config.setProperty("prop.string", (Object)"hey\\, that's a test");
        this.config.setProperty("property.string", (Object)"hello");
        Configuration subEprop = this.config.subset("prop");
        Assertions.assertEquals((Object)"hey, that's a test", (Object)subEprop.getString("string"));
        Assertions.assertEquals((int)1, (int)subEprop.getList("string").size());
        Iterator it = subEprop.getKeys();
        it.next();
        Assertions.assertFalse((boolean)it.hasNext());
        subEprop = this.config.subset("prop.");
        it = subEprop.getKeys();
        Assertions.assertFalse((boolean)it.hasNext());
    }

    @Test
    public void testThrowExceptionOnMissing() {
        Assertions.assertFalse((boolean)this.config.isThrowExceptionOnMissing());
    }
}

