/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration2.builder;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.commons.configuration2.BaseConfiguration;
import org.apache.commons.configuration2.BaseHierarchicalConfiguration;
import org.apache.commons.configuration2.Configuration;
import org.apache.commons.configuration2.HierarchicalConfiguration;
import org.apache.commons.configuration2.Initializable;
import org.apache.commons.configuration2.PropertiesConfiguration;
import org.apache.commons.configuration2.XMLConfiguration;
import org.apache.commons.configuration2.beanutils.BeanCreationContext;
import org.apache.commons.configuration2.beanutils.BeanDeclaration;
import org.apache.commons.configuration2.beanutils.BeanFactory;
import org.apache.commons.configuration2.beanutils.BeanHelper;
import org.apache.commons.configuration2.beanutils.DefaultBeanFactory;
import org.apache.commons.configuration2.beanutils.XMLBeanDeclaration;
import org.apache.commons.configuration2.builder.BasicBuilderParameters;
import org.apache.commons.configuration2.builder.BasicConfigurationBuilder;
import org.apache.commons.configuration2.builder.BuilderParameters;
import org.apache.commons.configuration2.builder.ConfigurationBuilder;
import org.apache.commons.configuration2.builder.EventListenerParameters;
import org.apache.commons.configuration2.convert.DefaultListDelimiterHandler;
import org.apache.commons.configuration2.convert.ListDelimiterHandler;
import org.apache.commons.configuration2.event.ConfigurationErrorEvent;
import org.apache.commons.configuration2.event.ConfigurationEvent;
import org.apache.commons.configuration2.event.ErrorListenerTestImpl;
import org.apache.commons.configuration2.event.EventListener;
import org.apache.commons.configuration2.event.EventListenerRegistrationData;
import org.apache.commons.configuration2.event.EventListenerTestImpl;
import org.apache.commons.configuration2.ex.ConfigurationException;
import org.apache.commons.configuration2.ex.ConfigurationRuntimeException;
import org.apache.commons.configuration2.reloading.ReloadingController;
import org.apache.commons.configuration2.reloading.ReloadingDetector;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

public class TestBasicConfigurationBuilder {
    private static ListDelimiterHandler listHandler;

    private static EventListener<ConfigurationEvent> createEventListener() {
        return (EventListener)Mockito.mock(EventListener.class);
    }

    private static Map<String, Object> createTestParameters() {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("throwExceptionOnMissing", Boolean.TRUE);
        params.put("listDelimiterHandler", listHandler);
        return params;
    }

    @BeforeAll
    public static void setUpBeforeClass() throws Exception {
        listHandler = new DefaultListDelimiterHandler(';');
    }

    @Test
    public void testAddConfigurationListener() throws ConfigurationException {
        EventListener<ConfigurationEvent> l1 = TestBasicConfigurationBuilder.createEventListener();
        EventListener<ConfigurationEvent> l2 = TestBasicConfigurationBuilder.createEventListener();
        BasicConfigurationBuilder builder = new BasicConfigurationBuilder(PropertiesConfiguration.class);
        builder.addEventListener(ConfigurationEvent.ANY, l1);
        PropertiesConfiguration config = (PropertiesConfiguration)builder.getConfiguration();
        builder.addEventListener(ConfigurationEvent.ANY, l2);
        Collection listeners = config.getEventListeners(ConfigurationEvent.ANY);
        Assertions.assertTrue((boolean)listeners.contains(l1));
        Assertions.assertTrue((boolean)listeners.contains(l2));
    }

    @Test
    public void testAddParameters() {
        BasicConfigurationBuilder builder = new BasicConfigurationBuilder(PropertiesConfiguration.class, TestBasicConfigurationBuilder.createTestParameters());
        Map<String, Object> params = TestBasicConfigurationBuilder.createTestParameters();
        params.put("anotherParameter", "value");
        Assertions.assertSame((Object)builder, (Object)builder.addParameters(params));
        Map params2 = builder.getParameters();
        Assertions.assertTrue((boolean)params2.keySet().containsAll(TestBasicConfigurationBuilder.createTestParameters().keySet()));
        Assertions.assertEquals((Object)"value", params2.get("anotherParameter"));
    }

    @Test
    public void testAddParametersNull() {
        BasicConfigurationBuilder builder = new BasicConfigurationBuilder(PropertiesConfiguration.class, TestBasicConfigurationBuilder.createTestParameters());
        Map params = builder.getParameters();
        builder.addParameters(null);
        Assertions.assertEquals((Object)params, (Object)builder.getParameters());
    }

    @Test
    public void testBeanHelperInConfiguration() throws ConfigurationException {
        final HashSet classesPassedToFactory = new HashSet();
        DefaultBeanFactory factory = new DefaultBeanFactory(){

            public Object createBean(BeanCreationContext bcc) throws Exception {
                classesPassedToFactory.add(bcc.getBeanClass());
                return super.createBean(bcc);
            }
        };
        BeanHelper helper = new BeanHelper((BeanFactory)factory);
        BasicConfigurationBuilder builder = new BasicConfigurationBuilder(PropertiesConfiguration.class);
        builder.configure(new BuilderParameters[]{new BasicBuilderParameters().setBeanHelper(helper)});
        PropertiesConfiguration config = (PropertiesConfiguration)builder.getConfiguration();
        Assertions.assertTrue((boolean)classesPassedToFactory.contains(config.getClass()));
    }

    @Test
    public void testConfigure() {
        BasicConfigurationBuilder builder = new BasicConfigurationBuilder(PropertiesConfiguration.class).configure(new BuilderParameters[]{new BasicBuilderParameters().setListDelimiterHandler(listHandler).setThrowExceptionOnMissing(true)});
        HashMap params2 = new HashMap(builder.getParameters());
        Assertions.assertEquals(TestBasicConfigurationBuilder.createTestParameters(), params2);
    }

    @Test
    public void testConnectToReloadingController() throws ConfigurationException {
        ReloadingDetector detector = (ReloadingDetector)Mockito.mock(ReloadingDetector.class);
        ReloadingController controller = new ReloadingController(detector);
        BasicConfigurationBuilder builder = new BasicConfigurationBuilder(PropertiesConfiguration.class);
        Configuration configuration = (Configuration)builder.getConfiguration();
        Mockito.when((Object)detector.isReloadingRequired()).thenReturn((Object)Boolean.TRUE);
        builder.connectToReloadingController(controller);
        controller.checkForReloading(null);
        Assertions.assertTrue((boolean)controller.isInReloadingState());
        Assertions.assertNotSame((Object)configuration, (Object)builder.getConfiguration());
        Assertions.assertFalse((boolean)controller.isInReloadingState());
        ((ReloadingDetector)Mockito.verify((Object)detector)).isReloadingRequired();
        ((ReloadingDetector)Mockito.verify((Object)detector)).reloadingPerformed();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{detector});
    }

    @Test
    public void testConnectToReloadingControllerNull() {
        BasicConfigurationBuilder builder = new BasicConfigurationBuilder(PropertiesConfiguration.class);
        Assertions.assertThrows(IllegalArgumentException.class, () -> builder.connectToReloadingController(null));
    }

    @Test
    public void testCopyEventListeners() throws ConfigurationException {
        EventListener<ConfigurationEvent> l1 = TestBasicConfigurationBuilder.createEventListener();
        EventListener<ConfigurationEvent> l2 = TestBasicConfigurationBuilder.createEventListener();
        ErrorListenerTestImpl l3 = new ErrorListenerTestImpl(null);
        BasicConfigurationBuilder builder = new BasicConfigurationBuilder(PropertiesConfiguration.class);
        builder.addEventListener(ConfigurationEvent.ANY, l1);
        builder.addEventListener(ConfigurationEvent.ANY_HIERARCHICAL, l2);
        builder.addEventListener(ConfigurationErrorEvent.ANY, (EventListener)l3);
        BasicConfigurationBuilder builder2 = new BasicConfigurationBuilder(XMLConfiguration.class);
        builder.copyEventListeners(builder2);
        XMLConfiguration config = (XMLConfiguration)builder2.getConfiguration();
        Collection listeners = config.getEventListeners(ConfigurationEvent.ANY);
        Assertions.assertEquals((int)1, (int)listeners.size());
        Assertions.assertTrue((boolean)listeners.contains(l1));
        listeners = config.getEventListeners(ConfigurationEvent.ANY_HIERARCHICAL);
        Assertions.assertEquals((int)2, (int)listeners.size());
        Assertions.assertTrue((boolean)listeners.contains(l1));
        Assertions.assertTrue((boolean)listeners.contains(l2));
        Collection errListeners = config.getEventListeners(ConfigurationErrorEvent.ANY);
        Assertions.assertEquals((int)1, (int)errListeners.size());
        Assertions.assertTrue((boolean)errListeners.contains(l3));
    }

    @Test
    public void testEventListenerConfiguration() throws ConfigurationException {
        EventListenerTestImpl listener1 = new EventListenerTestImpl(null);
        EventListenerRegistrationData regData = new EventListenerRegistrationData(ConfigurationErrorEvent.WRITE, (EventListener)new ErrorListenerTestImpl(null));
        BasicConfigurationBuilder builder = new BasicConfigurationBuilder(PropertiesConfiguration.class).configure(new BuilderParameters[]{new EventListenerParameters().addEventListener(ConfigurationEvent.ANY, (EventListener)listener1).addEventListener(regData)});
        PropertiesConfiguration config = (PropertiesConfiguration)builder.getConfiguration();
        Assertions.assertTrue((boolean)config.getEventListeners(ConfigurationEvent.ANY).contains(listener1));
        Assertions.assertTrue((boolean)config.getEventListeners(regData.getEventType()).contains(regData.getListener()));
    }

    @Test
    public void testGetConfiguration() throws ConfigurationException {
        PropertiesConfiguration config = (PropertiesConfiguration)new BasicConfigurationBuilder(PropertiesConfiguration.class).configure(new BuilderParameters[]{new BasicBuilderParameters().setListDelimiterHandler(listHandler).setThrowExceptionOnMissing(true)}).getConfiguration();
        Assertions.assertTrue((boolean)config.isThrowExceptionOnMissing());
        Assertions.assertEquals((Object)listHandler, (Object)config.getListDelimiterHandler());
    }

    @Test
    public void testGetConfigurationConcurrently() throws Exception {
        int threadCount = 32;
        CountDownLatch startLatch = new CountDownLatch(1);
        CountDownLatch endLatch = new CountDownLatch(32);
        BasicConfigurationBuilder builder = new BasicConfigurationBuilder(PropertiesConfiguration.class);
        AccessBuilderThread[] threads = new AccessBuilderThread[32];
        for (int i = 0; i < 32; ++i) {
            threads[i] = new AccessBuilderThread(startLatch, endLatch, (ConfigurationBuilder<?>)builder);
            threads[i].start();
        }
        startLatch.countDown();
        Assertions.assertTrue((boolean)endLatch.await(5L, TimeUnit.SECONDS));
        HashSet<Object> results = new HashSet<Object>();
        for (AccessBuilderThread t : threads) {
            results.add(t.result);
        }
        Assertions.assertEquals((int)1, (int)results.size());
    }

    @Test
    public void testGetParametersModify() {
        BasicConfigurationBuilder builder = new BasicConfigurationBuilder(PropertiesConfiguration.class, TestBasicConfigurationBuilder.createTestParameters());
        Map parameters = builder.getParameters();
        Assertions.assertThrows(UnsupportedOperationException.class, parameters::clear);
    }

    @Test
    public void testGetResultDeclarationInvalidBeanClass() {
        BasicConfigurationBuilder<PropertiesConfiguration> builder = new BasicConfigurationBuilder<PropertiesConfiguration>(PropertiesConfiguration.class, TestBasicConfigurationBuilder.createTestParameters()){

            protected BeanDeclaration createResultDeclaration(Map<String, Object> params) {
                return new XMLBeanDeclaration((HierarchicalConfiguration)new BaseHierarchicalConfiguration(), "bean", true, Object.class.getName());
            }
        };
        Assertions.assertThrows(ConfigurationRuntimeException.class, () -> ((BasicConfigurationBuilder)builder).getConfiguration());
    }

    @Test
    public void testInitializableCalled() throws ConfigurationException {
        BasicConfigurationBuilder builder = new BasicConfigurationBuilder(InitializableConfiguration.class);
        builder.configure(new BuilderParameters[]{new BasicBuilderParameters().setThrowExceptionOnMissing(true)});
        InitializableConfiguration config = (InitializableConfiguration)builder.getConfiguration();
        Assertions.assertEquals((Object)"Initialized with flag true", (Object)config.getInitProperty());
    }

    @Test
    public void testInitializationErrorAllowed() throws ConfigurationException {
        BasicConfigurationBuilderInitFailImpl builder = new BasicConfigurationBuilderInitFailImpl(true);
        PropertiesConfiguration config = (PropertiesConfiguration)builder.getConfiguration();
        Assertions.assertTrue((boolean)config.isEmpty());
    }

    @Test
    public void testInitializationErrorNotAllowed() {
        BasicConfigurationBuilderInitFailImpl builder = new BasicConfigurationBuilderInitFailImpl(false);
        Assertions.assertThrows(ConfigurationException.class, () -> ((BasicConfigurationBuilderInitFailImpl)builder).getConfiguration());
    }

    @Test
    public void testInitNoClass() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> new BasicConfigurationBuilder(null));
    }

    @Test
    public void testInitWithParameters() {
        Map<String, Object> params = TestBasicConfigurationBuilder.createTestParameters();
        BasicConfigurationBuilder builder = new BasicConfigurationBuilder(PropertiesConfiguration.class, params);
        HashMap params2 = new HashMap(builder.getParameters());
        Assertions.assertEquals(TestBasicConfigurationBuilder.createTestParameters(), params2);
    }

    @Test
    public void testInitWithParametersDefensiveCopy() {
        Map<String, Object> params = TestBasicConfigurationBuilder.createTestParameters();
        BasicConfigurationBuilder builder = new BasicConfigurationBuilder(PropertiesConfiguration.class, params);
        params.put("anotherParameter", "value");
        HashMap params2 = new HashMap(builder.getParameters());
        Assertions.assertEquals(TestBasicConfigurationBuilder.createTestParameters(), params2);
    }

    @Test
    public void testInitWithParametersNull() {
        BasicConfigurationBuilder builder = new BasicConfigurationBuilder(PropertiesConfiguration.class, null);
        Assertions.assertTrue((boolean)builder.getParameters().isEmpty());
    }

    @Test
    public void testRemoveConfigurationListener() throws ConfigurationException {
        EventListener<ConfigurationEvent> l1 = TestBasicConfigurationBuilder.createEventListener();
        EventListener<ConfigurationEvent> l2 = TestBasicConfigurationBuilder.createEventListener();
        BasicConfigurationBuilder builder = new BasicConfigurationBuilder(PropertiesConfiguration.class);
        builder.addEventListener(ConfigurationEvent.ANY_HIERARCHICAL, l1);
        builder.addEventListener(ConfigurationEvent.ANY, l2);
        Assertions.assertTrue((boolean)builder.removeEventListener(ConfigurationEvent.ANY, l2));
        PropertiesConfiguration config = (PropertiesConfiguration)builder.getConfiguration();
        Assertions.assertFalse((boolean)config.getEventListeners(ConfigurationEvent.ANY).contains(l2));
        Assertions.assertTrue((boolean)config.getEventListeners(ConfigurationEvent.ANY_HIERARCHICAL).contains(l1));
        builder.removeEventListener(ConfigurationEvent.ANY_HIERARCHICAL, l1);
        Assertions.assertFalse((boolean)config.getEventListeners(ConfigurationEvent.ANY_HIERARCHICAL).contains(l1));
    }

    @Test
    public void testRemoveConfigurationListenersOnReset() throws ConfigurationException {
        EventListenerTestImpl listener = new EventListenerTestImpl(null);
        BasicConfigurationBuilder builder = new BasicConfigurationBuilder(PropertiesConfiguration.class).configure(new BuilderParameters[]{new EventListenerParameters().addEventListener(ConfigurationEvent.ANY, (EventListener)listener)});
        PropertiesConfiguration config = (PropertiesConfiguration)builder.getConfiguration();
        builder.resetResult();
        config.addProperty("foo", (Object)"bar");
        listener.done();
    }

    @Test
    public void testReservedParameter() throws ConfigurationException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("throwExceptionOnMissing", Boolean.TRUE);
        params.put("config-test", "a test");
        BasicConfigurationBuilder builder = new BasicConfigurationBuilder(PropertiesConfiguration.class, params);
        PropertiesConfiguration config = (PropertiesConfiguration)builder.getConfiguration();
        Assertions.assertTrue((boolean)config.isThrowExceptionOnMissing());
    }

    @Test
    public void testReset() throws ConfigurationException {
        BasicConfigurationBuilder builder = new BasicConfigurationBuilder(PropertiesConfiguration.class, TestBasicConfigurationBuilder.createTestParameters());
        PropertiesConfiguration config = (PropertiesConfiguration)builder.getConfiguration();
        builder.reset();
        PropertiesConfiguration config2 = (PropertiesConfiguration)builder.getConfiguration();
        Assertions.assertNotSame((Object)config, (Object)config2);
        Assertions.assertFalse((boolean)config2.isThrowExceptionOnMissing());
    }

    @Test
    public void testResetParameters() {
        BasicConfigurationBuilder builder = new BasicConfigurationBuilder(PropertiesConfiguration.class, TestBasicConfigurationBuilder.createTestParameters());
        builder.resetParameters();
        Assertions.assertTrue((boolean)builder.getParameters().isEmpty());
    }

    @Test
    public void testResetResult() throws ConfigurationException {
        BasicConfigurationBuilder builder = new BasicConfigurationBuilder(PropertiesConfiguration.class, TestBasicConfigurationBuilder.createTestParameters());
        PropertiesConfiguration config = (PropertiesConfiguration)builder.getConfiguration();
        builder.resetResult();
        PropertiesConfiguration config2 = (PropertiesConfiguration)builder.getConfiguration();
        Assertions.assertNotSame((Object)config, (Object)config2);
        Assertions.assertTrue((boolean)config2.isThrowExceptionOnMissing());
    }

    @Test
    public void testSetParameters() {
        HashMap<String, String> params1 = new HashMap<String, String>();
        params1.put("someParameter", "value");
        BasicConfigurationBuilder builder = new BasicConfigurationBuilder(PropertiesConfiguration.class, params1);
        Assertions.assertSame((Object)builder, (Object)builder.setParameters(TestBasicConfigurationBuilder.createTestParameters()));
        HashMap params2 = new HashMap(builder.getParameters());
        Assertions.assertEquals(TestBasicConfigurationBuilder.createTestParameters(), params2);
    }

    private static final class AccessBuilderThread
    extends Thread {
        private final CountDownLatch startLatch;
        private final CountDownLatch endLatch;
        private final ConfigurationBuilder<?> builder;
        private volatile Object result;

        public AccessBuilderThread(CountDownLatch lstart, CountDownLatch lend, ConfigurationBuilder<?> bldr) {
            this.startLatch = lstart;
            this.endLatch = lend;
            this.builder = bldr;
        }

        @Override
        public void run() {
            try {
                this.startLatch.await();
                this.result = this.builder.getConfiguration();
            }
            catch (Exception ex) {
                this.result = ex;
            }
            finally {
                this.endLatch.countDown();
            }
        }
    }

    public static class InitializableConfiguration
    extends BaseConfiguration
    implements Initializable {
        private String initProperty;

        public String getInitProperty() {
            return this.initProperty;
        }

        public void initialize() {
            this.initProperty = "Initialized with flag " + this.isThrowExceptionOnMissing();
        }
    }

    private static final class BasicConfigurationBuilderInitFailImpl
    extends BasicConfigurationBuilder<PropertiesConfiguration> {
        public BasicConfigurationBuilderInitFailImpl(boolean allowFailOnInit) {
            super(PropertiesConfiguration.class, null, allowFailOnInit);
        }

        protected void initResultInstance(PropertiesConfiguration obj) throws ConfigurationException {
            throw new ConfigurationException("Initialization test exception!");
        }
    }
}

