/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration2;

import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.configuration2.Configuration;
import org.apache.commons.configuration2.PropertiesConfiguration;
import org.apache.commons.configuration2.SystemConfiguration;
import org.apache.commons.configuration2.TempDirUtils;
import org.apache.commons.configuration2.ex.ConfigurationException;
import org.apache.commons.configuration2.io.FileBased;
import org.apache.commons.configuration2.io.FileHandler;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;

public class TestSystemConfiguration {
    @TempDir
    public File tempFolder;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAppendWhileConcurrentAccess() throws InterruptedException {
        AtomicBoolean stop = new AtomicBoolean();
        String property = SystemConfiguration.class.getName() + ".testProperty";
        Thread t = new Thread(() -> {
            boolean setValue = true;
            while (!stop.get()) {
                if (setValue) {
                    System.setProperty(property, "true");
                } else {
                    System.clearProperty(property);
                }
                setValue = !setValue;
            }
        });
        try {
            t.start();
            SystemConfiguration config = new SystemConfiguration();
            PropertiesConfiguration props = new PropertiesConfiguration();
            props.append((Configuration)config);
            stop.set(true);
            t.join();
            Iterator keys = config.getKeys();
            while (keys.hasNext()) {
                String key = (String)keys.next();
                if (property.equals(key)) continue;
                Assertions.assertEquals((Object)config.getString(key), (Object)props.getString(key), (String)("Wrong value for " + key));
            }
        }
        finally {
            System.clearProperty(property);
        }
    }

    @Test
    public void testChangeSystemProperties() {
        String testProperty = "someTest";
        SystemConfiguration config = new SystemConfiguration();
        config.setProperty("someTest", (Object)"true");
        Assertions.assertEquals((Object)"true", (Object)System.getProperty("someTest"));
    }

    @Test
    public void testSetSystemProperties() {
        PropertiesConfiguration props = new PropertiesConfiguration();
        props.addProperty("test.name", (Object)"Apache");
        SystemConfiguration.setSystemProperties((Configuration)props);
        Assertions.assertEquals((Object)"Apache", (Object)System.getProperty("test.name"));
    }

    @Test
    public void testSetSystemPropertiesFromPropertiesFile() throws ConfigurationException, IOException {
        File file = TempDirUtils.newFile("sys.properties", this.tempFolder);
        PropertiesConfiguration pconfig = new PropertiesConfiguration();
        FileHandler handler = new FileHandler((FileBased)pconfig);
        pconfig.addProperty("fromFile", (Object)Boolean.TRUE);
        handler.setFile(file);
        handler.save();
        SystemConfiguration.setSystemProperties((String)handler.getBasePath(), (String)handler.getFileName());
        SystemConfiguration sconf = new SystemConfiguration();
        Assertions.assertTrue((boolean)sconf.getBoolean("fromFile"));
    }

    @Test
    public void testSystemConfiguration() {
        Properties props = System.getProperties();
        props.put("test.number", "123");
        SystemConfiguration conf = new SystemConfiguration();
        Assertions.assertEquals((int)123, (int)conf.getInt("test.number"));
    }
}

