/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.dbcp2;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.time.Duration;
import java.time.Instant;
import org.apache.commons.dbcp2.DelegatingConnection;
import org.apache.commons.dbcp2.PoolableConnection;
import org.apache.commons.dbcp2.PoolingConnection;
import org.apache.commons.dbcp2.TestBasicDataSource;
import org.apache.commons.dbcp2.TesterConnection;
import org.apache.commons.pool2.KeyedObjectPool;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class TestAbandonedBasicDataSource
extends TestBasicDataSource {
    private StringWriter sw;

    private void assertAndReset(DelegatingConnection<?> con) {
        Assertions.assertTrue((con.getLastUsedInstant().compareTo(Instant.EPOCH) > 0 ? 1 : 0) != 0);
        con.setLastUsed(Instant.EPOCH);
    }

    private void checkLastUsedPreparedStatement(PreparedStatement ps, DelegatingConnection<?> conn) throws Exception {
        ps.execute();
        this.assertAndReset(conn);
        try (ResultSet rs = ps.executeQuery();){
            Assertions.assertNotNull((Object)rs);
        }
        this.assertAndReset(conn);
        ps.executeUpdate();
        this.assertAndReset(conn);
    }

    private void checkLastUsedStatement(Statement st, DelegatingConnection<?> conn) throws Exception {
        st.execute("");
        this.assertAndReset(conn);
        st.execute("", new int[0]);
        this.assertAndReset(conn);
        st.execute("", 0);
        this.assertAndReset(conn);
        st.executeBatch();
        this.assertAndReset(conn);
        st.executeLargeBatch();
        this.assertAndReset(conn);
        try (ResultSet rs = st.executeQuery("");){
            Assertions.assertNotNull((Object)rs);
        }
        this.assertAndReset(conn);
        st.executeUpdate("");
        this.assertAndReset(conn);
        st.executeUpdate("", new int[0]);
        this.assertAndReset(conn);
        st.executeLargeUpdate("", new int[0]);
        this.assertAndReset(conn);
        st.executeUpdate("", 0);
        this.assertAndReset(conn);
        st.executeLargeUpdate("", 0);
        this.assertAndReset(conn);
        st.executeUpdate("", new String[0]);
        this.assertAndReset(conn);
        st.executeLargeUpdate("", new String[0]);
        this.assertAndReset(conn);
    }

    private void createStatement(Connection conn) throws Exception {
        PreparedStatement ps = conn.prepareStatement("");
        Assertions.assertNotNull((Object)ps);
    }

    @Override
    @BeforeEach
    public void setUp() throws Exception {
        super.setUp();
        this.ds.setLogAbandoned(true);
        this.ds.setRemoveAbandonedOnBorrow(true);
        this.ds.setRemoveAbandonedOnMaintenance(true);
        this.ds.setRemoveAbandonedTimeout(Duration.ofSeconds(10L));
        this.sw = new StringWriter();
        this.ds.setAbandonedLogWriter(new PrintWriter(this.sw));
    }

    @Test
    void testAbandoned() throws Exception {
        this.ds.setRemoveAbandonedTimeout(Duration.ZERO);
        this.ds.setMaxTotal(1);
        for (int i = 0; i < 3; ++i) {
            Assertions.assertNotNull((Object)this.ds.getConnection());
        }
    }

    @Test
    void testAbandonedClose() throws Exception {
        this.ds.setRemoveAbandonedTimeout(Duration.ZERO);
        this.ds.setMaxTotal(1);
        this.ds.setAccessToUnderlyingConnectionAllowed(true);
        try (Connection conn1 = this.getConnection();){
            Assertions.assertNotNull((Object)conn1);
            Assertions.assertEquals((int)1, (int)this.ds.getNumActive());
            try (Connection conn2 = this.getConnection();){
                Assertions.assertNotNull((Object)conn2);
                Assertions.assertEquals((int)1, (int)this.ds.getNumActive());
                Assertions.assertTrue((boolean)((DelegatingConnection)conn1).getInnermostDelegate().isClosed());
                TesterConnection tCon = (TesterConnection)((DelegatingConnection)conn1).getInnermostDelegate();
                Assertions.assertTrue((boolean)tCon.isAborted());
            }
            Assertions.assertEquals((int)0, (int)this.ds.getNumActive());
        }
        Assertions.assertEquals((int)0, (int)this.ds.getNumActive());
        String string = this.sw.toString();
        Assertions.assertTrue((boolean)string.contains("testAbandonedClose"), (String)string);
    }

    @Test
    void testAbandonedCloseWithExceptions() throws Exception {
        this.ds.setRemoveAbandonedTimeout(Duration.ZERO);
        this.ds.setMaxTotal(1);
        this.ds.setAccessToUnderlyingConnectionAllowed(true);
        Connection conn1 = this.getConnection();
        Assertions.assertNotNull((Object)conn1);
        Assertions.assertEquals((int)1, (int)this.ds.getNumActive());
        Connection conn2 = this.getConnection();
        Assertions.assertNotNull((Object)conn2);
        Assertions.assertEquals((int)1, (int)this.ds.getNumActive());
        TesterConnection tconn1 = (TesterConnection)((DelegatingConnection)conn1).getInnermostDelegate();
        tconn1.setFailure(new IOException("network error"));
        TesterConnection tconn2 = (TesterConnection)((DelegatingConnection)conn2).getInnermostDelegate();
        tconn2.setFailure(new IOException("network error"));
        try {
            conn2.close();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        Assertions.assertEquals((int)0, (int)this.ds.getNumActive());
        try {
            conn1.close();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        Assertions.assertEquals((int)0, (int)this.ds.getNumActive());
        String string = this.sw.toString();
        Assertions.assertTrue((boolean)string.contains("testAbandonedCloseWithExceptions"), (String)string);
    }

    @Test
    void testAbandonedStackTraces() throws Exception {
        this.ds.setRemoveAbandonedTimeout(Duration.ZERO);
        this.ds.setMaxTotal(1);
        this.ds.setAccessToUnderlyingConnectionAllowed(true);
        this.ds.setAbandonedUsageTracking(true);
        try (Connection conn1 = this.getConnection();){
            Assertions.assertNotNull((Object)conn1);
            Assertions.assertEquals((int)1, (int)this.ds.getNumActive());
            try (Statement stmt = conn1.createStatement();){
                Assertions.assertNotNull((Object)stmt);
                stmt.execute("SELECT 1 FROM DUAL");
            }
            try (Connection conn2 = this.getConnection();){
                Assertions.assertNotNull((Object)conn2);
                Assertions.assertEquals((int)1, (int)this.ds.getNumActive());
                Assertions.assertTrue((boolean)((DelegatingConnection)conn1).getInnermostDelegate().isClosed());
                TesterConnection tCon = (TesterConnection)((DelegatingConnection)conn1).getInnermostDelegate();
                Assertions.assertTrue((boolean)tCon.isAborted());
            }
            Assertions.assertEquals((int)0, (int)this.ds.getNumActive());
        }
        Assertions.assertEquals((int)0, (int)this.ds.getNumActive());
        String stackTrace = this.sw.toString();
        Assertions.assertTrue((boolean)stackTrace.contains("testAbandonedStackTraces"), (String)stackTrace);
        Assertions.assertTrue((boolean)stackTrace.contains("Pooled object created"), (String)stackTrace);
        Assertions.assertTrue((boolean)stackTrace.contains("The last code to use this object was:"), (String)stackTrace);
    }

    @Test
    void testGarbageCollectorCleanUp01() throws Exception {
        try (DelegatingConnection conn = (DelegatingConnection)this.ds.getConnection();){
            Assertions.assertEquals((int)0, (int)conn.getTrace().size());
            this.createStatement((Connection)conn);
            Assertions.assertEquals((int)1, (int)conn.getTrace().size());
            System.gc();
            Assertions.assertEquals((int)0, (int)conn.getTrace().size());
        }
    }

    @Test
    void testGarbageCollectorCleanUp02() throws Exception {
        this.ds.setPoolPreparedStatements(true);
        this.ds.setAccessToUnderlyingConnectionAllowed(true);
        DelegatingConnection conn = (DelegatingConnection)this.ds.getConnection();
        PoolableConnection poolableConn = (PoolableConnection)conn.getDelegate();
        PoolingConnection poolingConn = (PoolingConnection)poolableConn.getDelegate();
        KeyedObjectPool gkop = poolingConn.getStatementPool();
        Assertions.assertEquals((int)0, (int)conn.getTrace().size());
        Assertions.assertEquals((int)0, (int)gkop.getNumActive());
        this.createStatement((Connection)conn);
        Assertions.assertEquals((int)1, (int)conn.getTrace().size());
        Assertions.assertEquals((int)1, (int)gkop.getNumActive());
        System.gc();
        for (int count = 0; count < 50 && gkop.getNumActive() > 0; ++count) {
            Thread.sleep(100L);
        }
        Assertions.assertEquals((int)0, (int)gkop.getNumActive());
        Assertions.assertEquals((int)0, (int)conn.getTrace().size());
    }

    @Test
    void testLastUsed() throws Exception {
        this.ds.setRemoveAbandonedTimeout(Duration.ofSeconds(1L));
        this.ds.setMaxTotal(2);
        try (Connection conn1 = this.ds.getConnection();){
            Thread.sleep(500L);
            Statement s = conn1.createStatement();
            if (s != null) {
                s.close();
            }
            Thread.sleep(800L);
            Connection conn2 = this.ds.getConnection();
            Statement s2 = conn1.createStatement();
            if (s2 != null) {
                s2.close();
            }
            conn2.close();
            Thread.sleep(500L);
            PreparedStatement ps = conn1.prepareStatement("SELECT 1 FROM DUAL");
            if (ps != null) {
                ps.close();
            }
            Thread.sleep(800L);
            Connection c = this.ds.getConnection();
            if (c != null) {
                c.close();
            }
            if ((s2 = conn1.createStatement()) != null) {
                s2.close();
            }
        }
    }

    @Test
    void testLastUsedLargePreparedStatementUse() throws Exception {
        this.ds.setRemoveAbandonedTimeout(Duration.ofSeconds(1L));
        this.ds.setMaxTotal(2);
        try (Connection conn1 = this.ds.getConnection();
             Statement st = conn1.createStatement();){
            Statement s;
            String querySQL = "SELECT 1 FROM DUAL";
            Thread.sleep(500L);
            try (ResultSet rs = st.executeQuery("SELECT 1 FROM DUAL");){
                Assertions.assertNotNull((Object)rs);
            }
            Thread.sleep(800L);
            try (Connection conn2 = this.ds.getConnection();
                 ResultSet rs = st.executeQuery("SELECT 1 FROM DUAL");){
                Assertions.assertNotNull((Object)rs);
            }
            Thread.sleep(500L);
            st.executeLargeUpdate("");
            Thread.sleep(800L);
            Connection c = this.ds.getConnection();
            if (c != null) {
                c.close();
            }
            if ((s = conn1.createStatement()) != null) {
                s.close();
            }
        }
    }

    @Test
    void testLastUsedPrepareCall() throws Exception {
        this.ds.setRemoveAbandonedTimeout(Duration.ofSeconds(1L));
        this.ds.setMaxTotal(2);
        try (Connection conn1 = this.ds.getConnection();){
            Statement s;
            Thread.sleep(500L);
            CallableStatement cs = conn1.prepareCall("{call home}");
            if (cs != null) {
                cs.close();
            }
            Thread.sleep(800L);
            Connection conn2 = this.ds.getConnection();
            CallableStatement cs2 = conn1.prepareCall("{call home}");
            if (cs2 != null) {
                cs2.close();
            }
            conn2.close();
            Thread.sleep(500L);
            cs2 = conn1.prepareCall("{call home}");
            if (cs2 != null) {
                cs2.close();
            }
            Thread.sleep(800L);
            Connection c = this.ds.getConnection();
            if (c != null) {
                c.close();
            }
            if ((s = conn1.createStatement()) != null) {
                s.close();
            }
        }
    }

    @Test
    void testLastUsedPreparedStatementUse() throws Exception {
        this.ds.setRemoveAbandonedTimeout(Duration.ofSeconds(1L));
        this.ds.setMaxTotal(2);
        try (Connection conn1 = this.ds.getConnection();
             Statement st = conn1.createStatement();){
            Statement s;
            String querySQL = "SELECT 1 FROM DUAL";
            Thread.sleep(500L);
            Assertions.assertNotNull((Object)st.executeQuery("SELECT 1 FROM DUAL"));
            Thread.sleep(800L);
            Connection conn2 = this.ds.getConnection();
            Assertions.assertNotNull((Object)st.executeQuery("SELECT 1 FROM DUAL"));
            conn2.close();
            Thread.sleep(500L);
            st.executeUpdate("");
            Thread.sleep(800L);
            Connection c = this.ds.getConnection();
            if (c != null) {
                c.close();
            }
            if ((s = conn1.createStatement()) != null) {
                s.close();
            }
        }
    }

    @Test
    void testLastUsedUpdate() throws Exception {
        try (DelegatingConnection conn = (DelegatingConnection)this.ds.getConnection();
             PreparedStatement ps = conn.prepareStatement("");
             CallableStatement cs = conn.prepareCall("");
             PreparedStatement st = conn.prepareStatement("");){
            this.checkLastUsedStatement(ps, conn);
            this.checkLastUsedPreparedStatement(ps, conn);
            this.checkLastUsedStatement(cs, conn);
            this.checkLastUsedPreparedStatement(cs, conn);
            this.checkLastUsedStatement(st, conn);
        }
    }
}

