/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.geometry.io.core.internal;

import java.io.Reader;
import java.util.Arrays;
import java.util.List;
import java.util.function.IntConsumer;
import java.util.function.IntPredicate;
import org.apache.commons.geometry.io.core.internal.CharReadBuffer;
import org.apache.commons.geometry.io.core.internal.GeometryIOUtils;

public class SimpleTextParser {
    private static final int EOF = -1;
    private static final char CR = '\r';
    private static final char LF = '\n';
    private static final int DEFAULT_MAX_STRING_LENGTH = 1024;
    private static final String STRING_LENGTH_ERR_MSG = "string length exceeds maximum value of ";
    private static final int INITIAL_TOKEN_POS = -1;
    private static final IntConsumer NOOP_CONSUMER = ch -> {};
    private int lineNumber = 1;
    private int columnNumber = 1;
    private int maxStringLength = 1024;
    private String currentToken;
    private int currentTokenLineNumber = -1;
    private int currentTokenColumnNumber = -1;
    private boolean hasSetToken;
    private final CharReadBuffer buffer;

    public SimpleTextParser(Reader reader) {
        this(new CharReadBuffer(reader));
    }

    public SimpleTextParser(CharReadBuffer buffer) {
        this.buffer = buffer;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public void setLineNumber(int lineNumber) {
        this.lineNumber = lineNumber;
    }

    public int getColumnNumber() {
        return this.columnNumber;
    }

    public void setColumnNumber(int column) {
        this.columnNumber = column;
    }

    public int getMaxStringLength() {
        return this.maxStringLength;
    }

    public void setMaxStringLength(int maxStringLength) {
        if (maxStringLength < 0) {
            throw new IllegalArgumentException("Maximum string length cannot be less than zero; was " + maxStringLength);
        }
        this.maxStringLength = maxStringLength;
    }

    public String getCurrentToken() {
        return this.currentToken;
    }

    public boolean hasNonEmptyToken() {
        return this.currentToken != null && !this.currentToken.isEmpty();
    }

    public int getCurrentTokenLineNumber() {
        return this.currentTokenLineNumber;
    }

    public int getCurrentTokenColumnNumber() {
        return this.currentTokenColumnNumber;
    }

    public int getCurrentTokenAsInt() {
        this.ensureHasSetToken();
        NumberFormatException cause = null;
        if (this.currentToken != null) {
            try {
                return Integer.parseInt(this.currentToken);
            }
            catch (NumberFormatException exc) {
                cause = exc;
            }
        }
        throw this.unexpectedToken("integer", cause);
    }

    public double getCurrentTokenAsDouble() {
        this.ensureHasSetToken();
        NumberFormatException cause = null;
        if (this.currentToken != null) {
            try {
                return Double.parseDouble(this.currentToken);
            }
            catch (NumberFormatException exc) {
                cause = exc;
            }
        }
        throw this.unexpectedToken("double", cause);
    }

    public boolean hasMoreCharacters() {
        return this.buffer.hasMoreCharacters();
    }

    public boolean hasMoreCharactersOnLine() {
        return this.hasMoreCharacters() && SimpleTextParser.isNotNewLinePart(this.peekChar());
    }

    public int readChar() {
        int value = this.buffer.read();
        if (value == 10 || value == 13 && this.peekChar() != 10) {
            ++this.lineNumber;
            this.columnNumber = 1;
        } else if (value != -1) {
            ++this.columnNumber;
        }
        return value;
    }

    public SimpleTextParser next(int len) {
        this.validateRequestedStringLength(len);
        int line = this.getLineNumber();
        int col = this.getColumnNumber();
        String token = null;
        if (this.hasMoreCharacters()) {
            StringBuilder sb = new StringBuilder(len);
            this.consume(len, (int ch) -> sb.append((char)ch));
            token = sb.toString();
        }
        this.setToken(line, col, token);
        return this;
    }

    public SimpleTextParser nextWithLineContinuation(char lineContinuationChar, int len) {
        this.validateRequestedStringLength(len);
        int line = this.getLineNumber();
        int col = this.getColumnNumber();
        String token = null;
        if (this.hasMoreCharacters()) {
            StringBuilder sb = new StringBuilder(len);
            this.consumeWithLineContinuation(lineContinuationChar, len, (int ch) -> sb.append((char)ch));
            token = sb.toString();
        }
        this.setToken(line, col, token);
        return this;
    }

    public SimpleTextParser next(IntPredicate pred) {
        int line = this.getLineNumber();
        int col = this.getColumnNumber();
        String token = null;
        if (this.hasMoreCharacters()) {
            StringCollector collector = new StringCollector(line, col, pred);
            this.consume(collector, (IntConsumer)collector);
            token = collector.getString();
        }
        this.setToken(line, col, token);
        return this;
    }

    public SimpleTextParser nextWithLineContinuation(char lineContinuationChar, IntPredicate pred) {
        int line = this.getLineNumber();
        int col = this.getColumnNumber();
        String token = null;
        if (this.hasMoreCharacters()) {
            StringCollector collector = new StringCollector(line, col, pred);
            this.consumeWithLineContinuation(lineContinuationChar, collector, (IntConsumer)collector);
            token = collector.getString();
        }
        this.setToken(line, col, token);
        return this;
    }

    public SimpleTextParser nextLine() {
        this.next(SimpleTextParser::isNotNewLinePart);
        this.discardNewLineSequence();
        return this;
    }

    public SimpleTextParser nextAlphanumeric() {
        return this.next(SimpleTextParser::isAlphanumeric);
    }

    public SimpleTextParser discard(int len) {
        return this.consume(len, NOOP_CONSUMER);
    }

    public SimpleTextParser discardWithLineContinuation(char lineContinuationChar, int len) {
        return this.consumeWithLineContinuation(lineContinuationChar, len, NOOP_CONSUMER);
    }

    public SimpleTextParser discard(IntPredicate pred) {
        return this.consume(pred, NOOP_CONSUMER);
    }

    public SimpleTextParser discardWithLineContinuation(char lineContinuationChar, IntPredicate pred) {
        return this.consumeWithLineContinuation(lineContinuationChar, pred, NOOP_CONSUMER);
    }

    public SimpleTextParser discardWhitespace() {
        return this.discard(SimpleTextParser::isWhitespace);
    }

    public SimpleTextParser discardLineWhitespace() {
        return this.discard(SimpleTextParser::isLineWhitespace);
    }

    public SimpleTextParser discardNewLineSequence() {
        int value = this.peekChar();
        if (value == 10) {
            this.readChar();
        } else if (value == 13) {
            this.readChar();
            if (this.peekChar() == 10) {
                this.readChar();
            }
        }
        return this;
    }

    public SimpleTextParser discardLine() {
        this.discard(SimpleTextParser::isNotNewLinePart);
        this.discardNewLineSequence();
        return this;
    }

    public SimpleTextParser consume(IntPredicate pred, IntConsumer consumer) {
        int ch;
        while ((ch = this.peekChar()) != -1 && pred.test(ch)) {
            consumer.accept(this.readChar());
        }
        return this;
    }

    public SimpleTextParser consumeWithLineContinuation(char lineContinuationChar, int len, IntConsumer consumer) {
        int ch;
        int i = -1;
        while (++i < len && (ch = this.readChar()) != -1) {
            if (ch == lineContinuationChar && SimpleTextParser.isNewLinePart(this.peekChar())) {
                --i;
                this.discardNewLineSequence();
                continue;
            }
            consumer.accept(ch);
        }
        return this;
    }

    public SimpleTextParser consume(int len, IntConsumer consumer) {
        int ch;
        for (int i = 0; i < len && (ch = this.readChar()) != -1; ++i) {
            consumer.accept(ch);
        }
        return this;
    }

    public SimpleTextParser consumeWithLineContinuation(char lineContinuationChar, IntPredicate pred, IntConsumer consumer) {
        int ch;
        while ((ch = this.peekChar()) != -1) {
            if (ch == lineContinuationChar && SimpleTextParser.isNewLinePart(this.buffer.charAt(1))) {
                this.readChar();
                this.discardNewLineSequence();
                continue;
            }
            if (!pred.test(ch)) break;
            consumer.accept(this.readChar());
        }
        return this;
    }

    public int peekChar() {
        return this.buffer.peek();
    }

    public String peek(int len) {
        this.validateRequestedStringLength(len);
        return this.buffer.peekString(len);
    }

    public String peek(IntPredicate pred) {
        String token = null;
        if (this.hasMoreCharacters()) {
            StringCollector collector = new StringCollector(this.lineNumber, this.columnNumber, pred);
            int i = -1;
            int ch = this.buffer.charAt(++i);
            while (ch != -1 && collector.test(ch)) {
                collector.accept(ch);
                ch = this.buffer.charAt(++i);
            }
            token = collector.getString();
        }
        return token;
    }

    public SimpleTextParser match(String expected) {
        this.matchInternal(expected, true, true);
        return this;
    }

    public SimpleTextParser matchIgnoreCase(String expected) {
        this.matchInternal(expected, false, true);
        return this;
    }

    public boolean tryMatch(String expected) {
        return this.matchInternal(expected, true, false);
    }

    public boolean tryMatchIgnoreCase(String expected) {
        return this.matchInternal(expected, false, false);
    }

    private boolean matchInternal(String expected, boolean caseSensitive, boolean throwOnFailure) {
        this.ensureHasSetToken();
        if (!SimpleTextParser.stringsEqual(expected, this.currentToken, caseSensitive)) {
            if (throwOnFailure) {
                throw this.unexpectedToken("[" + expected + "]");
            }
            return false;
        }
        return true;
    }

    public int choose(String ... expected) {
        return this.choose(Arrays.asList(expected));
    }

    public int choose(List<String> expected) {
        return this.chooseInternal(expected, true, true);
    }

    public int chooseIgnoreCase(String ... expected) {
        return this.chooseIgnoreCase(Arrays.asList(expected));
    }

    public int chooseIgnoreCase(List<String> expected) {
        return this.chooseInternal(expected, false, true);
    }

    public int tryChoose(String ... expected) {
        return this.tryChoose(Arrays.asList(expected));
    }

    public int tryChoose(List<String> expected) {
        return this.chooseInternal(expected, true, false);
    }

    public int tryChooseIgnoreCase(String ... expected) {
        return this.tryChooseIgnoreCase(Arrays.asList(expected));
    }

    public int tryChooseIgnoreCase(List<String> expected) {
        return this.chooseInternal(expected, false, false);
    }

    private int chooseInternal(List<String> expected, boolean caseSensitive, boolean throwOnFailure) {
        this.ensureHasSetToken();
        int i = 0;
        for (String str : expected) {
            if (SimpleTextParser.stringsEqual(str, this.currentToken, caseSensitive)) {
                return i;
            }
            ++i;
        }
        if (throwOnFailure) {
            throw this.unexpectedToken("one of " + expected);
        }
        return -1;
    }

    public IllegalStateException unexpectedToken(String expected) {
        return this.unexpectedToken(expected, null);
    }

    public IllegalStateException unexpectedToken(String expected, Throwable cause) {
        StringBuilder msg = new StringBuilder();
        msg.append("expected ").append(expected).append(" but found ").append(this.getCurrentTokenDescription());
        int line = this.hasSetToken ? this.currentTokenLineNumber : this.lineNumber;
        int col = this.hasSetToken ? this.currentTokenColumnNumber : this.columnNumber;
        return this.parseError(line, col, msg.toString(), cause);
    }

    public IllegalStateException tokenError(String msg) {
        return this.tokenError(msg, null);
    }

    public IllegalStateException tokenError(String msg, Throwable cause) {
        int line = this.hasSetToken ? this.currentTokenLineNumber : this.lineNumber;
        int col = this.hasSetToken ? this.currentTokenColumnNumber : this.columnNumber;
        return this.parseError(line, col, msg, cause);
    }

    public IllegalStateException parseError(String msg) {
        return this.parseError(msg, null);
    }

    public IllegalStateException parseError(String msg, Throwable cause) {
        return this.parseError(this.lineNumber, this.columnNumber, msg, cause);
    }

    public IllegalStateException parseError(int line, int col, String msg) {
        return this.parseError(line, col, msg, null);
    }

    public IllegalStateException parseError(int line, int col, String msg, Throwable cause) {
        String fullMsg = String.format("Parsing failed at line %d, column %d: %s", line, col, msg);
        return GeometryIOUtils.parseError(fullMsg, cause);
    }

    private void setToken(int line, int col, String token) {
        this.currentTokenLineNumber = line;
        this.currentTokenColumnNumber = col;
        this.currentToken = token;
        this.hasSetToken = true;
    }

    private String getCurrentTokenDescription() {
        if (this.currentToken == null || this.currentToken.isEmpty()) {
            try {
                if (!this.hasMoreCharacters()) {
                    return "end of content";
                }
                if (this.currentToken != null) {
                    if (!this.hasMoreCharactersOnLine()) {
                        return "end of line";
                    }
                    return "empty token followed by [" + this.peek(1) + "]";
                }
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }
        if (this.currentToken == null) {
            return "no current token";
        }
        if (this.currentToken.isEmpty()) {
            return "empty token";
        }
        return "[" + this.currentToken + "]";
    }

    private void validateRequestedStringLength(int len) {
        if (len < 0) {
            throw new IllegalArgumentException("Requested string length cannot be negative; was " + len);
        }
        if (len > this.maxStringLength) {
            throw new IllegalArgumentException("Requested string length of " + len + " exceeds maximum value of " + this.maxStringLength);
        }
    }

    private void ensureHasSetToken() {
        if (!this.hasSetToken) {
            throw new IllegalStateException("No token has been read from the character stream");
        }
    }

    public static boolean isWhitespace(int ch) {
        return Character.isWhitespace(ch);
    }

    public static boolean isNotWhitespace(int ch) {
        return !SimpleTextParser.isWhitespace(ch);
    }

    public static boolean isLineWhitespace(int ch) {
        return SimpleTextParser.isWhitespace(ch) && SimpleTextParser.isNotNewLinePart(ch);
    }

    public static boolean isNewLinePart(int ch) {
        return ch == 13 || ch == 10;
    }

    public static boolean isNotNewLinePart(int ch) {
        return !SimpleTextParser.isNewLinePart(ch);
    }

    public static boolean isAlphanumeric(int ch) {
        return Character.isAlphabetic(ch) || Character.isDigit(ch);
    }

    public static boolean isNotAlphanumeric(int ch) {
        return !SimpleTextParser.isAlphanumeric(ch);
    }

    public static boolean isIntegerPart(int ch) {
        return Character.isDigit(ch) || ch == 45 || ch == 43;
    }

    public static boolean isDecimalPart(int ch) {
        return Character.isDigit(ch) || ch == 45 || ch == 43 || ch == 46 || ch == 101 || ch == 69;
    }

    private static boolean stringsEqual(String a, String b, boolean caseSensitive) {
        if (a == null) {
            return b == null;
        }
        return caseSensitive ? a.equals(b) : a.equalsIgnoreCase(b);
    }

    private final class StringCollector
    implements IntPredicate,
    IntConsumer {
        private final StringBuilder sb = new StringBuilder();
        private final int line;
        private final int col;
        private final IntPredicate pred;

        StringCollector(int line, int col, IntPredicate pred) {
            this.line = line;
            this.col = col;
            this.pred = pred;
        }

        @Override
        public boolean test(int value) {
            return this.pred.test(value) && !this.hasExceededMaxStringLength();
        }

        @Override
        public void accept(int value) {
            this.sb.append((char)value);
        }

        public String getString() {
            if (this.hasExceededMaxStringLength()) {
                throw SimpleTextParser.this.parseError(this.line, this.col, SimpleTextParser.STRING_LENGTH_ERR_MSG + SimpleTextParser.this.maxStringLength);
            }
            return this.sb.toString();
        }

        private boolean hasExceededMaxStringLength() {
            return this.sb.length() > SimpleTextParser.this.maxStringLength;
        }
    }
}

