/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.geometry.io.euclidean.threed;

import java.util.Collection;
import java.util.Objects;
import org.apache.commons.geometry.euclidean.threed.ConvexPolygon3D;
import org.apache.commons.geometry.euclidean.threed.Planes;
import org.apache.commons.geometry.euclidean.threed.Vector3D;
import org.apache.commons.geometry.io.euclidean.threed.FacetDefinition;
import org.apache.commons.numbers.core.Precision;

public final class FacetDefinitions {
    private FacetDefinitions() {
    }

    public static ConvexPolygon3D toPolygon(Collection<Vector3D> vertices, Vector3D normal, Precision.DoubleEquivalence precision) {
        ConvexPolygon3D polygon = Planes.convexPolygonFromVertices(vertices, (Precision.DoubleEquivalence)precision);
        if (normal != null && normal.dot((Vector3D)polygon.getPlane().getNormal()) < 0.0) {
            return polygon.reverse();
        }
        return polygon;
    }

    public static ConvexPolygon3D toPolygon(FacetDefinition facet, Precision.DoubleEquivalence precision) {
        Objects.requireNonNull(facet, "Facet cannot be null");
        Objects.requireNonNull(precision, "Precision context cannot be null");
        return FacetDefinitions.toPolygon(facet.getVertices(), facet.getNormal(), precision);
    }
}

