/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.geometry.io.euclidean.threed.obj;

import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.geometry.euclidean.threed.Vector3D;
import org.apache.commons.geometry.io.euclidean.threed.FacetDefinition;
import org.apache.commons.geometry.io.euclidean.threed.FacetDefinitionReader;
import org.apache.commons.geometry.io.euclidean.threed.SimpleFacetDefinition;
import org.apache.commons.geometry.io.euclidean.threed.obj.AbstractObjPolygonReader;
import org.apache.commons.geometry.io.euclidean.threed.obj.PolygonObjParser;

public class ObjFacetDefinitionReader
extends AbstractObjPolygonReader
implements FacetDefinitionReader {
    private final List<Vector3D> vertices = new ArrayList<Vector3D>();
    private final List<Vector3D> normals = new ArrayList<Vector3D>();

    public ObjFacetDefinitionReader(Reader reader) {
        super(reader);
    }

    @Override
    public FacetDefinition readFacet() {
        PolygonObjParser.Face face = this.readFace();
        if (face != null) {
            List<Vector3D> faceVertices = face.getVertices(this.vertices::get);
            Vector3D definedNormal = face.getDefinedCompositeNormal(this.normals::get);
            return new SimpleFacetDefinition(faceVertices, definedNormal);
        }
        return null;
    }

    @Override
    protected void handleVertex(Vector3D vertex) {
        this.vertices.add(vertex);
    }

    @Override
    protected void handleNormal(Vector3D normal) {
        this.normals.add(normal);
    }
}

