/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.geometry.io.euclidean.threed.stl;

import java.io.Closeable;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.Arrays;
import org.apache.commons.geometry.euclidean.threed.Vector3D;
import org.apache.commons.geometry.io.core.internal.GeometryIOUtils;
import org.apache.commons.geometry.io.euclidean.threed.FacetDefinitionReader;
import org.apache.commons.geometry.io.euclidean.threed.stl.BinaryStlFacetDefinition;
import org.apache.commons.geometry.io.euclidean.threed.stl.StlConstants;
import org.apache.commons.geometry.io.euclidean.threed.stl.StlUtils;

public class BinaryStlFacetDefinitionReader
implements FacetDefinitionReader {
    private final InputStream in;
    private final ByteBuffer triangleBuffer = StlUtils.byteBuffer(50);
    private ByteBuffer header = StlUtils.byteBuffer(80);
    private long triangleTotal;
    private long trianglesRead;
    private boolean hasReadHeader;

    public BinaryStlFacetDefinitionReader(InputStream in) {
        this.in = in;
    }

    public ByteBuffer getHeader() {
        this.beginRead();
        return ByteBuffer.wrap((byte[])this.header.array().clone());
    }

    public String getHeaderAsString() {
        return this.getHeaderAsString(StlConstants.DEFAULT_CHARSET);
    }

    public String getHeaderAsString(Charset charset) {
        String raw = charset.decode(this.getHeader()).toString();
        StringBuilder sb = new StringBuilder();
        for (char c : raw.toCharArray()) {
            if (Character.isISOControl(c)) continue;
            sb.append(c);
        }
        return sb.toString();
    }

    public long getNumTriangles() {
        this.beginRead();
        return this.triangleTotal;
    }

    @Override
    public BinaryStlFacetDefinition readFacet() {
        this.beginRead();
        BinaryStlFacetDefinition facet = null;
        if (this.trianglesRead < this.triangleTotal) {
            facet = this.readFacetInternal();
            ++this.trianglesRead;
        }
        return facet;
    }

    @Override
    public void close() {
        GeometryIOUtils.closeUnchecked((Closeable)this.in);
    }

    private void beginRead() {
        if (!this.hasReadHeader) {
            int headerBytesRead = GeometryIOUtils.applyAsIntUnchecked(this.in::read, (Object)this.header.array());
            if (headerBytesRead < 80) {
                throw BinaryStlFacetDefinitionReader.dataNotAvailable("header");
            }
            this.header.rewind();
            ByteBuffer triangleBuf = StlUtils.byteBuffer(4);
            if (this.fill(triangleBuf) < triangleBuf.capacity()) {
                throw BinaryStlFacetDefinitionReader.dataNotAvailable("triangle count");
            }
            this.triangleTotal = Integer.toUnsignedLong(triangleBuf.getInt());
            this.hasReadHeader = true;
        }
    }

    private BinaryStlFacetDefinition readFacetInternal() {
        if (this.fill(this.triangleBuffer) < this.triangleBuffer.capacity()) {
            throw BinaryStlFacetDefinitionReader.dataNotAvailable("triangle at index " + this.trianglesRead);
        }
        Vector3D normal = this.readVector(this.triangleBuffer);
        Vector3D p1 = this.readVector(this.triangleBuffer);
        Vector3D p2 = this.readVector(this.triangleBuffer);
        Vector3D p3 = this.readVector(this.triangleBuffer);
        int attr = Short.toUnsignedInt(this.triangleBuffer.getShort());
        return new BinaryStlFacetDefinition(Arrays.asList(p1, p2, p3), normal, attr);
    }

    private int fill(ByteBuffer buf) {
        int read = GeometryIOUtils.applyAsIntUnchecked(this.in::read, (Object)buf.array());
        buf.rewind();
        return read;
    }

    private Vector3D readVector(ByteBuffer buf) {
        double x = buf.getFloat();
        double y = buf.getFloat();
        double z = buf.getFloat();
        return Vector3D.of((double)x, (double)y, (double)z);
    }

    private static IllegalStateException dataNotAvailable(String name) {
        return GeometryIOUtils.parseError((String)("Failed to read STL " + name + ": data not available"));
    }
}

