/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.geometry.io.core.internal;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.UncheckedIOException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.util.stream.Stream;
import org.apache.commons.geometry.io.core.input.GeometryInput;
import org.apache.commons.geometry.io.core.internal.IOConsumer;
import org.apache.commons.geometry.io.core.internal.IOFunction;
import org.apache.commons.geometry.io.core.internal.IOSupplier;
import org.apache.commons.geometry.io.core.internal.IOToIntFunction;
import org.apache.commons.geometry.io.core.output.GeometryOutput;

public final class GeometryIOUtils {
    private static final char UNIX_PATH_SEP = '/';
    private static final char WINDOWS_PATH_SEP = '\\';

    private GeometryIOUtils() {
    }

    public static String getFileName(Path path) {
        if (path != null) {
            return GeometryIOUtils.getFileName(path.toString());
        }
        return null;
    }

    public static String getFileName(URL url) {
        if (url != null) {
            return GeometryIOUtils.getFileName(url.getPath());
        }
        return null;
    }

    public static String getFileName(String path) {
        int lastSep;
        if (path != null && (lastSep = Math.max(path.lastIndexOf(47), path.lastIndexOf(92))) < path.length() - 1) {
            return path.substring(lastSep + 1);
        }
        return null;
    }

    public static String getFileExtension(String fileName) {
        if (fileName != null) {
            int idx = fileName.lastIndexOf(46);
            if (idx > -1) {
                return fileName.substring(idx + 1);
            }
            return "";
        }
        return null;
    }

    public static BufferedReader createBufferedReader(GeometryInput input, Charset defaultCharset) {
        Charset charset = input.getCharset() != null ? input.getCharset() : defaultCharset;
        return new BufferedReader(new InputStreamReader(input.getInputStream(), charset));
    }

    public static BufferedWriter createBufferedWriter(GeometryOutput output, Charset defaultCharset) {
        Charset charset = output.getCharset() != null ? output.getCharset() : defaultCharset;
        return new BufferedWriter(new OutputStreamWriter(output.getOutputStream(), charset));
    }

    public static <T> T getUnchecked(IOSupplier<T> supplier) {
        try {
            return supplier.get();
        }
        catch (IOException exc) {
            throw GeometryIOUtils.createUnchecked(exc);
        }
    }

    public static <T> void acceptUnchecked(IOConsumer<T> consumer, T arg) {
        try {
            consumer.accept(arg);
        }
        catch (IOException exc) {
            throw GeometryIOUtils.createUnchecked(exc);
        }
    }

    public static <T> int applyAsIntUnchecked(IOToIntFunction<T> fn, T arg) {
        try {
            return fn.applyAsInt(arg);
        }
        catch (IOException exc) {
            throw GeometryIOUtils.createUnchecked(exc);
        }
    }

    public static void closeUnchecked(Closeable closeable) {
        try {
            closeable.close();
        }
        catch (IOException exc) {
            throw GeometryIOUtils.createUnchecked(exc);
        }
    }

    public static UncheckedIOException createUnchecked(IOException exc) {
        String msg = exc.getClass().getSimpleName() + ": " + exc.getMessage();
        return new UncheckedIOException(msg, exc);
    }

    public static IllegalStateException parseError(String msg) {
        return GeometryIOUtils.parseError(msg, null);
    }

    public static IllegalStateException parseError(String msg, Throwable cause) {
        return new IllegalStateException(msg, cause);
    }

    public static <T, C extends Closeable> T tryApplyCloseable(IOFunction<C, T> function, IOSupplier<? extends C> closeableSupplier) {
        RuntimeException exc;
        Closeable closeable = null;
        try {
            closeable = (Closeable)closeableSupplier.get();
            return function.apply(closeable);
        }
        catch (RuntimeException e) {
            exc = e;
        }
        catch (IOException e) {
            exc = GeometryIOUtils.createUnchecked(e);
        }
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (IOException suppressed) {
                exc.addSuppressed(suppressed);
            }
        }
        throw exc;
    }

    public static <T, I extends InputStream> Stream<T> createCloseableStream(IOFunction<I, Stream<T>> streamFunction, IOSupplier<? extends I> inputStreamSupplier) {
        return GeometryIOUtils.tryApplyCloseable(in -> (Stream)((Stream)streamFunction.apply(in)).onClose(GeometryIOUtils.closeAsUncheckedRunnable(in)), inputStreamSupplier);
    }

    private static Runnable closeAsUncheckedRunnable(Closeable closeable) {
        return () -> GeometryIOUtils.closeUnchecked(closeable);
    }
}

