/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.geometry.euclidean.twod;

import java.text.MessageFormat;
import org.apache.commons.geometry.euclidean.oned.Interval;
import org.apache.commons.geometry.euclidean.twod.Line;
import org.apache.commons.geometry.euclidean.twod.LineConvexSubset;
import org.apache.commons.geometry.euclidean.twod.LineSpanningSubset;
import org.apache.commons.geometry.euclidean.twod.Ray;
import org.apache.commons.geometry.euclidean.twod.ReverseRay;
import org.apache.commons.geometry.euclidean.twod.Segment;
import org.apache.commons.geometry.euclidean.twod.Vector2D;
import org.apache.commons.numbers.core.Precision;

public final class Lines {
    private Lines() {
    }

    public static Line fromPoints(Vector2D p1, Vector2D p2, Precision.DoubleEquivalence precision) {
        return Lines.fromPointAndDirection(p1, p1.vectorTo(p2), precision);
    }

    public static Line fromPointAndDirection(Vector2D pt, Vector2D dir, Precision.DoubleEquivalence precision) {
        if (dir.isZero(precision)) {
            throw new IllegalArgumentException("Line direction cannot be zero");
        }
        Vector2D.Unit normalizedDir = dir.normalize();
        double originOffset = normalizedDir.signedArea(pt);
        return new Line(normalizedDir, originOffset, precision);
    }

    public static Line fromPointAndAngle(Vector2D pt, double angle, Precision.DoubleEquivalence precision) {
        Vector2D.Unit dir = Vector2D.Unit.from(Math.cos(angle), Math.sin(angle));
        return Lines.fromPointAndDirection(pt, dir, precision);
    }

    public static Ray rayFromPointAndDirection(Vector2D startPoint, Vector2D direction, Precision.DoubleEquivalence precision) {
        Line line = Lines.fromPointAndDirection(startPoint, direction, precision);
        return new Ray(line, startPoint);
    }

    public static Ray rayFromPoint(Line line, Vector2D startPoint) {
        if (!startPoint.isFinite()) {
            throw new IllegalArgumentException("Invalid ray start point: " + startPoint);
        }
        return new Ray(line, line.project(startPoint));
    }

    public static Ray rayFromLocation(Line line, double startLocation) {
        if (!Double.isFinite(startLocation)) {
            throw new IllegalArgumentException("Invalid ray start location: " + startLocation);
        }
        return new Ray(line, line.toSpace(startLocation));
    }

    public static ReverseRay reverseRayFromPointAndDirection(Vector2D endPoint, Vector2D lineDirection, Precision.DoubleEquivalence precision) {
        Line line = Lines.fromPointAndDirection(endPoint, lineDirection, precision);
        return new ReverseRay(line, endPoint);
    }

    public static ReverseRay reverseRayFromPoint(Line line, Vector2D endPoint) {
        if (!endPoint.isFinite()) {
            throw new IllegalArgumentException("Invalid reverse ray end point: " + endPoint);
        }
        return new ReverseRay(line, line.project(endPoint));
    }

    public static ReverseRay reverseRayFromLocation(Line line, double endLocation) {
        if (!Double.isFinite(endLocation)) {
            throw new IllegalArgumentException("Invalid reverse ray end location: " + endLocation);
        }
        return new ReverseRay(line, line.toSpace(endLocation));
    }

    public static Segment segmentFromPoints(Vector2D startPoint, Vector2D endPoint, Precision.DoubleEquivalence precision) {
        Line line = Lines.fromPoints(startPoint, endPoint, precision);
        return new Segment(line, startPoint, endPoint);
    }

    public static Segment segmentFromPoints(Line line, Vector2D a, Vector2D b) {
        return Lines.segmentFromLocations(line, line.abscissa(a), line.abscissa(b));
    }

    public static Segment segmentFromLocations(Line line, double a, double b) {
        if (Double.isFinite(a) && Double.isFinite(b)) {
            double min = Math.min(a, b);
            double max = Math.max(a, b);
            return new Segment(line, line.toSpace(min), line.toSpace(max));
        }
        throw new IllegalArgumentException(MessageFormat.format("Invalid line segment locations: {0}, {1}", Double.toString(a), Double.toString(b)));
    }

    public static LineConvexSubset span(Line line) {
        return new LineSpanningSubset(line);
    }

    public static LineConvexSubset subsetFromInterval(Line line, Interval interval) {
        return Lines.subsetFromInterval(line, interval.getMin(), interval.getMax());
    }

    public static LineConvexSubset subsetFromInterval(Line line, double a, double b) {
        double min = Math.min(a, b);
        double max = Math.max(a, b);
        boolean hasMin = Double.isFinite(min);
        boolean hasMax = Double.isFinite(max);
        if (hasMin) {
            if (hasMax) {
                return new Segment(line, line.toSpace(min), line.toSpace(max));
            }
            return new Ray(line, line.toSpace(min));
        }
        if (hasMax) {
            return new ReverseRay(line, line.toSpace(max));
        }
        if (Double.isInfinite(min) && Double.isInfinite(max) && Double.compare(min, max) < 0) {
            return new LineSpanningSubset(line);
        }
        throw new IllegalArgumentException(MessageFormat.format("Invalid line subset interval: {0}, {1}", Double.toString(a), Double.toString(b)));
    }

    static void validateLinesEquivalent(Line expected, Line actual) {
        if (!expected.eq(actual, expected.getPrecision())) {
            throw new IllegalArgumentException("Arguments do not represent the same line. Expected " + (Object)((Object)expected) + " but was " + (Object)((Object)actual) + ".");
        }
    }
}

