/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import org.apache.commons.io.CopyUtils;
import org.apache.commons.io.input.CharSequenceInputStream;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.apache.commons.io.test.TestUtils;
import org.apache.commons.io.test.ThrowOnCloseInputStream;
import org.apache.commons.io.test.ThrowOnFlushAndCloseOutputStream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class CopyUtilsTest {
    private static final int FILE_SIZE = 4097;
    private final byte[] inData = TestUtils.generateTestData(4097L);

    CopyUtilsTest() {
    }

    @Test
    void testCopy_byteArrayToOutputStream() throws Exception {
        ByteArrayOutputStream baout = new ByteArrayOutputStream();
        ThrowOnFlushAndCloseOutputStream out = new ThrowOnFlushAndCloseOutputStream((OutputStream)baout, false, true);
        CopyUtils.copy((byte[])this.inData, (OutputStream)((Object)out));
        Assertions.assertEquals((int)this.inData.length, (int)baout.size(), (String)"Sizes differ");
        Assertions.assertArrayEquals((byte[])this.inData, (byte[])baout.toByteArray(), (String)"Content differs");
    }

    @Test
    void testCopy_byteArrayToWriter() throws Exception {
        ByteArrayOutputStream baout = new ByteArrayOutputStream();
        ThrowOnFlushAndCloseOutputStream out = new ThrowOnFlushAndCloseOutputStream((OutputStream)baout, false, true);
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)((Object)out), StandardCharsets.US_ASCII);
        CopyUtils.copy((byte[])this.inData, (Writer)writer);
        ((Writer)writer).flush();
        Assertions.assertEquals((int)this.inData.length, (int)baout.size(), (String)"Sizes differ");
        Assertions.assertArrayEquals((byte[])this.inData, (byte[])baout.toByteArray(), (String)"Content differs");
    }

    @Test
    void testCopy_byteArrayToWriterWithEncoding() throws Exception {
        String inDataStr = "data";
        String charsetName = StandardCharsets.UTF_8.name();
        StringWriter writer = new StringWriter();
        CopyUtils.copy((byte[])"data".getBytes(charsetName), (Writer)writer, (String)charsetName);
        Assertions.assertEquals((Object)"data", (Object)writer.toString());
    }

    @Test
    void testCopy_inputStreamToOutputStream() throws Exception {
        Object in = new ByteArrayInputStream(this.inData);
        in = new ThrowOnCloseInputStream((InputStream)in);
        ByteArrayOutputStream baout = new ByteArrayOutputStream();
        ThrowOnFlushAndCloseOutputStream out = new ThrowOnFlushAndCloseOutputStream((OutputStream)baout, false, true);
        int count = CopyUtils.copy((InputStream)in, (OutputStream)((Object)out));
        Assertions.assertEquals((int)0, (int)((InputStream)in).available(), (String)"Not all bytes were read");
        Assertions.assertEquals((int)this.inData.length, (int)baout.size(), (String)"Sizes differ");
        Assertions.assertArrayEquals((byte[])this.inData, (byte[])baout.toByteArray(), (String)"Content differs");
        Assertions.assertEquals((int)this.inData.length, (int)count);
    }

    @Test
    void testCopy_inputStreamToWriter() throws Exception {
        Object in = new ByteArrayInputStream(this.inData);
        in = new ThrowOnCloseInputStream((InputStream)in);
        ByteArrayOutputStream baout = new ByteArrayOutputStream();
        ThrowOnFlushAndCloseOutputStream out = new ThrowOnFlushAndCloseOutputStream((OutputStream)baout, false, true);
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)((Object)out), StandardCharsets.US_ASCII);
        CopyUtils.copy((InputStream)in, (Writer)writer);
        ((Writer)writer).flush();
        Assertions.assertEquals((int)0, (int)((InputStream)in).available(), (String)"Not all bytes were read");
        Assertions.assertEquals((int)this.inData.length, (int)baout.size(), (String)"Sizes differ");
        Assertions.assertArrayEquals((byte[])this.inData, (byte[])baout.toByteArray(), (String)"Content differs");
    }

    @Test
    void testCopy_inputStreamToWriterWithEncoding() throws Exception {
        String inDataStr = "data";
        String charsetName = StandardCharsets.UTF_8.name();
        StringWriter writer = new StringWriter();
        CopyUtils.copy((InputStream)((CharSequenceInputStream.Builder)((CharSequenceInputStream.Builder)new CharSequenceInputStream.Builder().setCharSequence((CharSequence)"data")).setCharset(charsetName)).get(), (Writer)writer, (String)charsetName);
        Assertions.assertEquals((Object)"data", (Object)writer.toString());
    }

    @Test
    void testCopy_readerToOutputStream() throws Exception {
        Object in = new ByteArrayInputStream(this.inData);
        in = new ThrowOnCloseInputStream((InputStream)in);
        InputStreamReader reader = new InputStreamReader((InputStream)in, StandardCharsets.US_ASCII);
        ByteArrayOutputStream baout = new ByteArrayOutputStream();
        ThrowOnFlushAndCloseOutputStream out = new ThrowOnFlushAndCloseOutputStream((OutputStream)baout, false, true);
        CopyUtils.copy((Reader)reader, (OutputStream)((Object)out));
        Assertions.assertEquals((int)this.inData.length, (int)baout.size(), (String)"Sizes differ");
        Assertions.assertArrayEquals((byte[])this.inData, (byte[])baout.toByteArray(), (String)"Content differs");
    }

    @Test
    void testCopy_readerToOutputStreamString() throws Exception {
        Object in = new ByteArrayInputStream(this.inData);
        in = new ThrowOnCloseInputStream((InputStream)in);
        InputStreamReader reader = new InputStreamReader((InputStream)in, StandardCharsets.US_ASCII);
        ByteArrayOutputStream baout = new ByteArrayOutputStream();
        ThrowOnFlushAndCloseOutputStream out = new ThrowOnFlushAndCloseOutputStream((OutputStream)baout, false, true);
        CopyUtils.copy((Reader)reader, (OutputStream)((Object)out), (String)StandardCharsets.US_ASCII.name());
        Assertions.assertEquals((int)this.inData.length, (int)baout.size(), (String)"Sizes differ");
        Assertions.assertArrayEquals((byte[])this.inData, (byte[])baout.toByteArray(), (String)"Content differs");
    }

    @Test
    void testCopy_readerToWriter() throws Exception {
        Object in = new ByteArrayInputStream(this.inData);
        in = new ThrowOnCloseInputStream((InputStream)in);
        InputStreamReader reader = new InputStreamReader((InputStream)in, StandardCharsets.US_ASCII);
        ByteArrayOutputStream baout = new ByteArrayOutputStream();
        ThrowOnFlushAndCloseOutputStream out = new ThrowOnFlushAndCloseOutputStream((OutputStream)baout, false, true);
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)((Object)out), StandardCharsets.US_ASCII);
        int count = CopyUtils.copy((Reader)reader, (Writer)writer);
        ((Writer)writer).flush();
        Assertions.assertEquals((int)this.inData.length, (int)count, (String)"The number of characters returned by copy is wrong");
        Assertions.assertEquals((int)this.inData.length, (int)baout.size(), (String)"Sizes differ");
        Assertions.assertArrayEquals((byte[])this.inData, (byte[])baout.toByteArray(), (String)"Content differs");
    }

    @Test
    void testCopy_stringToOutputStream() throws Exception {
        String str = new String(this.inData, StandardCharsets.US_ASCII);
        ByteArrayOutputStream baout = new ByteArrayOutputStream();
        ThrowOnFlushAndCloseOutputStream out = new ThrowOnFlushAndCloseOutputStream((OutputStream)baout, false, true);
        CopyUtils.copy((String)str, (OutputStream)((Object)out));
        Assertions.assertEquals((int)this.inData.length, (int)baout.size(), (String)"Sizes differ");
        Assertions.assertArrayEquals((byte[])this.inData, (byte[])baout.toByteArray(), (String)"Content differs");
    }

    @Test
    void testCopy_stringToOutputStreamString() throws Exception {
        String str = new String(this.inData, StandardCharsets.US_ASCII);
        ByteArrayOutputStream baout = new ByteArrayOutputStream();
        ThrowOnFlushAndCloseOutputStream out = new ThrowOnFlushAndCloseOutputStream((OutputStream)baout, false, true);
        CopyUtils.copy((String)str, (OutputStream)((Object)out), (String)StandardCharsets.US_ASCII.name());
        Assertions.assertEquals((int)this.inData.length, (int)baout.size(), (String)"Sizes differ");
        Assertions.assertArrayEquals((byte[])this.inData, (byte[])baout.toByteArray(), (String)"Content differs");
    }

    @Test
    void testCopy_stringToWriter() throws Exception {
        String str = new String(this.inData, StandardCharsets.US_ASCII);
        ByteArrayOutputStream baout = new ByteArrayOutputStream();
        ThrowOnFlushAndCloseOutputStream out = new ThrowOnFlushAndCloseOutputStream((OutputStream)baout, false, true);
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)((Object)out), StandardCharsets.US_ASCII);
        CopyUtils.copy((String)str, (Writer)writer);
        ((Writer)writer).flush();
        Assertions.assertEquals((int)this.inData.length, (int)baout.size(), (String)"Sizes differ");
        Assertions.assertArrayEquals((byte[])this.inData, (byte[])baout.toByteArray(), (String)"Content differs");
    }

    @Test
    void testCtor() {
        new CopyUtils();
    }
}

