/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.ode;

import org.apache.commons.math3.RealFieldElement;
import org.apache.commons.math3.exception.MaxCountExceededException;
import org.apache.commons.math3.ode.FieldODEStateAndDerivative;
import org.apache.commons.math3.ode.FirstOrderFieldIntegrator;
import org.apache.commons.math3.ode.TestFieldProblemAbstract;
import org.apache.commons.math3.ode.sampling.FieldStepHandler;
import org.apache.commons.math3.ode.sampling.FieldStepInterpolator;
import org.apache.commons.math3.util.MathUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestFieldProblemHandler<T extends RealFieldElement<T>>
implements FieldStepHandler<T> {
    private TestFieldProblemAbstract<T> problem;
    private T maxValueError;
    private T maxTimeError;
    private T lastError;
    private T lastTime;
    private FirstOrderFieldIntegrator<T> integrator;
    private T expectedStepStart;

    public TestFieldProblemHandler(TestFieldProblemAbstract<T> problem, FirstOrderFieldIntegrator<T> integrator) {
        this.problem = problem;
        this.integrator = integrator;
        this.maxValueError = (RealFieldElement)problem.getField().getZero();
        this.maxTimeError = (RealFieldElement)problem.getField().getZero();
        this.lastError = (RealFieldElement)problem.getField().getZero();
        this.expectedStepStart = null;
    }

    public void init(FieldODEStateAndDerivative<T> state0, T t) {
        this.maxValueError = (RealFieldElement)this.problem.getField().getZero();
        this.maxTimeError = (RealFieldElement)this.problem.getField().getZero();
        this.lastError = (RealFieldElement)this.problem.getField().getZero();
        this.expectedStepStart = null;
    }

    public void handleStep(FieldStepInterpolator<T> interpolator, boolean isLast) throws MaxCountExceededException {
        RealFieldElement start = this.integrator.getCurrentStepStart().getTime();
        if (((RealFieldElement)((RealFieldElement)((RealFieldElement)start.subtract((Object)this.problem.getInitialState().getTime())).divide((Object)this.integrator.getCurrentSignedStepsize())).abs()).getReal() > 0.001) {
            if (this.expectedStepStart != null) {
                RealFieldElement stepError = MathUtils.max(this.maxTimeError, (RealFieldElement)((RealFieldElement)((RealFieldElement)start.subtract(this.expectedStepStart)).abs()));
                for (RealFieldElement eventTime : this.problem.getTheoreticalEventsTimes()) {
                    stepError = MathUtils.min((RealFieldElement)stepError, (RealFieldElement)((RealFieldElement)((RealFieldElement)start.subtract((Object)eventTime)).abs()));
                }
                this.maxTimeError = MathUtils.max(this.maxTimeError, (RealFieldElement)stepError);
            }
            this.expectedStepStart = (RealFieldElement)start.add((Object)this.integrator.getCurrentSignedStepsize());
        }
        RealFieldElement pT = interpolator.getPreviousState().getTime();
        RealFieldElement cT = interpolator.getCurrentState().getTime();
        RealFieldElement[] errorScale = this.problem.getErrorScale();
        if (isLast) {
            RealFieldElement[] interpolatedY = interpolator.getInterpolatedState(cT).getState();
            RealFieldElement[] theoreticalY = this.problem.computeTheoreticalState(cT);
            for (int i = 0; i < interpolatedY.length; ++i) {
                RealFieldElement error = (RealFieldElement)((RealFieldElement)interpolatedY[i].subtract((Object)theoreticalY[i])).abs();
                this.lastError = MathUtils.max((RealFieldElement)error, this.lastError);
            }
            this.lastTime = cT;
        }
        for (int k = 0; k <= 20; ++k) {
            RealFieldElement time = (RealFieldElement)pT.add(((RealFieldElement)((RealFieldElement)cT.subtract((Object)pT)).multiply(k)).divide(20.0));
            RealFieldElement[] interpolatedY = interpolator.getInterpolatedState(time).getState();
            RealFieldElement[] theoreticalY = this.problem.computeTheoreticalState(time);
            for (int i = 0; i < interpolatedY.length; ++i) {
                RealFieldElement error = (RealFieldElement)errorScale[i].multiply(((RealFieldElement)interpolatedY[i].subtract((Object)theoreticalY[i])).abs());
                this.maxValueError = MathUtils.max((RealFieldElement)error, this.maxValueError);
            }
        }
    }

    public T getMaximalValueError() {
        return this.maxValueError;
    }

    public T getMaximalTimeError() {
        return this.maxTimeError;
    }

    public T getLastError() {
        return this.lastError;
    }

    public T getLastTime() {
        return this.lastTime;
    }
}

