/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.ode.sampling;

import org.apache.commons.math3.RealFieldElement;
import org.apache.commons.math3.exception.DimensionMismatchException;
import org.apache.commons.math3.exception.MaxCountExceededException;
import org.apache.commons.math3.exception.NoBracketingException;
import org.apache.commons.math3.exception.NumberIsTooSmallException;
import org.apache.commons.math3.ode.FieldExpandableODE;
import org.apache.commons.math3.ode.FieldODEStateAndDerivative;
import org.apache.commons.math3.ode.FirstOrderDifferentialEquations;
import org.apache.commons.math3.ode.FirstOrderFieldIntegrator;
import org.apache.commons.math3.ode.FirstOrderIntegrator;
import org.apache.commons.math3.ode.TestFieldProblemAbstract;
import org.apache.commons.math3.ode.TestProblemAbstract;
import org.apache.commons.math3.ode.sampling.FieldStepHandler;
import org.apache.commons.math3.ode.sampling.FieldStepInterpolator;
import org.apache.commons.math3.ode.sampling.StepHandler;
import org.apache.commons.math3.ode.sampling.StepInterpolator;
import org.apache.commons.math3.util.FastMath;
import org.junit.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StepInterpolatorTestUtils {
    public static void checkDerivativesConsistency(FirstOrderIntegrator integrator, TestProblemAbstract problem, final double finiteDifferencesRatio, final double threshold) throws DimensionMismatchException, NumberIsTooSmallException, MaxCountExceededException, NoBracketingException {
        integrator.addStepHandler(new StepHandler(){

            public void handleStep(StepInterpolator interpolator, boolean isLast) throws MaxCountExceededException {
                double dt = interpolator.getCurrentTime() - interpolator.getPreviousTime();
                double h = finiteDifferencesRatio * dt;
                double t = interpolator.getCurrentTime() - 0.3 * dt;
                if (FastMath.abs((double)h) < 10.0 * FastMath.ulp((double)t)) {
                    return;
                }
                interpolator.setInterpolatedTime(t - 4.0 * h);
                double[] yM4h = (double[])interpolator.getInterpolatedState().clone();
                interpolator.setInterpolatedTime(t - 3.0 * h);
                double[] yM3h = (double[])interpolator.getInterpolatedState().clone();
                interpolator.setInterpolatedTime(t - 2.0 * h);
                double[] yM2h = (double[])interpolator.getInterpolatedState().clone();
                interpolator.setInterpolatedTime(t - h);
                double[] yM1h = (double[])interpolator.getInterpolatedState().clone();
                interpolator.setInterpolatedTime(t + h);
                double[] yP1h = (double[])interpolator.getInterpolatedState().clone();
                interpolator.setInterpolatedTime(t + 2.0 * h);
                double[] yP2h = (double[])interpolator.getInterpolatedState().clone();
                interpolator.setInterpolatedTime(t + 3.0 * h);
                double[] yP3h = (double[])interpolator.getInterpolatedState().clone();
                interpolator.setInterpolatedTime(t + 4.0 * h);
                double[] yP4h = (double[])interpolator.getInterpolatedState().clone();
                interpolator.setInterpolatedTime(t);
                double[] yDot = interpolator.getInterpolatedDerivatives();
                for (int i = 0; i < yDot.length; ++i) {
                    double approYDot = (-3.0 * (yP4h[i] - yM4h[i]) + 32.0 * (yP3h[i] - yM3h[i]) + -168.0 * (yP2h[i] - yM2h[i]) + 672.0 * (yP1h[i] - yM1h[i])) / (840.0 * h);
                    Assert.assertEquals((String)("" + (approYDot - yDot[i])), (double)approYDot, (double)yDot[i], (double)threshold);
                }
            }

            public void init(double t0, double[] y0, double t) {
            }
        });
        integrator.integrate((FirstOrderDifferentialEquations)problem, problem.getInitialTime(), problem.getInitialState(), problem.getFinalTime(), new double[problem.getDimension()]);
    }

    public static <T extends RealFieldElement<T>> void checkDerivativesConsistency(FirstOrderFieldIntegrator<T> integrator, TestFieldProblemAbstract<T> problem, final double threshold) {
        integrator.addStepHandler(new FieldStepHandler<T>(){

            public void handleStep(FieldStepInterpolator<T> interpolator, boolean isLast) throws MaxCountExceededException {
                RealFieldElement h = (RealFieldElement)((RealFieldElement)interpolator.getCurrentState().getTime().subtract((Object)interpolator.getPreviousState().getTime())).multiply(0.001);
                RealFieldElement t = (RealFieldElement)interpolator.getCurrentState().getTime().subtract(h.multiply(300));
                if (((RealFieldElement)((RealFieldElement)h.abs()).subtract(FastMath.ulp((double)t.getReal()) * 10.0)).getReal() < 0.0) {
                    return;
                }
                RealFieldElement[] yM4h = interpolator.getInterpolatedState((RealFieldElement)t.add(h.multiply(-4))).getState();
                RealFieldElement[] yM3h = interpolator.getInterpolatedState((RealFieldElement)t.add(h.multiply(-3))).getState();
                RealFieldElement[] yM2h = interpolator.getInterpolatedState((RealFieldElement)t.add(h.multiply(-2))).getState();
                RealFieldElement[] yM1h = interpolator.getInterpolatedState((RealFieldElement)t.add(h.multiply(-1))).getState();
                RealFieldElement[] yP1h = interpolator.getInterpolatedState((RealFieldElement)t.add(h.multiply(1))).getState();
                RealFieldElement[] yP2h = interpolator.getInterpolatedState((RealFieldElement)t.add(h.multiply(2))).getState();
                RealFieldElement[] yP3h = interpolator.getInterpolatedState((RealFieldElement)t.add(h.multiply(3))).getState();
                RealFieldElement[] yP4h = interpolator.getInterpolatedState((RealFieldElement)t.add(h.multiply(4))).getState();
                RealFieldElement[] yDot = interpolator.getInterpolatedState(t).getDerivative();
                for (int i = 0; i < yDot.length; ++i) {
                    RealFieldElement approYDot = (RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)yP4h[i].subtract((Object)yM4h[i])).multiply(-3)).add(((RealFieldElement)yP3h[i].subtract((Object)yM3h[i])).multiply(32))).add(((RealFieldElement)yP2h[i].subtract((Object)yM2h[i])).multiply(-168))).add(((RealFieldElement)yP1h[i].subtract((Object)yM1h[i])).multiply(672))).divide(h.multiply(840));
                    Assert.assertEquals((double)approYDot.getReal(), (double)yDot[i].getReal(), (double)threshold);
                }
            }

            public void init(FieldODEStateAndDerivative<T> state0, T t) {
            }
        });
        integrator.integrate(new FieldExpandableODE(problem), problem.getInitialState(), problem.getFinalTime());
    }
}

