/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.optim.linear;

import java.util.ArrayList;
import java.util.Collection;
import org.apache.commons.math3.TestUtils;
import org.apache.commons.math3.optim.linear.LinearConstraint;
import org.apache.commons.math3.optim.linear.LinearObjectiveFunction;
import org.apache.commons.math3.optim.linear.Relationship;
import org.apache.commons.math3.optim.linear.SimplexTableau;
import org.apache.commons.math3.optim.nonlinear.scalar.GoalType;
import org.junit.Assert;
import org.junit.Test;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimplexTableauTest {
    @Test
    public void testInitialization() {
        LinearObjectiveFunction f = this.createFunction();
        Collection<LinearConstraint> constraints = this.createConstraints();
        SimplexTableau tableau = new SimplexTableau(f, constraints, GoalType.MAXIMIZE, false, 1.0E-6);
        double[][] expectedInitialTableau = new double[][]{{-1.0, 0.0, -1.0, -1.0, 2.0, 0.0, 0.0, 0.0, -4.0}, {0.0, 1.0, -15.0, -10.0, 25.0, 0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 1.0, 0.0, -1.0, 1.0, 0.0, 0.0, 2.0}, {0.0, 0.0, 0.0, 1.0, -1.0, 0.0, 1.0, 0.0, 3.0}, {0.0, 0.0, 1.0, 1.0, -2.0, 0.0, 0.0, 1.0, 4.0}};
        this.assertMatrixEquals(expectedInitialTableau, tableau.getData());
    }

    @Test
    public void testDropPhase1Objective() {
        LinearObjectiveFunction f = this.createFunction();
        Collection<LinearConstraint> constraints = this.createConstraints();
        SimplexTableau tableau = new SimplexTableau(f, constraints, GoalType.MAXIMIZE, false, 1.0E-6);
        double[][] expectedTableau = new double[][]{{1.0, -15.0, -10.0, 0.0, 0.0, 0.0, 0.0}, {0.0, 1.0, 0.0, 1.0, 0.0, 0.0, 2.0}, {0.0, 0.0, 1.0, 0.0, 1.0, 0.0, 3.0}, {0.0, 1.0, 1.0, 0.0, 0.0, 1.0, 4.0}};
        tableau.dropPhase1Objective();
        this.assertMatrixEquals(expectedTableau, tableau.getData());
    }

    @Test
    public void testTableauWithNoArtificialVars() {
        LinearObjectiveFunction f = new LinearObjectiveFunction(new double[]{15.0, 10.0}, 0.0);
        ArrayList<LinearConstraint> constraints = new ArrayList<LinearConstraint>();
        constraints.add(new LinearConstraint(new double[]{1.0, 0.0}, Relationship.LEQ, 2.0));
        constraints.add(new LinearConstraint(new double[]{0.0, 1.0}, Relationship.LEQ, 3.0));
        constraints.add(new LinearConstraint(new double[]{1.0, 1.0}, Relationship.LEQ, 4.0));
        SimplexTableau tableau = new SimplexTableau(f, constraints, GoalType.MAXIMIZE, false, 1.0E-6);
        double[][] initialTableau = new double[][]{{1.0, -15.0, -10.0, 25.0, 0.0, 0.0, 0.0, 0.0}, {0.0, 1.0, 0.0, -1.0, 1.0, 0.0, 0.0, 2.0}, {0.0, 0.0, 1.0, -1.0, 0.0, 1.0, 0.0, 3.0}, {0.0, 1.0, 1.0, -2.0, 0.0, 0.0, 1.0, 4.0}};
        this.assertMatrixEquals(initialTableau, tableau.getData());
    }

    @Test
    public void testSerial() {
        LinearObjectiveFunction f = this.createFunction();
        Collection<LinearConstraint> constraints = this.createConstraints();
        SimplexTableau tableau = new SimplexTableau(f, constraints, GoalType.MAXIMIZE, false, 1.0E-6);
        Assert.assertEquals((Object)tableau, (Object)TestUtils.serializeAndRecover(tableau));
    }

    private LinearObjectiveFunction createFunction() {
        return new LinearObjectiveFunction(new double[]{15.0, 10.0}, 0.0);
    }

    private Collection<LinearConstraint> createConstraints() {
        ArrayList<LinearConstraint> constraints = new ArrayList<LinearConstraint>();
        constraints.add(new LinearConstraint(new double[]{1.0, 0.0}, Relationship.LEQ, 2.0));
        constraints.add(new LinearConstraint(new double[]{0.0, 1.0}, Relationship.LEQ, 3.0));
        constraints.add(new LinearConstraint(new double[]{1.0, 1.0}, Relationship.EQ, 4.0));
        return constraints;
    }

    private void assertMatrixEquals(double[][] expected, double[][] result) {
        Assert.assertEquals((String)"Wrong number of rows.", (long)expected.length, (long)result.length);
        for (int i = 0; i < expected.length; ++i) {
            Assert.assertEquals((String)"Wrong number of columns.", (long)expected[i].length, (long)result[i].length);
            for (int j = 0; j < expected[i].length; ++j) {
                Assert.assertEquals((String)("Wrong value at position [" + i + "," + j + "]"), (double)expected[i][j], (double)result[i][j], (double)1.0E-15);
            }
        }
    }
}

