/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.optimization.general;

import java.io.BufferedReader;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.commons.math3.analysis.differentiation.DerivativeStructure;
import org.apache.commons.math3.analysis.differentiation.MultivariateDifferentiableVectorFunction;
import org.apache.commons.math3.util.MathArrays;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Deprecated
public abstract class StatisticalReferenceDataset {
    private final String name;
    private final int numObservations;
    private final int numParameters;
    private final int numStartingPoints;
    private final double[] x;
    private final double[] y;
    private final double[][] startingValues;
    private final double[] a;
    private final double[] sigA;
    private double residualSumOfSquares;
    private final MultivariateDifferentiableVectorFunction problem;

    public StatisticalReferenceDataset(BufferedReader in) throws IOException {
        ArrayList<String> lines = new ArrayList<String>();
        String line = in.readLine();
        while (line != null) {
            lines.add(line);
            line = in.readLine();
        }
        int[] index = StatisticalReferenceDataset.findLineNumbers("Data", lines);
        if (index == null) {
            throw new AssertionError((Object)"could not find line indices for data");
        }
        this.numObservations = index[1] - index[0] + 1;
        this.x = new double[this.numObservations];
        this.y = new double[this.numObservations];
        for (int i = 0; i < this.numObservations; ++i) {
            String line2 = lines.get(index[0] + i - 1);
            String[] tokens = line2.trim().split(" ++");
            this.y[i] = Double.parseDouble(tokens[0]);
            this.x[i] = Double.parseDouble(tokens[1]);
        }
        index = StatisticalReferenceDataset.findLineNumbers("Starting Values", lines);
        if (index == null) {
            throw new AssertionError((Object)"could not find line indices for starting values");
        }
        this.numParameters = index[1] - index[0] + 1;
        double[][] start = null;
        this.a = new double[this.numParameters];
        this.sigA = new double[this.numParameters];
        for (int i = 0; i < this.numParameters; ++i) {
            String line3 = lines.get(index[0] + i - 1);
            String[] tokens = line3.trim().split(" ++");
            if (start == null) {
                start = new double[tokens.length - 4][this.numParameters];
            }
            for (int j = 2; j < tokens.length - 2; ++j) {
                start[j - 2][i] = Double.parseDouble(tokens[j]);
            }
            this.a[i] = Double.parseDouble(tokens[tokens.length - 2]);
            this.sigA[i] = Double.parseDouble(tokens[tokens.length - 1]);
        }
        if (start == null) {
            throw new IOException("could not find starting values");
        }
        this.numStartingPoints = start.length;
        this.startingValues = start;
        double dummyDouble = Double.NaN;
        String dummyString = null;
        for (String line4 : lines) {
            if (line4.contains("Dataset Name:")) {
                dummyString = line4.substring(line4.indexOf("Dataset Name:") + 13, line4.indexOf("(")).trim();
            }
            if (!line4.contains("Residual Sum of Squares")) continue;
            String[] tokens = line4.split(" ++");
            dummyDouble = Double.parseDouble(tokens[4].trim());
        }
        if (Double.isNaN(dummyDouble)) {
            throw new IOException("could not find certified value of residual sum of squares");
        }
        this.residualSumOfSquares = dummyDouble;
        if (dummyString == null) {
            throw new IOException("could not find dataset name");
        }
        this.name = dummyString;
        this.problem = new MultivariateDifferentiableVectorFunction(){

            public double[] value(double[] a) {
                DerivativeStructure[] dsA = new DerivativeStructure[a.length];
                for (int i = 0; i < a.length; ++i) {
                    dsA[i] = new DerivativeStructure(a.length, 0, a[i]);
                }
                int n = StatisticalReferenceDataset.this.getNumObservations();
                double[] yhat = new double[n];
                for (int i = 0; i < n; ++i) {
                    yhat[i] = StatisticalReferenceDataset.this.getModelValue(StatisticalReferenceDataset.this.getX(i), dsA).getValue();
                }
                return yhat;
            }

            public DerivativeStructure[] value(DerivativeStructure[] a) {
                int n = StatisticalReferenceDataset.this.getNumObservations();
                DerivativeStructure[] yhat = new DerivativeStructure[n];
                for (int i = 0; i < n; ++i) {
                    yhat[i] = StatisticalReferenceDataset.this.getModelValue(StatisticalReferenceDataset.this.getX(i), a);
                }
                return yhat;
            }
        };
    }

    public String getName() {
        return this.name;
    }

    public int getNumObservations() {
        return this.numObservations;
    }

    public double[][] getData() {
        return new double[][]{MathArrays.copyOf((double[])this.x), MathArrays.copyOf((double[])this.y)};
    }

    public double getX(int i) {
        return this.x[i];
    }

    public double getY(int i) {
        return this.y[i];
    }

    public int getNumParameters() {
        return this.numParameters;
    }

    public double[] getParameters() {
        return MathArrays.copyOf((double[])this.a);
    }

    public double getParameter(int i) {
        return this.a[i];
    }

    public double[] getParametersStandardDeviations() {
        return MathArrays.copyOf((double[])this.sigA);
    }

    public double getParameterStandardDeviation(int i) {
        return this.sigA[i];
    }

    public double getResidualSumOfSquares() {
        return this.residualSumOfSquares;
    }

    public int getNumStartingPoints() {
        return this.numStartingPoints;
    }

    public double[] getStartingPoint(int i) {
        return MathArrays.copyOf((double[])this.startingValues[i]);
    }

    public MultivariateDifferentiableVectorFunction getLeastSquaresProblem() {
        return this.problem;
    }

    public abstract DerivativeStructure getModelValue(double var1, DerivativeStructure[] var3);

    private static int[] findLineNumbers(String key, Iterable<String> lines) {
        for (String text : lines) {
            boolean flag = text.contains(key) && text.contains("lines") && text.contains("to") && text.contains(")");
            if (!flag) continue;
            int[] numbers = new int[2];
            String from = text.substring(text.indexOf("lines") + 5, text.indexOf("to"));
            numbers[0] = Integer.parseInt(from.trim());
            String to = text.substring(text.indexOf("to") + 2, text.indexOf(")"));
            numbers[1] = Integer.parseInt(to.trim());
            return numbers;
        }
        return null;
    }
}

