/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.stat.descriptive;

import java.util.ArrayList;
import org.apache.commons.math3.TestUtils;
import org.apache.commons.math3.distribution.NormalDistribution;
import org.apache.commons.math3.distribution.UniformIntegerDistribution;
import org.apache.commons.math3.stat.descriptive.UnivariateStatistic;
import org.apache.commons.math3.stat.descriptive.WeightedEvaluation;
import org.apache.commons.math3.util.FastMath;
import org.junit.Assert;
import org.junit.Test;

public abstract class UnivariateStatisticAbstractTest {
    protected double mean = 12.404545454545454;
    protected double geoMean = 12.070589161633011;
    protected double var = 10.00235930735931;
    protected double std = FastMath.sqrt((double)this.var);
    protected double skew = 1.43742372919619;
    protected double kurt = 2.3771912648047;
    protected double min = 8.2;
    protected double max = 21.0;
    protected double median = 12.0;
    protected double percentile5 = 8.29;
    protected double percentile95 = 20.82;
    protected double product = 6.280964005638334E23;
    protected double sumLog = 54.796980611645154;
    protected double sumSq = 3595.25;
    protected double sum = 272.9;
    protected double secondMoment = 210.04954545454547;
    protected double thirdMoment = 868.0906859504136;
    protected double fourthMoment = 9244.080993773481;
    protected double weightedMean = 12.366995073891626;
    protected double weightedVar = 9.974760968886391;
    protected double weightedStd = FastMath.sqrt((double)this.weightedVar);
    protected double weightedProduct = 8.517647448765288E21;
    protected double weightedSum = 251.05;
    protected double tolerance = 1.0E-11;
    protected double[] testArray = new double[]{12.5, 12.0, 11.8, 14.2, 14.9, 14.5, 21.0, 8.2, 10.3, 11.3, 14.1, 9.9, 12.2, 12.0, 12.1, 11.0, 19.8, 11.0, 10.0, 8.8, 9.0, 12.3};
    protected double[] testWeightsArray = new double[]{1.5, 0.8, 1.2, 0.4, 0.8, 1.8, 1.2, 1.1, 1.0, 0.7, 1.3, 0.6, 0.7, 1.3, 0.7, 1.0, 0.4, 0.1, 1.4, 0.9, 1.1, 0.3};
    protected double[] identicalWeightsArray = new double[]{0.5, 0.5, 0.5, 0.5, 0.5, 0.5, 0.5, 0.5, 0.5, 0.5, 0.5, 0.5, 0.5, 0.5, 0.5, 0.5, 0.5, 0.5, 0.5, 0.5, 0.5, 0.5};
    protected double[] unitWeightsArray = new double[]{1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0};

    public abstract UnivariateStatistic getUnivariateStatistic();

    public abstract double expectedValue();

    public double getTolerance() {
        return this.tolerance;
    }

    @Test
    public void testEvaluation() {
        Assert.assertEquals((double)this.expectedValue(), (double)this.getUnivariateStatistic().evaluate(this.testArray), (double)this.getTolerance());
    }

    @Test
    public void testEvaluateArraySegment() {
        UnivariateStatistic stat = this.getUnivariateStatistic();
        double[] arrayZero = new double[5];
        System.arraycopy(this.testArray, 0, arrayZero, 0, 5);
        Assert.assertEquals((double)stat.evaluate(arrayZero), (double)stat.evaluate(this.testArray, 0, 5), (double)0.0);
        double[] arrayOne = new double[5];
        System.arraycopy(this.testArray, 5, arrayOne, 0, 5);
        Assert.assertEquals((double)stat.evaluate(arrayOne), (double)stat.evaluate(this.testArray, 5, 5), (double)0.0);
        double[] arrayEnd = new double[5];
        System.arraycopy(this.testArray, this.testArray.length - 5, arrayEnd, 0, 5);
        Assert.assertEquals((double)stat.evaluate(arrayEnd), (double)stat.evaluate(this.testArray, this.testArray.length - 5, 5), (double)0.0);
    }

    @Test
    public void testEvaluateArraySegmentWeighted() {
        UnivariateStatistic statistic = this.getUnivariateStatistic();
        if (!(statistic instanceof WeightedEvaluation)) {
            return;
        }
        WeightedEvaluation stat = (WeightedEvaluation)this.getUnivariateStatistic();
        double[] arrayZero = new double[5];
        double[] weightZero = new double[5];
        System.arraycopy(this.testArray, 0, arrayZero, 0, 5);
        System.arraycopy(this.testWeightsArray, 0, weightZero, 0, 5);
        Assert.assertEquals((double)stat.evaluate(arrayZero, weightZero), (double)stat.evaluate(this.testArray, this.testWeightsArray, 0, 5), (double)0.0);
        double[] arrayOne = new double[5];
        double[] weightOne = new double[5];
        System.arraycopy(this.testArray, 5, arrayOne, 0, 5);
        System.arraycopy(this.testWeightsArray, 5, weightOne, 0, 5);
        Assert.assertEquals((double)stat.evaluate(arrayOne, weightOne), (double)stat.evaluate(this.testArray, this.testWeightsArray, 5, 5), (double)0.0);
        double[] arrayEnd = new double[5];
        double[] weightEnd = new double[5];
        System.arraycopy(this.testArray, this.testArray.length - 5, arrayEnd, 0, 5);
        System.arraycopy(this.testWeightsArray, this.testArray.length - 5, weightEnd, 0, 5);
        Assert.assertEquals((double)stat.evaluate(arrayEnd, weightEnd), (double)stat.evaluate(this.testArray, this.testWeightsArray, this.testArray.length - 5, 5), (double)0.0);
    }

    @Test
    public void testCopy() {
        UnivariateStatistic original = this.getUnivariateStatistic();
        UnivariateStatistic copy = original.copy();
        Assert.assertEquals((double)this.expectedValue(), (double)copy.evaluate(this.testArray), (double)this.getTolerance());
    }

    @Test
    public void testWeightedConsistency() {
        UnivariateStatistic statistic = this.getUnivariateStatistic();
        if (!(statistic instanceof WeightedEvaluation)) {
            return;
        }
        int len = 10;
        double mu = 0.0;
        double sigma = 5.0;
        double[] values = new double[10];
        double[] weights = new double[10];
        int[] intWeights = new int[10];
        UniformIntegerDistribution weightDist = new UniformIntegerDistribution(1, 5);
        for (int i = 0; i < 10; ++i) {
            intWeights[i] = weightDist.sample();
            weights[i] = intWeights[i];
        }
        NormalDistribution valueDist = new NormalDistribution(0.0, 5.0);
        ArrayList<Double> valuesList = new ArrayList<Double>();
        for (int i = 0; i < 10; ++i) {
            double value;
            values[i] = value = valueDist.sample();
            for (int j = 0; j < intWeights[i]; ++j) {
                valuesList.add(new Double(value));
            }
        }
        int sumWeights = valuesList.size();
        double[] repeatedValues = new double[sumWeights];
        for (int i = 0; i < sumWeights; ++i) {
            repeatedValues[i] = (Double)valuesList.get(i);
        }
        WeightedEvaluation weightedStatistic = (WeightedEvaluation)statistic;
        TestUtils.assertRelativelyEquals(statistic.evaluate(repeatedValues), weightedStatistic.evaluate(values, weights, 0, values.length), 1.0E-11);
        Assert.assertEquals((double)weightedStatistic.evaluate(values, weights, 0, values.length), (double)weightedStatistic.evaluate(values, weights), (double)Double.MIN_VALUE);
    }
}

