/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.ml.neuralnet.sofm;

import org.apache.commons.math3.ml.distance.DistanceMeasure;
import org.apache.commons.math3.ml.distance.EuclideanDistance;
import org.apache.commons.math3.ml.neuralnet.FeatureInitializer;
import org.apache.commons.math3.ml.neuralnet.FeatureInitializerFactory;
import org.apache.commons.math3.ml.neuralnet.MapUtils;
import org.apache.commons.math3.ml.neuralnet.Network;
import org.apache.commons.math3.ml.neuralnet.Neuron;
import org.apache.commons.math3.ml.neuralnet.OffsetFeatureInitializer;
import org.apache.commons.math3.ml.neuralnet.oned.NeuronString;
import org.apache.commons.math3.ml.neuralnet.sofm.KohonenUpdateAction;
import org.apache.commons.math3.ml.neuralnet.sofm.LearningFactorFunction;
import org.apache.commons.math3.ml.neuralnet.sofm.LearningFactorFunctionFactory;
import org.apache.commons.math3.ml.neuralnet.sofm.NeighbourhoodSizeFunction;
import org.apache.commons.math3.ml.neuralnet.sofm.NeighbourhoodSizeFunctionFactory;
import org.apache.commons.math3.util.Precision;
import org.junit.Assert;
import org.junit.Test;

public class KohonenUpdateActionTest {
    @Test
    public void testUpdate() {
        OffsetFeatureInitializer init = new OffsetFeatureInitializer(FeatureInitializerFactory.uniform((double)0.0, (double)0.1));
        FeatureInitializer[] initArray = new FeatureInitializer[]{init};
        int netSize = 3;
        Network net = new NeuronString(3, false, initArray).getNetwork();
        EuclideanDistance dist = new EuclideanDistance();
        LearningFactorFunction learning = LearningFactorFunctionFactory.exponentialDecay((double)1.0, (double)0.1, (long)100L);
        NeighbourhoodSizeFunction neighbourhood = NeighbourhoodSizeFunctionFactory.exponentialDecay((double)3.0, (double)1.0, (long)100L);
        KohonenUpdateAction update = new KohonenUpdateAction((DistanceMeasure)dist, learning, neighbourhood);
        double[] features = new double[]{0.3};
        double[] distancesBefore = new double[3];
        int count = 0;
        for (Neuron n : net) {
            distancesBefore[count++] = dist.compute(n.getFeatures(), features);
        }
        Neuron bestBefore = MapUtils.findBest((double[])features, (Iterable)net, (DistanceMeasure)dist);
        Assert.assertTrue((dist.compute(bestBefore.getFeatures(), features) >= 0.2 ? 1 : 0) != 0);
        update.update(net, features);
        double[] distancesAfter = new double[3];
        count = 0;
        for (Neuron n : net) {
            distancesAfter[count++] = dist.compute(n.getFeatures(), features);
        }
        Neuron bestAfter = MapUtils.findBest((double[])features, (Iterable)net, (DistanceMeasure)dist);
        Assert.assertEquals((Object)bestBefore, (Object)bestAfter);
        Assert.assertEquals((double)0.0, (double)dist.compute(bestAfter.getFeatures(), features), (double)Precision.EPSILON);
        for (int i = 0; i < 3; ++i) {
            Assert.assertTrue((distancesAfter[i] < distancesBefore[i] ? 1 : 0) != 0);
        }
    }
}

