/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math4.legacy.fitting;

import java.util.Arrays;
import java.util.Collection;
import org.apache.commons.math4.legacy.analysis.MultivariateMatrixFunction;
import org.apache.commons.math4.legacy.analysis.MultivariateVectorFunction;
import org.apache.commons.math4.legacy.analysis.ParametricUnivariateFunction;
import org.apache.commons.math4.legacy.fitting.WeightedObservedPoint;
import org.apache.commons.math4.legacy.fitting.leastsquares.LeastSquaresOptimizer;
import org.apache.commons.math4.legacy.fitting.leastsquares.LeastSquaresProblem;
import org.apache.commons.math4.legacy.fitting.leastsquares.LevenbergMarquardtOptimizer;

public abstract class AbstractCurveFitter {
    public double[] fit(Collection<WeightedObservedPoint> points) {
        return this.getOptimizer().optimize(this.getProblem(points)).getPoint().toArray();
    }

    protected LeastSquaresOptimizer getOptimizer() {
        return new LevenbergMarquardtOptimizer();
    }

    protected abstract LeastSquaresProblem getProblem(Collection<WeightedObservedPoint> var1);

    protected static class TheoreticalValuesFunction {
        private final ParametricUnivariateFunction f;
        private final double[] points;

        public TheoreticalValuesFunction(ParametricUnivariateFunction f, Collection<WeightedObservedPoint> observations) {
            this.f = f;
            this.points = observations.stream().mapToDouble(WeightedObservedPoint::getX).toArray();
        }

        public MultivariateVectorFunction getModelFunction() {
            return new MultivariateVectorFunction(){

                @Override
                public double[] value(double[] p) {
                    return Arrays.stream(points).map(point -> f.value(point, p)).toArray();
                }
            };
        }

        public MultivariateMatrixFunction getModelFunctionJacobian() {
            return new MultivariateMatrixFunction(){

                @Override
                public double[][] value(double[] p) {
                    int len = points.length;
                    double[][] jacobian = new double[len][];
                    for (int i = 0; i < len; ++i) {
                        jacobian[i] = f.gradient(points[i], p);
                    }
                    return jacobian;
                }
            };
        }
    }
}

