/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math4.legacy.optim;

import org.apache.commons.math4.legacy.core.IntegerSequence;
import org.apache.commons.math4.legacy.exception.TooManyEvaluationsException;
import org.apache.commons.math4.legacy.exception.TooManyIterationsException;
import org.apache.commons.math4.legacy.optim.ConvergenceChecker;
import org.apache.commons.math4.legacy.optim.MaxEval;
import org.apache.commons.math4.legacy.optim.MaxIter;
import org.apache.commons.math4.legacy.optim.OptimizationData;

public abstract class BaseOptimizer<PAIR> {
    private static final MaxEvalCallback MAX_EVAL_CALLBACK = new MaxEvalCallback();
    private static final MaxIterCallback MAX_ITER_CALLBACK = new MaxIterCallback();
    private final ConvergenceChecker<PAIR> checker;
    private int maxEvaluations;
    private int maxIterations;
    private IntegerSequence.Incrementor evaluations;
    private IntegerSequence.Incrementor iterations;

    protected BaseOptimizer(ConvergenceChecker<PAIR> checker) {
        this(checker, 0, Integer.MAX_VALUE);
    }

    protected BaseOptimizer(ConvergenceChecker<PAIR> checker, int maxEval, int maxIter) {
        this.checker = checker;
        this.maxEvaluations = maxEval;
        this.maxIterations = maxIter;
    }

    public int getMaxEvaluations() {
        return this.evaluations.getMaximalCount();
    }

    public int getEvaluations() {
        return this.evaluations.getCount();
    }

    public int getMaxIterations() {
        return this.iterations.getMaximalCount();
    }

    public int getIterations() {
        return this.iterations.getCount();
    }

    public ConvergenceChecker<PAIR> getConvergenceChecker() {
        return this.checker;
    }

    public PAIR optimize(OptimizationData ... optData) {
        this.parseOptimizationData(optData);
        this.resetCounters();
        return this.doOptimize();
    }

    public PAIR optimize() {
        this.resetCounters();
        return this.doOptimize();
    }

    protected abstract PAIR doOptimize();

    protected void incrementEvaluationCount() {
        this.evaluations.increment();
    }

    protected void incrementIterationCount() {
        this.iterations.increment();
    }

    protected void parseOptimizationData(OptimizationData ... optData) {
        for (OptimizationData data : optData) {
            if (data instanceof MaxEval) {
                this.maxEvaluations = ((MaxEval)data).getMaxEval();
                continue;
            }
            if (!(data instanceof MaxIter)) continue;
            this.maxIterations = ((MaxIter)data).getMaxIter();
        }
    }

    private void resetCounters() {
        this.evaluations = IntegerSequence.Incrementor.create().withMaximalCount(this.maxEvaluations).withCallback((IntegerSequence.Incrementor.MaxCountExceededCallback)MAX_EVAL_CALLBACK);
        this.iterations = IntegerSequence.Incrementor.create().withMaximalCount(this.maxIterations).withCallback((IntegerSequence.Incrementor.MaxCountExceededCallback)MAX_ITER_CALLBACK);
    }

    private static class MaxIterCallback
    implements IntegerSequence.Incrementor.MaxCountExceededCallback {
        private MaxIterCallback() {
        }

        public void trigger(int max) {
            throw new TooManyIterationsException((Number)max);
        }
    }

    private static class MaxEvalCallback
    implements IntegerSequence.Incrementor.MaxCountExceededCallback {
        private MaxEvalCallback() {
        }

        public void trigger(int max) {
            throw new TooManyEvaluationsException((Number)max);
        }
    }
}

