/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math4.legacy.analysis.interpolation;

import org.apache.commons.math4.legacy.analysis.UnivariateFunction;
import org.apache.commons.math4.legacy.analysis.interpolation.UnivariateInterpolator;
import org.apache.commons.math4.legacy.core.MathArrays;
import org.apache.commons.math4.legacy.exception.MathIllegalArgumentException;
import org.apache.commons.math4.legacy.exception.NonMonotonicSequenceException;
import org.apache.commons.math4.legacy.exception.NumberIsTooSmallException;
import org.apache.commons.numbers.angle.Reduce;
import org.apache.commons.numbers.arrays.SortInPlace;

public class UnivariatePeriodicInterpolator
implements UnivariateInterpolator {
    public static final int DEFAULT_EXTEND = 5;
    private final UnivariateInterpolator interpolator;
    private final double period;
    private final int extend;

    public UnivariatePeriodicInterpolator(UnivariateInterpolator interpolator, double period, int extend) {
        this.interpolator = interpolator;
        this.period = period;
        this.extend = extend;
    }

    public UnivariatePeriodicInterpolator(UnivariateInterpolator interpolator, double period) {
        this(interpolator, period, 5);
    }

    @Override
    public UnivariateFunction interpolate(double[] xval, double[] yval) throws NumberIsTooSmallException, NonMonotonicSequenceException {
        int index;
        int i;
        if (xval.length < this.extend) {
            throw new NumberIsTooSmallException((Number)xval.length, (Number)this.extend, true);
        }
        MathArrays.checkOrder((double[])xval);
        double offset = xval[0];
        final Reduce reduce = new Reduce(offset, this.period);
        int len = xval.length + this.extend * 2;
        double[] x = new double[len];
        double[] y = new double[len];
        for (i = 0; i < xval.length; ++i) {
            index = i + this.extend;
            x[index] = reduce.applyAsDouble(xval[i]);
            y[index] = yval[i];
        }
        for (i = 0; i < this.extend; ++i) {
            index = xval.length - this.extend + i;
            x[i] = reduce.applyAsDouble(xval[index]) - this.period;
            y[i] = yval[index];
            index = len - this.extend + i;
            x[index] = reduce.applyAsDouble(xval[i]) + this.period;
            y[index] = yval[i];
        }
        SortInPlace.ASCENDING.apply(x, (double[][])new double[][]{y});
        final UnivariateFunction f = this.interpolator.interpolate(x, y);
        return new UnivariateFunction(){

            @Override
            public double value(double x) throws MathIllegalArgumentException {
                return f.value(reduce.applyAsDouble(x));
            }
        };
    }
}

