/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.statistics.distribution;

import org.apache.commons.rng.UniformRandomProvider;
import org.apache.commons.rng.sampling.distribution.DiscreteUniformSampler;
import org.apache.commons.rng.sampling.distribution.SharedStateDiscreteSampler;
import org.apache.commons.statistics.distribution.AbstractDiscreteDistribution;
import org.apache.commons.statistics.distribution.ArgumentUtils;
import org.apache.commons.statistics.distribution.DiscreteDistribution;
import org.apache.commons.statistics.distribution.DistributionException;

public final class UniformDiscreteDistribution
extends AbstractDiscreteDistribution {
    private final int lower;
    private final int upper;
    private final double upperMinusLowerPlus1;
    private final double pmf;
    private final double logPmf;
    private final double sf0;

    private UniformDiscreteDistribution(int lower, int upper) {
        this.lower = lower;
        this.upper = upper;
        this.upperMinusLowerPlus1 = (double)upper - (double)lower + 1.0;
        this.pmf = 1.0 / this.upperMinusLowerPlus1;
        this.logPmf = -Math.log(this.upperMinusLowerPlus1);
        this.sf0 = (this.upperMinusLowerPlus1 - 1.0) / this.upperMinusLowerPlus1;
    }

    public static UniformDiscreteDistribution of(int lower, int upper) {
        if (lower > upper) {
            throw new DistributionException("Lower bound %s > upper bound %s", lower, upper);
        }
        return new UniformDiscreteDistribution(lower, upper);
    }

    @Override
    public double probability(int x) {
        if (x < this.lower || x > this.upper) {
            return 0.0;
        }
        return this.pmf;
    }

    @Override
    public double probability(int x0, int x1) {
        if (x0 > x1) {
            throw new DistributionException("Lower bound %s > upper bound %s", x0, x1);
        }
        if (x0 >= this.upper || x1 < this.lower) {
            return 0.0;
        }
        long l = Math.max((long)this.lower - 1L, (long)x0);
        long u = Math.min(this.upper, x1);
        return (double)(u - l) / this.upperMinusLowerPlus1;
    }

    @Override
    public double logProbability(int x) {
        if (x < this.lower || x > this.upper) {
            return Double.NEGATIVE_INFINITY;
        }
        return this.logPmf;
    }

    @Override
    public double cumulativeProbability(int x) {
        if (x <= this.lower) {
            return x == this.lower ? this.pmf : 0.0;
        }
        if (x >= this.upper) {
            return 1.0;
        }
        return ((double)x - (double)this.lower + 1.0) / this.upperMinusLowerPlus1;
    }

    @Override
    public double survivalProbability(int x) {
        if (x <= this.lower) {
            return x == this.lower ? this.sf0 : 1.0;
        }
        if (x >= this.upper) {
            return 0.0;
        }
        return ((double)this.upper - (double)x) / this.upperMinusLowerPlus1;
    }

    @Override
    public int inverseCumulativeProbability(double p) {
        ArgumentUtils.checkProbability(p);
        if (p > this.sf0) {
            return this.upper;
        }
        if (p <= this.pmf) {
            return this.lower;
        }
        int x = (int)((double)this.lower + Math.ceil(p * this.upperMinusLowerPlus1) - 1.0);
        if (((double)x - (double)this.lower) / this.upperMinusLowerPlus1 >= p) {
            --x;
        } else if (((double)x - (double)this.lower + 1.0) / this.upperMinusLowerPlus1 < p) {
            ++x;
        }
        return x;
    }

    @Override
    public int inverseSurvivalProbability(double p) {
        ArgumentUtils.checkProbability(p);
        if (p < this.pmf) {
            return this.upper;
        }
        if (p >= this.sf0) {
            return this.lower;
        }
        int x = (int)((double)this.upper - Math.floor(p * this.upperMinusLowerPlus1));
        if (((double)this.upper - (double)x + 1.0) / this.upperMinusLowerPlus1 <= p) {
            --x;
        } else if (((double)this.upper - (double)x) / this.upperMinusLowerPlus1 > p) {
            ++x;
        }
        return x;
    }

    @Override
    public double getMean() {
        return 0.5 * ((double)this.upper + (double)this.lower);
    }

    @Override
    public double getVariance() {
        return (this.upperMinusLowerPlus1 * this.upperMinusLowerPlus1 - 1.0) / 12.0;
    }

    @Override
    public int getSupportLowerBound() {
        return this.lower;
    }

    @Override
    public int getSupportUpperBound() {
        return this.upper;
    }

    @Override
    public DiscreteDistribution.Sampler createSampler(UniformRandomProvider rng) {
        return () -> ((SharedStateDiscreteSampler)DiscreteUniformSampler.of((UniformRandomProvider)rng, (int)this.lower, (int)this.upper)).sample();
    }
}

