/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.provider.webdav4;

import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileSystemManager;
import org.apache.commons.vfs2.FileSystemOptions;
import org.apache.commons.vfs2.VFS;
import org.apache.commons.vfs2.provider.GenericURLFileName;
import org.apache.commons.vfs2.provider.webdav4.Webdav4FileObject;
import org.apache.commons.vfs2.provider.webdav4.Webdav4FileSystemConfigBuilder;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class Webdav4FileNameTest {
    @Test
    public void testWebdavUrlWithoutTrailingSlash() throws FileSystemException {
        GenericURLFileName fileName;
        FileSystemOptions fsoptsWithToutrailingSlashDefault = new FileSystemOptions();
        FileSystemOptions fsoptsWithoutTrailingSlash = new FileSystemOptions();
        Webdav4FileSystemConfigBuilder.getInstance().setAppendTrailingSlash(fsoptsWithoutTrailingSlash, false);
        FileSystemManager fileSystemManager = VFS.getManager();
        String urlBase = "webdav4://localhost:80";
        String urlWithFile1 = "webdav4://localhost:80/File.txt";
        String urlWithFile2 = "webdav4://localhost:80/Path/File.txt";
        String urlWithFileWithoutExtension1 = "webdav4://localhost:80/File";
        String urlWithFileWithoutExtension2 = "webdav4://localhost:80/Path/File";
        String urlWithSubpath = "webdav4://localhost:80/Path/Sub Path/";
        String urlWithRelativePart1 = "webdav4://localhost:80/Path/.";
        String urlWithRelativePart2 = "webdav4://localhost:80/Path/./";
        String urlWithRelativePart3 = "webdav4://localhost:80/Path/../Decendant Path/";
        String urlWithRelativePart4 = "webdav4://localhost:80/Path/Sub Path/..";
        String urlWithRelativePart5 = "webdav4://localhost:80/Path/Sub Path/../";
        String urlWithQuery1 = "webdav4://localhost:80/Path/Sub Path/?";
        String urlWithQuery2 = "webdav4://localhost:80/Path/Sub Path/?foo=bar";
        String urlWithQuery3 = "webdav4://localhost:80/Path/Sub Path/?foo=1&bar=2";
        String urlWithQuery4 = "webdav4://localhost:80/Path/Sub Path/?foo=1&bar=2";
        String urlWithQuery5 = "webdav4://localhost:80/Path/File?foo=1&bar=2";
        try (Webdav4FileObject file = (Webdav4FileObject)fileSystemManager.resolveFile("webdav4://localhost:80", fsoptsWithoutTrailingSlash);){
            fileName = (GenericURLFileName)file.getName();
            Assertions.assertEquals((Object)"http://localhost/", (Object)file.toUrlString(fileName));
        }
        file = (Webdav4FileObject)fileSystemManager.resolveFile("webdav4://localhost:80", fsoptsWithToutrailingSlashDefault);
        try {
            fileName = (GenericURLFileName)file.getName();
            Assertions.assertEquals((Object)"http://localhost/", (Object)file.toUrlString(fileName));
        }
        finally {
            if (file != null) {
                file.close();
            }
        }
        file = (Webdav4FileObject)fileSystemManager.resolveFile("webdav4://localhost:80/File.txt", fsoptsWithoutTrailingSlash);
        try {
            fileName = (GenericURLFileName)file.getName();
            Assertions.assertEquals((Object)"http://localhost/File.txt", (Object)file.toUrlString(fileName));
        }
        finally {
            if (file != null) {
                file.close();
            }
        }
        file = (Webdav4FileObject)fileSystemManager.resolveFile("webdav4://localhost:80/File.txt", fsoptsWithToutrailingSlashDefault);
        try {
            fileName = (GenericURLFileName)file.getName();
            Assertions.assertEquals((Object)"http://localhost/File.txt", (Object)file.toUrlString(fileName));
        }
        finally {
            if (file != null) {
                file.close();
            }
        }
        file = (Webdav4FileObject)fileSystemManager.resolveFile("webdav4://localhost:80/Path/File.txt", fsoptsWithoutTrailingSlash);
        try {
            fileName = (GenericURLFileName)file.getName();
            Assertions.assertEquals((Object)"http://localhost/Path/File.txt", (Object)file.toUrlString(fileName));
        }
        finally {
            if (file != null) {
                file.close();
            }
        }
        file = (Webdav4FileObject)fileSystemManager.resolveFile("webdav4://localhost:80/Path/File.txt", fsoptsWithToutrailingSlashDefault);
        try {
            fileName = (GenericURLFileName)file.getName();
            Assertions.assertEquals((Object)"http://localhost/Path/File.txt", (Object)file.toUrlString(fileName));
        }
        finally {
            if (file != null) {
                file.close();
            }
        }
        file = (Webdav4FileObject)fileSystemManager.resolveFile("webdav4://localhost:80/File", fsoptsWithoutTrailingSlash);
        try {
            fileName = (GenericURLFileName)file.getName();
            Assertions.assertEquals((Object)"http://localhost/File", (Object)file.toUrlString(fileName));
        }
        finally {
            if (file != null) {
                file.close();
            }
        }
        file = (Webdav4FileObject)fileSystemManager.resolveFile("webdav4://localhost:80/File", fsoptsWithToutrailingSlashDefault);
        try {
            fileName = (GenericURLFileName)file.getName();
            Assertions.assertEquals((Object)"http://localhost/File", (Object)file.toUrlString(fileName));
        }
        finally {
            if (file != null) {
                file.close();
            }
        }
        file = (Webdav4FileObject)fileSystemManager.resolveFile("webdav4://localhost:80/Path/File", fsoptsWithoutTrailingSlash);
        try {
            fileName = (GenericURLFileName)file.getName();
            Assertions.assertEquals((Object)"http://localhost/Path/File", (Object)file.toUrlString(fileName));
        }
        finally {
            if (file != null) {
                file.close();
            }
        }
        file = (Webdav4FileObject)fileSystemManager.resolveFile("webdav4://localhost:80/Path/File", fsoptsWithToutrailingSlashDefault);
        try {
            fileName = (GenericURLFileName)file.getName();
            Assertions.assertEquals((Object)"http://localhost/Path/File", (Object)file.toUrlString(fileName));
        }
        finally {
            if (file != null) {
                file.close();
            }
        }
        file = (Webdav4FileObject)fileSystemManager.resolveFile("webdav4://localhost:80/Path/Sub Path/", fsoptsWithoutTrailingSlash);
        try {
            fileName = (GenericURLFileName)file.getName();
            Assertions.assertEquals((Object)"http://localhost/Path/Sub%20Path", (Object)file.toUrlString(fileName));
        }
        finally {
            if (file != null) {
                file.close();
            }
        }
        file = (Webdav4FileObject)fileSystemManager.resolveFile("webdav4://localhost:80/Path/Sub Path/", fsoptsWithToutrailingSlashDefault);
        try {
            fileName = (GenericURLFileName)file.getName();
            Assertions.assertEquals((Object)"http://localhost/Path/Sub%20Path", (Object)file.toUrlString(fileName));
        }
        finally {
            if (file != null) {
                file.close();
            }
        }
        file = (Webdav4FileObject)fileSystemManager.resolveFile("webdav4://localhost:80/Path/.", fsoptsWithoutTrailingSlash);
        try {
            fileName = (GenericURLFileName)file.getName();
            Assertions.assertEquals((Object)"http://localhost/Path", (Object)file.toUrlString(fileName));
        }
        finally {
            if (file != null) {
                file.close();
            }
        }
        file = (Webdav4FileObject)fileSystemManager.resolveFile("webdav4://localhost:80/Path/.", fsoptsWithToutrailingSlashDefault);
        try {
            fileName = (GenericURLFileName)file.getName();
            Assertions.assertEquals((Object)"http://localhost/Path", (Object)file.toUrlString(fileName));
        }
        finally {
            if (file != null) {
                file.close();
            }
        }
        file = (Webdav4FileObject)fileSystemManager.resolveFile("webdav4://localhost:80/Path/./", fsoptsWithoutTrailingSlash);
        try {
            fileName = (GenericURLFileName)file.getName();
            Assertions.assertEquals((Object)"http://localhost/Path", (Object)file.toUrlString(fileName));
        }
        finally {
            if (file != null) {
                file.close();
            }
        }
        file = (Webdav4FileObject)fileSystemManager.resolveFile("webdav4://localhost:80/Path/./", fsoptsWithToutrailingSlashDefault);
        try {
            fileName = (GenericURLFileName)file.getName();
            Assertions.assertEquals((Object)"http://localhost/Path", (Object)file.toUrlString(fileName));
        }
        finally {
            if (file != null) {
                file.close();
            }
        }
        file = (Webdav4FileObject)fileSystemManager.resolveFile("webdav4://localhost:80/Path/../Decendant Path/", fsoptsWithoutTrailingSlash);
        try {
            fileName = (GenericURLFileName)file.getName();
            Assertions.assertEquals((Object)"http://localhost/Decendant%20Path", (Object)file.toUrlString(fileName));
        }
        finally {
            if (file != null) {
                file.close();
            }
        }
        file = (Webdav4FileObject)fileSystemManager.resolveFile("webdav4://localhost:80/Path/../Decendant Path/", fsoptsWithToutrailingSlashDefault);
        try {
            fileName = (GenericURLFileName)file.getName();
            Assertions.assertEquals((Object)"http://localhost/Decendant%20Path", (Object)file.toUrlString(fileName));
        }
        finally {
            if (file != null) {
                file.close();
            }
        }
        file = (Webdav4FileObject)fileSystemManager.resolveFile("webdav4://localhost:80/Path/Sub Path/..", fsoptsWithoutTrailingSlash);
        try {
            fileName = (GenericURLFileName)file.getName();
            Assertions.assertEquals((Object)"http://localhost/Path", (Object)file.toUrlString(fileName));
        }
        finally {
            if (file != null) {
                file.close();
            }
        }
        file = (Webdav4FileObject)fileSystemManager.resolveFile("webdav4://localhost:80/Path/Sub Path/..", fsoptsWithToutrailingSlashDefault);
        try {
            fileName = (GenericURLFileName)file.getName();
            Assertions.assertEquals((Object)"http://localhost/Path", (Object)file.toUrlString(fileName));
        }
        finally {
            if (file != null) {
                file.close();
            }
        }
        file = (Webdav4FileObject)fileSystemManager.resolveFile("webdav4://localhost:80/Path/Sub Path/../", fsoptsWithoutTrailingSlash);
        try {
            fileName = (GenericURLFileName)file.getName();
            Assertions.assertEquals((Object)"http://localhost/Path", (Object)file.toUrlString(fileName));
        }
        finally {
            if (file != null) {
                file.close();
            }
        }
        file = (Webdav4FileObject)fileSystemManager.resolveFile("webdav4://localhost:80/Path/Sub Path/../", fsoptsWithToutrailingSlashDefault);
        try {
            fileName = (GenericURLFileName)file.getName();
            Assertions.assertEquals((Object)"http://localhost/Path", (Object)file.toUrlString(fileName));
        }
        finally {
            if (file != null) {
                file.close();
            }
        }
        file = (Webdav4FileObject)fileSystemManager.resolveFile("webdav4://localhost:80/Path/Sub Path/?", fsoptsWithoutTrailingSlash);
        try {
            fileName = (GenericURLFileName)file.getName();
            Assertions.assertEquals((Object)"http://localhost/Path/Sub%20Path", (Object)file.toUrlString(fileName));
        }
        finally {
            if (file != null) {
                file.close();
            }
        }
        file = (Webdav4FileObject)fileSystemManager.resolveFile("webdav4://localhost:80/Path/Sub Path/?", fsoptsWithToutrailingSlashDefault);
        try {
            fileName = (GenericURLFileName)file.getName();
            Assertions.assertEquals((Object)"http://localhost/Path/Sub%20Path", (Object)file.toUrlString(fileName));
        }
        finally {
            if (file != null) {
                file.close();
            }
        }
        file = (Webdav4FileObject)fileSystemManager.resolveFile("webdav4://localhost:80/Path/Sub Path/?foo=bar", fsoptsWithoutTrailingSlash);
        try {
            fileName = (GenericURLFileName)file.getName();
            Assertions.assertEquals((Object)"http://localhost/Path/Sub%20Path?foo=bar", (Object)file.toUrlString(fileName));
        }
        finally {
            if (file != null) {
                file.close();
            }
        }
        file = (Webdav4FileObject)fileSystemManager.resolveFile("webdav4://localhost:80/Path/Sub Path/?foo=bar", fsoptsWithToutrailingSlashDefault);
        try {
            fileName = (GenericURLFileName)file.getName();
            Assertions.assertEquals((Object)"http://localhost/Path/Sub%20Path?foo=bar", (Object)file.toUrlString(fileName));
        }
        finally {
            if (file != null) {
                file.close();
            }
        }
        file = (Webdav4FileObject)fileSystemManager.resolveFile("webdav4://localhost:80/Path/Sub Path/?foo=1&bar=2", fsoptsWithoutTrailingSlash);
        try {
            fileName = (GenericURLFileName)file.getName();
            Assertions.assertEquals((Object)"http://localhost/Path/Sub%20Path?foo=1&bar=2", (Object)file.toUrlString(fileName));
        }
        finally {
            if (file != null) {
                file.close();
            }
        }
        file = (Webdav4FileObject)fileSystemManager.resolveFile("webdav4://localhost:80/Path/Sub Path/?foo=1&bar=2", fsoptsWithToutrailingSlashDefault);
        try {
            fileName = (GenericURLFileName)file.getName();
            Assertions.assertEquals((Object)"http://localhost/Path/Sub%20Path?foo=1&bar=2", (Object)file.toUrlString(fileName));
        }
        finally {
            if (file != null) {
                file.close();
            }
        }
        file = (Webdav4FileObject)fileSystemManager.resolveFile("webdav4://localhost:80/Path/Sub Path/?foo=1&bar=2", fsoptsWithoutTrailingSlash);
        try {
            fileName = (GenericURLFileName)file.getName();
            Assertions.assertEquals((Object)"http://localhost/Path/Sub%20Path?foo=1&bar=2", (Object)file.toUrlString(fileName));
        }
        finally {
            if (file != null) {
                file.close();
            }
        }
        file = (Webdav4FileObject)fileSystemManager.resolveFile("webdav4://localhost:80/Path/Sub Path/?foo=1&bar=2", fsoptsWithToutrailingSlashDefault);
        try {
            fileName = (GenericURLFileName)file.getName();
            Assertions.assertEquals((Object)"http://localhost/Path/Sub%20Path?foo=1&bar=2", (Object)file.toUrlString(fileName));
        }
        finally {
            if (file != null) {
                file.close();
            }
        }
        file = (Webdav4FileObject)fileSystemManager.resolveFile("webdav4://localhost:80/Path/File?foo=1&bar=2", fsoptsWithoutTrailingSlash);
        try {
            fileName = (GenericURLFileName)file.getName();
            Assertions.assertEquals((Object)"http://localhost/Path/File?foo=1&bar=2", (Object)file.toUrlString(fileName));
        }
        finally {
            if (file != null) {
                file.close();
            }
        }
        file = (Webdav4FileObject)fileSystemManager.resolveFile("webdav4://localhost:80/Path/File?foo=1&bar=2", fsoptsWithToutrailingSlashDefault);
        try {
            fileName = (GenericURLFileName)file.getName();
            Assertions.assertEquals((Object)"http://localhost/Path/File?foo=1&bar=2", (Object)file.toUrlString(fileName));
        }
        finally {
            if (file != null) {
                file.close();
            }
        }
    }

    @Test
    public void testWebdavUrlWithTrailingSlash() throws FileSystemException {
        GenericURLFileName fileName;
        FileSystemOptions fsoptsWithTrailingSlash = new FileSystemOptions();
        Webdav4FileSystemConfigBuilder.getInstance().setAppendTrailingSlash(fsoptsWithTrailingSlash, true);
        FileSystemManager fileSystemManager = VFS.getManager();
        String urlBase = "webdav4://localhost:80";
        String urlWithFile1 = "webdav4://localhost:80/File.txt";
        String urlWithFile2 = "webdav4://localhost:80/Path/File.txt";
        String urlWithFileWithoutExtension1 = "webdav4://localhost:80/File";
        String urlWithFileWithoutExtension2 = "webdav4://localhost:80/Path/File";
        String urlWithSubpath = "webdav4://localhost:80/Path/Sub Path/";
        String urlWithRelativePart1 = "webdav4://localhost:80/Path/.";
        String urlWithRelativePart2 = "webdav4://localhost:80/Path/./";
        String urlWithRelativePart3 = "webdav4://localhost:80/Path/../Decendant Path/";
        String urlWithRelativePart4 = "webdav4://localhost:80/Path/Sub Path/..";
        String urlWithRelativePart5 = "webdav4://localhost:80/Path/Sub Path/../";
        String urlWithQuery1 = "webdav4://localhost:80/Path/Sub Path/?";
        String urlWithQuery2 = "webdav4://localhost:80/Path/Sub Path/?foo=bar";
        String urlWithQuery3 = "webdav4://localhost:80/Path/Sub Path/?foo=1&bar=2";
        String urlWithQuery4 = "webdav4://localhost:80/Path/Sub Path/?foo=1&bar=2";
        String urlWithQuery5 = "webdav4://localhost:80/Path/File?foo=1&bar=2";
        try (Webdav4FileObject file = (Webdav4FileObject)fileSystemManager.resolveFile("webdav4://localhost:80", fsoptsWithTrailingSlash);){
            fileName = (GenericURLFileName)file.getName();
            Assertions.assertEquals((Object)"http://localhost/", (Object)file.toUrlString(fileName));
        }
        file = (Webdav4FileObject)fileSystemManager.resolveFile("webdav4://localhost:80/File.txt", fsoptsWithTrailingSlash);
        try {
            fileName = (GenericURLFileName)file.getName();
            Assertions.assertEquals((Object)"http://localhost/File.txt", (Object)file.toUrlString(fileName));
        }
        finally {
            if (file != null) {
                file.close();
            }
        }
        file = (Webdav4FileObject)fileSystemManager.resolveFile("webdav4://localhost:80/Path/File.txt", fsoptsWithTrailingSlash);
        try {
            fileName = (GenericURLFileName)file.getName();
            Assertions.assertEquals((Object)"http://localhost/Path/File.txt", (Object)file.toUrlString(fileName));
        }
        finally {
            if (file != null) {
                file.close();
            }
        }
        file = (Webdav4FileObject)fileSystemManager.resolveFile("webdav4://localhost:80/File", fsoptsWithTrailingSlash);
        try {
            fileName = (GenericURLFileName)file.getName();
            Assertions.assertEquals((Object)"http://localhost/File", (Object)file.toUrlString(fileName));
        }
        finally {
            if (file != null) {
                file.close();
            }
        }
        file = (Webdav4FileObject)fileSystemManager.resolveFile("webdav4://localhost:80/Path/File", fsoptsWithTrailingSlash);
        try {
            fileName = (GenericURLFileName)file.getName();
            Assertions.assertEquals((Object)"http://localhost/Path/File", (Object)file.toUrlString(fileName));
        }
        finally {
            if (file != null) {
                file.close();
            }
        }
        file = (Webdav4FileObject)fileSystemManager.resolveFile("webdav4://localhost:80/Path/Sub Path/", fsoptsWithTrailingSlash);
        try {
            fileName = (GenericURLFileName)file.getName();
            Assertions.assertEquals((Object)"http://localhost/Path/Sub%20Path/", (Object)file.toUrlString(fileName));
        }
        finally {
            if (file != null) {
                file.close();
            }
        }
        file = (Webdav4FileObject)fileSystemManager.resolveFile("webdav4://localhost:80/Path/.", fsoptsWithTrailingSlash);
        try {
            fileName = (GenericURLFileName)file.getName();
            Assertions.assertEquals((Object)"http://localhost/Path/", (Object)file.toUrlString(fileName));
        }
        finally {
            if (file != null) {
                file.close();
            }
        }
        file = (Webdav4FileObject)fileSystemManager.resolveFile("webdav4://localhost:80/Path/./", fsoptsWithTrailingSlash);
        try {
            fileName = (GenericURLFileName)file.getName();
            Assertions.assertEquals((Object)"http://localhost/Path/", (Object)file.toUrlString(fileName));
        }
        finally {
            if (file != null) {
                file.close();
            }
        }
        file = (Webdav4FileObject)fileSystemManager.resolveFile("webdav4://localhost:80/Path/../Decendant Path/", fsoptsWithTrailingSlash);
        try {
            fileName = (GenericURLFileName)file.getName();
            Assertions.assertEquals((Object)"http://localhost/Decendant%20Path/", (Object)file.toUrlString(fileName));
        }
        finally {
            if (file != null) {
                file.close();
            }
        }
        file = (Webdav4FileObject)fileSystemManager.resolveFile("webdav4://localhost:80/Path/Sub Path/..", fsoptsWithTrailingSlash);
        try {
            fileName = (GenericURLFileName)file.getName();
            Assertions.assertEquals((Object)"http://localhost/Path/", (Object)file.toUrlString(fileName));
        }
        finally {
            if (file != null) {
                file.close();
            }
        }
        file = (Webdav4FileObject)fileSystemManager.resolveFile("webdav4://localhost:80/Path/Sub Path/../", fsoptsWithTrailingSlash);
        try {
            fileName = (GenericURLFileName)file.getName();
            Assertions.assertEquals((Object)"http://localhost/Path/", (Object)file.toUrlString(fileName));
        }
        finally {
            if (file != null) {
                file.close();
            }
        }
        file = (Webdav4FileObject)fileSystemManager.resolveFile("webdav4://localhost:80/Path/Sub Path/?", fsoptsWithTrailingSlash);
        try {
            fileName = (GenericURLFileName)file.getName();
            Assertions.assertEquals((Object)"http://localhost/Path/Sub%20Path/", (Object)file.toUrlString(fileName));
        }
        finally {
            if (file != null) {
                file.close();
            }
        }
        file = (Webdav4FileObject)fileSystemManager.resolveFile("webdav4://localhost:80/Path/Sub Path/?foo=bar", fsoptsWithTrailingSlash);
        try {
            fileName = (GenericURLFileName)file.getName();
            Assertions.assertEquals((Object)"http://localhost/Path/Sub%20Path/?foo=bar", (Object)file.toUrlString(fileName));
        }
        finally {
            if (file != null) {
                file.close();
            }
        }
        file = (Webdav4FileObject)fileSystemManager.resolveFile("webdav4://localhost:80/Path/Sub Path/?foo=1&bar=2", fsoptsWithTrailingSlash);
        try {
            fileName = (GenericURLFileName)file.getName();
            Assertions.assertEquals((Object)"http://localhost/Path/Sub%20Path/?foo=1&bar=2", (Object)file.toUrlString(fileName));
        }
        finally {
            if (file != null) {
                file.close();
            }
        }
        file = (Webdav4FileObject)fileSystemManager.resolveFile("webdav4://localhost:80/Path/Sub Path/?foo=1&bar=2", fsoptsWithTrailingSlash);
        try {
            fileName = (GenericURLFileName)file.getName();
            Assertions.assertEquals((Object)"http://localhost/Path/Sub%20Path/?foo=1&bar=2", (Object)file.toUrlString(fileName));
        }
        finally {
            if (file != null) {
                file.close();
            }
        }
        file = (Webdav4FileObject)fileSystemManager.resolveFile("webdav4://localhost:80/Path/File?foo=1&bar=2", fsoptsWithTrailingSlash);
        try {
            fileName = (GenericURLFileName)file.getName();
            Assertions.assertEquals((Object)"http://localhost/Path/File?foo=1&bar=2", (Object)file.toUrlString(fileName));
        }
        finally {
            if (file != null) {
                file.close();
            }
        }
    }
}

