/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2;

import java.io.File;
import org.apache.commons.vfs2.FileSystem;
import org.apache.commons.vfs2.FileSystemConfigBuilder;
import org.apache.commons.vfs2.FileSystemOptions;
import org.apache.commons.vfs2.provider.sftp.IdentityInfo;
import org.apache.commons.vfs2.provider.sftp.IdentityProvider;
import org.apache.commons.vfs2.provider.sftp.SftpFileSystemConfigBuilder;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class FileSystemOptionsTest {
    private static void assertSftpOptionsEquals(File privKey, File pubKey, byte[] passphrase) {
        SftpFileSystemConfigBuilder builder = SftpFileSystemConfigBuilder.getInstance();
        FileSystemOptions expected = new FileSystemOptions();
        IdentityInfo info1 = new IdentityInfo(privKey, pubKey, passphrase);
        builder.setIdentityProvider(expected, new IdentityProvider[]{info1});
        FileSystemOptions actual = new FileSystemOptions();
        IdentityInfo info2 = new IdentityInfo(privKey, pubKey, passphrase);
        builder.setIdentityProvider(actual, new IdentityProvider[]{info2});
        Assertions.assertEquals((int)0, (int)expected.compareTo(actual));
        Assertions.assertEquals((int)expected.hashCode(), (int)actual.hashCode());
    }

    private static void assertSftpOptionsNotEquals(File privKey1, File pubKey1, byte[] passphrase1, File privKey2, File pubKey2, byte[] passphrase2) {
        SftpFileSystemConfigBuilder builder = SftpFileSystemConfigBuilder.getInstance();
        FileSystemOptions expected = new FileSystemOptions();
        IdentityInfo info1 = new IdentityInfo(privKey1, pubKey1, passphrase1);
        builder.setIdentityProvider(expected, new IdentityProvider[]{info1});
        FileSystemOptions actual = new FileSystemOptions();
        IdentityInfo info2 = new IdentityInfo(privKey2, pubKey2, passphrase2);
        builder.setIdentityProvider(actual, new IdentityProvider[]{info2});
        Assertions.assertNotEquals((int)0, (int)expected.compareTo(actual));
        Assertions.assertNotEquals((int)expected.hashCode(), (int)actual.hashCode());
    }

    @Test
    public void testClone() {
        FileSystemOptions fileSystemOptions = new FileSystemOptions();
        Assertions.assertEquals(fileSystemOptions.getClass(), fileSystemOptions.clone().getClass());
        Assertions.assertEquals((int)0, (int)((FileSystemOptions)fileSystemOptions.clone()).size());
        fileSystemOptions.setOption(FileSystem.class, "key1", (Object)"value1");
        Assertions.assertEquals((int)1, (int)((FileSystemOptions)fileSystemOptions.clone()).size());
        FileSystemOptions clone = (FileSystemOptions)fileSystemOptions.clone();
        Assertions.assertEquals((Object)"value1", (Object)clone.getOption(FileSystem.class, "key1"));
        fileSystemOptions.setOption(FileSystem.class, "key2", (Object)"value2");
        Assertions.assertNull((Object)clone.getOption(FileSystem.class, "key2"));
    }

    @Test
    public void testEqualsHashCodeAndCompareTo() {
        JUnitConfigBuilder builder = JUnitConfigBuilder.getInstance();
        FileSystemOptions expected = new FileSystemOptions();
        builder.setId(expected, "Test");
        FileSystemOptions actual = new FileSystemOptions();
        builder.setId(actual, "Test");
        Assertions.assertEquals((Object)expected, (Object)actual);
        Assertions.assertEquals((int)0, (int)actual.compareTo(expected));
        Assertions.assertEquals((int)expected.hashCode(), (int)actual.hashCode());
        builder.setNames(expected, new String[]{"A", "B", "C"});
        Assertions.assertNotEquals((Object)expected, (Object)actual);
        Assertions.assertEquals((int)-1, (int)actual.compareTo(expected));
        Assertions.assertNotEquals((int)expected.hashCode(), (int)actual.hashCode());
        builder.setNames(actual, new String[]{"A", "B", "C"});
        Assertions.assertEquals((Object)expected, (Object)actual);
        Assertions.assertEquals((int)0, (int)actual.compareTo(expected));
        Assertions.assertEquals((int)expected.hashCode(), (int)actual.hashCode());
    }

    @Test
    public void testEqualsHashCodeAndCompareToWithSftpIdentityProviderMatch() {
        for (int mask = 0; mask < 8; ++mask) {
            byte[] byArray;
            File file = (mask & 1) == 1 ? new File("/tmp/test.priv") : null;
            File file2 = (mask & 2) == 2 ? new File("/tmp/test.pub") : null;
            if ((mask & 4) == 4) {
                byte[] byArray2 = new byte[3];
                byArray2[0] = 1;
                byArray2[1] = 2;
                byArray = byArray2;
                byArray2[2] = 3;
            } else {
                byArray = null;
            }
            FileSystemOptionsTest.assertSftpOptionsEquals(file, file2, byArray);
        }
    }

    @Test
    public void testEqualsHashCodeAndCompareToWithSftpIdentityProviderMismatch() {
        String pubKey1 = "/tmp/test.pub";
        String pubKey2 = "/tmp/test1.pub";
        String privKey1 = "/tmp/test.priv";
        String privKey2 = "/tmp/test1.priv";
        FileSystemOptionsTest.assertSftpOptionsNotEquals(new File("/tmp/test.priv"), new File("/tmp/test.pub"), new byte[]{1, 2, 3}, new File("/tmp/test1.priv"), new File("/tmp/test.pub"), new byte[]{1, 2, 3});
        FileSystemOptionsTest.assertSftpOptionsNotEquals(new File("/tmp/test.priv"), new File("/tmp/test.pub"), new byte[]{1, 2, 3}, new File("/tmp/test.priv"), new File("/tmp/test1.pub"), new byte[]{1, 2, 3});
        FileSystemOptionsTest.assertSftpOptionsNotEquals(new File("/tmp/test.priv"), new File("/tmp/test.pub"), new byte[]{1, 2, 3}, new File("/tmp/test.priv"), new File("/tmp/test.pub"), new byte[]{1, 2, 4});
    }

    public static class JUnitConfigBuilder
    extends FileSystemConfigBuilder {
        private static final JUnitConfigBuilder BUILDER = new JUnitConfigBuilder();

        public static JUnitConfigBuilder getInstance() {
            return BUILDER;
        }

        protected Class<? extends FileSystem> getConfigClass() {
            return JUnitFS.class;
        }

        public void setId(FileSystemOptions opts, String id) {
            this.setParam(opts, "id", id);
        }

        public void setNames(FileSystemOptions opts, String[] names) {
            this.setParam(opts, "names", names);
        }

        private static abstract class JUnitFS
        implements FileSystem {
            private JUnitFS() {
            }
        }
    }
}

