/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2;

import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.vfs2.AbstractProviderTestCase;
import org.apache.commons.vfs2.Capability;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystem;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileSystemOptions;
import org.junit.Test;

public class IPv6LocalConnectionTests
extends AbstractProviderTestCase {
    private static final String LOOPBACK = "0:0:0:0:0:0:0:1";
    private static final Log log = LogFactory.getLog(IPv6LocalConnectionTests.class);

    private static List<String> getLocalIPv6Addresses() throws SocketException {
        Enumeration<NetworkInterface> networkInterfaces = NetworkInterface.getNetworkInterfaces();
        ArrayList<String> result = new ArrayList<String>();
        for (NetworkInterface networkInterface : Collections.list(networkInterfaces)) {
            if (!networkInterface.isUp() || networkInterface.isLoopback() || networkInterface.getName().startsWith("utun")) continue;
            for (InetAddress inetAddress : Collections.list(networkInterface.getInetAddresses())) {
                if (!(inetAddress instanceof Inet6Address) || inetAddress.isLoopbackAddress() || inetAddress.isMulticastAddress()) continue;
                result.add(StringUtils.substringBefore((String)inetAddress.getHostAddress(), (String)"%"));
            }
        }
        if (!result.contains(LOOPBACK)) {
            result.add(LOOPBACK);
        }
        return result;
    }

    @Override
    protected Capability[] getRequiredCapabilities() {
        return new Capability[]{Capability.URI, Capability.READ_CONTENT};
    }

    @Override
    protected void runTest() throws Throwable {
        List<String> localIPv6Addresses = IPv6LocalConnectionTests.getLocalIPv6Addresses();
        if (localIPv6Addresses.isEmpty()) {
            log.info((Object)"Local machine must have IPv6 address to run this test");
            return;
        }
        super.runTest();
    }

    private FileSystemOptions setupConnectionTimeoutHints(FileSystem fileSystem) {
        FileSystemOptions result = (FileSystemOptions)fileSystem.getFileSystemOptions().clone();
        Duration timeout = Duration.ofSeconds(5L);
        result.setOption(fileSystem.getClass(), "org.apache.commons.vfs2.provider.sftp.SftpFileSystemConfigBuilder.CONNECT_TIMEOUT", (Object)timeout);
        result.setOption(fileSystem.getClass(), "org.apache.commons.vfs2.provider.sftp.SftpFileSystemConfigBuilder.TIMEOUT", (Object)timeout);
        result.setOption(fileSystem.getClass(), "http.connection.timeout", (Object)timeout);
        result.setOption(fileSystem.getClass(), "http.socket.timeout", (Object)timeout);
        result.setOption(fileSystem.getClass(), "org.apache.commons.vfs2.provider.ftp.FtpFileSystemConfigBuilder.CONNECT_TIMEOUT", (Object)timeout);
        result.setOption(fileSystem.getClass(), "org.apache.commons.vfs2.provider.ftp.FtpFileSystemConfigBuilder.SO_TIMEOUT", (Object)timeout);
        return result;
    }

    @Test
    public void testConnectIPv6UrlLocal() throws Exception {
        List<String> localIPv6Addresses = IPv6LocalConnectionTests.getLocalIPv6Addresses();
        boolean connected = false;
        for (String ipv6Address : localIPv6Addresses) {
            String ipv6Url = StringUtils.replace((String)this.getReadFolder().getURL().toString(), (String)"localhost", (String)("[" + ipv6Address + "]"));
            try {
                FileSystem fileSystem = this.getFileSystem();
                FileObject readFolderObject = this.getManager().resolveFile(ipv6Url, this.setupConnectionTimeoutHints(fileSystem));
                connected = connected || readFolderObject.resolveFile("file1.txt").getContent().getByteArray() != null;
            }
            catch (FileSystemException e) {
                log.warn((Object)"Failed to connect to some of the local IPv6 network addresses", (Throwable)e);
            }
        }
        IPv6LocalConnectionTests.assertTrue((String)("None of the discovered local IPv6 network addresses has responded for connection: " + localIPv6Addresses), (boolean)connected);
    }
}

