/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.provider.local;

import java.io.File;
import org.apache.commons.vfs2.AbstractProviderTestCase;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.impl.DefaultFileSystemManager;
import org.junit.Test;
import org.junit.jupiter.api.Assertions;

public class FileNameTests
extends AbstractProviderTestCase {
    @Test
    public void testAbsoluteFileName() throws Exception {
        String fileName = new File("testdir").getAbsolutePath();
        DefaultFileSystemManager manager = this.getManager();
        Assertions.assertNotNull((Object)manager, (String)("Unexpected null manager for test " + (Object)((Object)this)));
        try (FileObject absFile = manager.resolveFile(fileName);){
            String uri = "file://" + fileName.replace(File.separatorChar, '/');
            FileObject uriFile = manager.resolveFile(uri);
            FileNameTests.assertSame((String)"file object", (Object)absFile, (Object)uriFile);
        }
    }
}

