/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.aegis.type.encoded;

import javax.xml.namespace.QName;
import org.apache.cxf.aegis.Context;
import org.apache.cxf.aegis.DatabindingException;
import org.apache.cxf.aegis.type.AegisType;
import org.apache.cxf.aegis.type.basic.BeanType;
import org.apache.cxf.aegis.type.basic.BeanTypeInfo;
import org.apache.cxf.aegis.type.encoded.MarshalRegistry;
import org.apache.cxf.aegis.type.encoded.SoapArrayType;
import org.apache.cxf.aegis.type.encoded.SoapEncodingUtil;
import org.apache.cxf.aegis.type.encoded.SoapRef;
import org.apache.cxf.aegis.type.encoded.SoapRefType;
import org.apache.cxf.aegis.xml.MessageReader;
import org.apache.cxf.aegis.xml.MessageWriter;

public class StructType
extends BeanType {
    public StructType() {
    }

    public StructType(BeanTypeInfo info) {
        super(info);
    }

    @Override
    protected boolean alwaysAllowNillables() {
        return true;
    }

    @Override
    protected BeanTypeInfo getBeanTypeInfoWithProperty(QName name) {
        name = this.qualifyName(name);
        return super.getBeanTypeInfoWithProperty(name);
    }

    @Override
    protected AegisType getElementType(QName name, BeanTypeInfo beanTypeInfo, MessageReader reader, Context context) {
        AegisType type = super.getElementType(name = this.qualifyName(name), beanTypeInfo, reader, context);
        if (type != null) {
            type = new SoapRefType(type);
        }
        return type;
    }

    @Override
    protected void writeProperty(QName name, Object object, Object property, Class<?> impl, BeanTypeInfo inf) throws DatabindingException {
        name = this.qualifyName(name);
        if (property instanceof SoapRef) {
            SoapRef soapRef = (SoapRef)property;
            soapRef.setAction(new WritePropertyAction(name, object, impl, inf));
        } else {
            super.writeProperty(name, object, property, impl, inf);
        }
    }

    @Override
    protected void writeElement(QName name, Object value, AegisType type, MessageWriter writer, Context context) {
        name = new QName("", name.getLocalPart());
        MessageWriter cwriter = writer.getElementWriter(name);
        if (type instanceof BeanType || type instanceof SoapArrayType) {
            String refId = MarshalRegistry.get(context).getInstanceId(value);
            SoapEncodingUtil.writeRef(cwriter, refId);
        } else {
            type.writeObject(value, cwriter, context);
        }
        cwriter.close();
    }

    private QName qualifyName(QName name) {
        if (!"".equals(name.getNamespaceURI())) {
            return name;
        }
        BeanType sooper = this;
        while (sooper != null) {
            QName qualifiedName = new QName(sooper.getTypeInfo().getDefaultNamespace(), name.getLocalPart());
            if (sooper.getTypeInfo().getType(qualifiedName) != null) {
                return qualifiedName;
            }
            sooper = this.superBeanType(sooper);
        }
        return name;
    }

    private BeanType superBeanType(AegisType t) {
        BeanType bt;
        AegisType supertype;
        if (t instanceof BeanType && (supertype = (bt = (BeanType)t).getSuperType()) instanceof BeanType) {
            return (BeanType)supertype;
        }
        return null;
    }

    private final class WritePropertyAction
    implements SoapRef.Action {
        private final QName name;
        private final Object targetObject;
        private final Class<?> targetClass;
        private final BeanTypeInfo beanTypeInfo;

        private WritePropertyAction(QName name, Object targetObject, Class<?> targetClass, BeanTypeInfo beanTypeInfo) {
            this.name = name;
            this.targetObject = targetObject;
            this.targetClass = targetClass;
            this.beanTypeInfo = beanTypeInfo;
        }

        @Override
        public void onSet(SoapRef ref) {
            StructType.this.writeProperty(this.name, this.targetObject, ref.get(), this.targetClass, this.beanTypeInfo);
        }
    }
}

