/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.impl.internal.store.offheap.portability;

import java.nio.ByteBuffer;
import org.ehcache.impl.internal.store.BinaryValueHolder;
import org.ehcache.impl.internal.store.offheap.LazyOffHeapValueHolder;
import org.ehcache.impl.internal.store.offheap.OffHeapValueHolder;
import org.ehcache.shadow.org.terracotta.offheapstore.storage.portability.WriteBackPortability;
import org.ehcache.shadow.org.terracotta.offheapstore.storage.portability.WriteContext;
import org.ehcache.spi.serialization.Serializer;

public class OffHeapValueHolderPortability<V>
implements WriteBackPortability<OffHeapValueHolder<V>> {
    public static final int ACCESS_TIME_OFFSET = 16;
    public static final int EXPIRE_TIME_OFFSET = 24;
    private static final int FIELDS_OVERHEAD = 40;
    private final Serializer<V> serializer;

    public OffHeapValueHolderPortability(Serializer<V> serializer) {
        this.serializer = serializer;
    }

    @Override
    public ByteBuffer encode(OffHeapValueHolder<V> valueHolder) {
        ByteBuffer serialized = valueHolder instanceof BinaryValueHolder && ((BinaryValueHolder)((Object)valueHolder)).isBinaryValueAvailable() ? ((BinaryValueHolder)((Object)valueHolder)).getBinaryValue() : this.serializer.serialize(valueHolder.get());
        ByteBuffer byteBuffer = ByteBuffer.allocate(serialized.remaining() + 40);
        byteBuffer.putLong(valueHolder.getId());
        byteBuffer.putLong(valueHolder.creationTime());
        byteBuffer.putLong(valueHolder.lastAccessTime());
        byteBuffer.putLong(valueHolder.expirationTime());
        byteBuffer.putLong(0L);
        byteBuffer.put(serialized);
        byteBuffer.flip();
        return byteBuffer;
    }

    @Override
    public OffHeapValueHolder<V> decode(ByteBuffer byteBuffer) {
        return this.decode(byteBuffer, null);
    }

    @Override
    public boolean equals(Object o, ByteBuffer byteBuffer) {
        return o.equals(this.decode(byteBuffer));
    }

    @Override
    public OffHeapValueHolder<V> decode(ByteBuffer byteBuffer, WriteContext writeContext) {
        long id = byteBuffer.getLong();
        long creationTime = byteBuffer.getLong();
        long lastAccessTime = byteBuffer.getLong();
        long expireTime = byteBuffer.getLong();
        byteBuffer.getLong();
        return this.createLazyOffHeapValueHolder(id, byteBuffer.slice(), this.serializer, creationTime, expireTime, lastAccessTime, writeContext);
    }

    protected OffHeapValueHolder<V> createLazyOffHeapValueHolder(long id, ByteBuffer byteBuffer, Serializer<V> serializer, long creationTime, long expireTime, long lastAccessTime, WriteContext writeContext) {
        return new LazyOffHeapValueHolder<V>(id, byteBuffer, serializer, creationTime, expireTime, lastAccessTime, writeContext);
    }
}

