/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.storetests;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import junit.framework.Test;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.CleanDatabaseTestSetup;
import org.apache.derbyTesting.junit.DatabasePropertyTestSetup;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.TestConfiguration;

public class Derby94Test
extends BaseJDBCTestCase {
    public Derby94Test(String name) {
        super(name);
    }

    public static Test suite() {
        Object test = TestConfiguration.embeddedSuite(Derby94Test.class);
        test = DatabasePropertyTestSetup.singleProperty(test, "derby.locks.escalationThreshold", "102");
        test = new CleanDatabaseTestSetup((Test)test);
        return test;
    }

    public void testDerby94() throws SQLException {
        this.setAutoCommit(false);
        PreparedStatement locktable = this.prepareStatement("select type, lockcount, mode, tablename, lockname, state from syscs_diag.lock_table order by tablename, type desc, mode, lockcount, lockname");
        Statement s = this.createStatement();
        s.execute("create table t1(c1 int, c2 int not null primary key)");
        s.execute("create table t2(c1 int)");
        PreparedStatement ins1 = this.prepareStatement("insert into t1 values (?, ?)");
        for (int i = 0; i < 160; ++i) {
            ins1.setInt(1, i);
            ins1.setInt(2, 200 + i);
            ins1.execute();
        }
        s.execute("insert into t2 values 0, 1, 2, 3, 4, 5, 6, 7, 8, 9");
        this.commit();
        Statement s1 = this.createStatement(1003, 1008);
        ResultSet rs1 = s1.executeQuery("select * from t1 for update of c1");
        Derby94Test.assertTrue((boolean)rs1.next());
        Derby94Test.assertEquals((int)0, (int)rs1.getInt("c1"));
        Derby94Test.assertEquals((int)200, (int)rs1.getInt("c2"));
        rs1.updateInt("c1", 999);
        rs1.updateRow();
        Derby94Test.assertTrue((boolean)rs1.next());
        Derby94Test.assertEquals((int)1, (int)rs1.getInt("c1"));
        Derby94Test.assertEquals((int)201, (int)rs1.getInt("c2"));
        Statement s2 = this.createStatement(1003, 1008);
        ResultSet rs2 = s2.executeQuery("select * from t2 for update of c1");
        Derby94Test.assertTrue((boolean)rs2.next());
        Derby94Test.assertEquals((int)0, (int)rs2.getInt("c1"));
        JDBC.assertFullResultSet(locktable.executeQuery(), new String[][]{{"TABLE", "2", "IX", "T1", "Tablelock", "GRANT"}, {"ROW", "1", "U", "T1", "(1,8)", "GRANT"}, {"ROW", "1", "X", "T1", "(1,7)", "GRANT"}, {"TABLE", "1", "IX", "T2", "Tablelock", "GRANT"}, {"ROW", "1", "U", "T2", "(1,7)", "GRANT"}});
        Derby94Test.assertUpdateCount(s, 160, "insert into t2 select c1 from t1");
        JDBC.assertFullResultSet(locktable.executeQuery(), new String[][]{{"TABLE", "3", "IX", "T1", "Tablelock", "GRANT"}, {"ROW", "1", "U", "T1", "(1,8)", "GRANT"}, {"ROW", "1", "X", "T1", "(1,7)", "GRANT"}, {"TABLE", "4", "IX", "T2", "Tablelock", "GRANT"}, {"TABLE", "1", "X", "T2", "Tablelock", "GRANT"}});
        Derby94Test.assertUpdateCount(s, 160, "update t1 set c1 = c1 + 999");
        JDBC.assertFullResultSet(locktable.executeQuery(), new String[][]{{"TABLE", "8", "IX", "T1", "Tablelock", "GRANT"}, {"TABLE", "1", "X", "T1", "Tablelock", "GRANT"}, {"TABLE", "4", "IX", "T2", "Tablelock", "GRANT"}, {"TABLE", "1", "X", "T2", "Tablelock", "GRANT"}});
        rs1.close();
        rs2.close();
        this.commit();
        JDBC.assertEmpty(locktable.executeQuery());
    }
}

